/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text.renderers;

import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.LineRenderer;
import com.taobao.text.Renderer;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.Overflow;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.ui.TreeElement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MBeanInfoRenderer
extends Renderer<MBeanInfo> {
    @Override
    public Class<MBeanInfo> getType() {
        return MBeanInfo.class;
    }

    @Override
    public LineRenderer renderer(Iterator<MBeanInfo> stream) {
        ArrayList<LineRenderer> renderers = new ArrayList<LineRenderer>();
        while (stream.hasNext()) {
            MBeanInfo info = stream.next();
            TreeElement root = new TreeElement(info.getClassName());
            TableElement descriptor = new TableElement().overflow(Overflow.HIDDEN).rightCellPadding(1);
            Descriptor descriptorInfo = info.getDescriptor();
            if (descriptorInfo != null) {
                for (String fieldName : descriptorInfo.getFieldNames()) {
                    String fieldValue = String.valueOf(descriptorInfo.getFieldValue(fieldName));
                    descriptor.row(fieldName, fieldValue);
                }
            }
            TableElement attributes = new TableElement().overflow(Overflow.HIDDEN).rightCellPadding(1).add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add("NAME", "TYPE", "DESCRIPTION"));
            for (MBeanAttributeInfo attributeInfo : info.getAttributes()) {
                attributes.row(attributeInfo.getName(), attributeInfo.getType(), attributeInfo.getDescription());
            }
            TreeElement operations = new TreeElement("Operations");
            for (MBeanOperationInfo operationInfo : info.getOperations()) {
                String impact;
                MBeanParameterInfo[] parameterInfos;
                TableElement signature = new TableElement().overflow(Overflow.HIDDEN).rightCellPadding(1);
                for (MBeanParameterInfo parameterInfo : parameterInfos = operationInfo.getSignature()) {
                    signature.row(parameterInfo.getName(), parameterInfo.getType(), parameterInfo.getDescription());
                }
                TreeElement operation = new TreeElement(operationInfo.getName());
                switch (operationInfo.getImpact()) {
                    case 1: {
                        impact = "ACTION";
                        break;
                    }
                    case 0: {
                        impact = "INFO";
                        break;
                    }
                    case 2: {
                        impact = "ACTION_INFO";
                        break;
                    }
                    default: {
                        impact = "UNKNOWN";
                    }
                }
                operation.addChild(new TableElement().add(new RowElement().add("Type: ", operationInfo.getReturnType()), new RowElement().add("Description: ", operationInfo.getDescription()), new RowElement().add("Impact: ", impact), new RowElement().add(new LabelElement("Signature: "), signature)));
                operations.addChild(operation);
            }
            root.addChild(new TableElement().leftCellPadding(1).overflow(Overflow.HIDDEN).row("ClassName", info.getClassName()).row("Description", info.getDescription()));
            root.addChild(new TreeElement("Descriptor").addChild(descriptor));
            root.addChild(new TreeElement("Attributes").addChild(attributes));
            root.addChild(operations);
            renderers.add(root.renderer());
        }
        return LineRenderer.vertical(renderers);
    }
}

