/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import java.util.HashMap;
import java.util.Map;

public enum TSDBError {
    TSDB_CODE_SUCCESS(0L, "success"),
    TSDB_CODE_ACTION_IN_PROGRESS(1L, "in progress"),
    TSDB_CODE_LAST_SESSION_NOT_FINISHED(5L, "last session not finished"),
    TSDB_CODE_INVALID_SESSION_ID(6L, "invalid session ID"),
    TSDB_CODE_INVALID_TRAN_ID(7L, "invalid tran ID"),
    TSDB_CODE_INVALID_MSG_TYPE(8L, "invalid msg type"),
    TSDB_CODE_ALREADY_PROCESSED(9L, "alredy processed"),
    TSDB_CODE_AUTH_FAILURE(10L, "authentication failure"),
    TSDB_CODE_WRONG_MSG_SIZE(11L, "wrong msg size"),
    TSDB_CODE_UNEXPECTED_RESPONSE(12L, "unexpected response"),
    TSDB_CODE_INVALID_RESPONSE_TYPE(13L, "invalid response type"),
    TSDB_CODE_NO_RESOURCE(14L, "no resource"),
    TSDB_CODE_INVALID_TIME_STAMP(15L, "invalid time stamp"),
    TSDB_CODE_MISMATCHED_METER_ID(16L, "mismatched meter ID"),
    TSDB_CODE_ACTION_TRANS_NOT_FINISHED(17L, "transcation not finished"),
    TSDB_CODE_ACTION_NOT_ONLINE(18L, "not online"),
    TSDB_CODE_ACTION_SEND_FAILD(19L, "send failed"),
    TSDB_CODE_NOT_ACTIVE_SESSION(20L, "not active session"),
    TSDB_CODE_INSERT_FAILED(21L, "insert failed"),
    TSDB_CODE_APP_ERROR(22L, "App error"),
    TSDB_CODE_INVALID_IE(23L, "invalid IE"),
    TSDB_CODE_INVALID_VALUE(24L, "invalid value"),
    TSDB_CODE_REDIRECT(25L, "service not available"),
    TSDB_CODE_ALREADY_THERE(26L, "already there"),
    TSDB_CODE_INVALID_METER_ID(27L, "invalid meter ID"),
    TSDB_CODE_INVALID_SQL(28L, "invalid SQL"),
    TSDB_CODE_NETWORK_UNAVAIL(29L, "failed to connect to server"),
    TSDB_CODE_INVALID_MSG_LEN(30L, "invalid msg len"),
    TSDB_CODE_INVALID_DB(31L, "invalid DB"),
    TSDB_CODE_INVALID_TABLE(32L, "invalid table"),
    TSDB_CODE_DB_ALREADY_EXIST(33L, "DB already there"),
    TSDB_CODE_TABLE_ALREADY_EXIST(34L, "table already there"),
    TSDB_CODE_INVALID_USER(35L, "invalid user name"),
    TSDB_CODE_INVALID_ACCT(36L, "invalid acct name"),
    TSDB_CODE_INVALID_PASS(37L, "invalid password"),
    TSDB_CODE_DB_NOT_SELECTED(38L, "DB not selected"),
    TSDB_CODE_MEMORY_CORRUPTED(39L, "memory corrupted"),
    TSDB_CODE_USER_ALREADY_EXIST(40L, "user name exists"),
    TSDB_CODE_NO_RIGHTS(41L, "not authorized"),
    TSDB_CODE_DISCONNECTED(42L, "login disconnected), login again"),
    TSDB_CODE_NO_MASTER(43L, "mgmt master node not available"),
    TSDB_CODE_NOT_CONFIGURED(44L, "not configured"),
    TSDB_CODE_INVALID_OPTION(45L, "invalid option"),
    TSDB_CODE_NODE_OFFLINE(46L, "node offline"),
    TSDB_CODE_SYNC_REQUIRED(47L, "sync required"),
    TSDB_CODE_NO_ENOUGH_PNODES(48L, "more dnodes are needed"),
    TSDB_CODE_UNSYNCED(49L, "node in unsynced state"),
    TSDB_CODE_TOO_SLOW(50L, "too slow"),
    TSDB_CODE_OTHERS(51L, "others"),
    TSDB_CODE_NO_REMOVE_MASTER(52L, "can't remove dnode which is master"),
    TSDB_CODE_WRONG_SCHEMA(53L, "wrong schema"),
    TSDB_CODE_NO_RESULT(54L, "no results"),
    TSDB_CODE_TOO_MANY_USERS(55L, "num of users execeed maxUsers"),
    TSDB_CODE_TOO_MANY_DATABSES(56L, "num of databases execeed maxDbs"),
    TSDB_CODE_TOO_MANY_TABLES(57L, "num of tables execeed maxTables"),
    TSDB_CODE_TOO_MANY_DNODES(58L, "num of dnodes execeed maxDnodes"),
    TSDB_CODE_TOO_MANY_ACCTS(59L, "num of accounts execeed maxAccts"),
    TSDB_CODE_ACCT_ALREADY_EXIST(60L, "accout name exists"),
    TSDB_CODE_DNODE_ALREADY_EXIST(61L, "dnode ip exists"),
    TSDB_CODE_SDB_ERROR(62L, "sdb error"),
    TSDB_CODE_METRICMETA_EXPIRED(63L, "metric meta expired"),
    TSDB_CODE_NOT_READY(64L, "not ready"),
    TSDB_CODE_MAX_SESSIONS(65L, "too many sessions on server"),
    TSDB_CODE_MAX_CONNECTIONS(66L, "too many sessions from app"),
    TSDB_CODE_SESSION_ALREADY_EXIST(67L, "session to dest is already there"),
    TSDB_CODE_NO_QSUMMARY(68L, "query list not there), please show again"),
    TSDB_CODE_SERV_OUT_OF_MEMORY(69L, "server out of memory"),
    TSDB_CODE_INVALID_QHANDLE(70L, "invalid query handle"),
    TSDB_CODE_RELATED_TABLES_EXIST(71L, "tables related to metric exist"),
    TSDB_CODE_MONITOR_DB_FORBEIDDEN(72L, "can't drop monitor database or tables"),
    TSDB_CODE_VG_COMMITLOG_INIT_FAILED(73L, "commit log init failed"),
    TSDB_CODE_VG_INIT_FAILED(74L, "vgroup init failed"),
    TSDB_CODE_DATA_ALREADY_IMPORTED(75L, "data is already imported"),
    TSDB_CODE_OPS_NOT_SUPPORT(76L, "not supported operation"),
    TSDB_CODE_INVALID_QUERY_ID(77L, "invalid query id string"),
    TSDB_CODE_INVALID_STREAM_ID(78L, "invalid stream id string"),
    TSDB_CODE_INVALID_CONNECTION(79L, "invalid connection string"),
    TSDB_CODE_ACTION_NOT_BALANCED(80L, "dnode not balanced"),
    TSDB_CODE_CLI_OUT_OF_MEMORY(81L, "client out of memory"),
    TSDB_CODE_DATA_OVERFLOW(82L, "data value overflow"),
    TSDB_CODE_QUERY_CANCELLED(83L, "query cancelled"),
    TSDB_CODE_GRANT_POINT_LIMITED(84L, "grant points limited"),
    TSDB_CODE_GRANT_EXPIRED(85L, "grant expired"),
    TSDB_CODE_CLI_NO_DISKSPACE(86L, "client no disk space"),
    TSDB_CODE_FILE_CORRUPTED(87L, "DB file corrupted"),
    TSDB_CODE_INVALID_CLIENT_VERSION(88L, "version of client and server not match");

    private long errCode;
    private String errMessage;
    private static Map<Integer, String> errorCodeMap;

    private TSDBError(long code, String message) {
        this.errCode = code;
        this.errMessage = message;
    }

    public long getErrCode() {
        return this.errCode;
    }

    public String getErrMessage() {
        return this.errMessage;
    }

    public static String getErrMessageByCode(long errCode) {
        return errorCodeMap.get(errCode);
    }

    static {
        errorCodeMap = new HashMap<Integer, String>(86);
        errorCodeMap.put(0, "success");
        errorCodeMap.put(1, "in progress");
        errorCodeMap.put(5, "last session not finished");
        errorCodeMap.put(6, "invalid session ID");
        errorCodeMap.put(7, "invalid tran ID");
        errorCodeMap.put(8, "invalid msg type");
        errorCodeMap.put(9, "alredy processed");
        errorCodeMap.put(10, "authentication failure");
        errorCodeMap.put(11, "wrong msg size");
        errorCodeMap.put(12, "unexpected response");
        errorCodeMap.put(13, "invalid response type");
        errorCodeMap.put(14, "no resource");
        errorCodeMap.put(15, "invalid time stamp");
        errorCodeMap.put(16, "mismatched meter ID");
        errorCodeMap.put(17, "transcation not finished");
        errorCodeMap.put(18, "not online");
        errorCodeMap.put(19, "send failed");
        errorCodeMap.put(20, "not active session");
        errorCodeMap.put(21, "insert failed");
        errorCodeMap.put(22, "App error");
        errorCodeMap.put(23, "invalid IE");
        errorCodeMap.put(24, "invalid value");
        errorCodeMap.put(25, "service not available");
        errorCodeMap.put(26, "already there");
        errorCodeMap.put(27, "invalid meter ID");
        errorCodeMap.put(28, "invalid SQL");
        errorCodeMap.put(29, "failed to connect to server");
        errorCodeMap.put(30, "invalid msg len");
        errorCodeMap.put(31, "invalid DB");
        errorCodeMap.put(32, "invalid table");
        errorCodeMap.put(33, "DB already there");
        errorCodeMap.put(34, "table already there");
        errorCodeMap.put(35, "invalid user name");
        errorCodeMap.put(36, "invalid acct name");
        errorCodeMap.put(37, "invalid password");
        errorCodeMap.put(38, "DB not selected");
        errorCodeMap.put(39, "memory corrupted");
        errorCodeMap.put(40, "user name exists");
        errorCodeMap.put(41, "not authorized");
        errorCodeMap.put(42, "login disconnected); login again");
        errorCodeMap.put(43, "mgmt master node not available");
        errorCodeMap.put(44, "not configured");
        errorCodeMap.put(45, "invalid option");
        errorCodeMap.put(46, "node offline");
        errorCodeMap.put(47, "sync required");
        errorCodeMap.put(48, "more dnodes are needed");
        errorCodeMap.put(49, "node in unsynced state");
        errorCodeMap.put(50, "too slow");
        errorCodeMap.put(51, "others");
        errorCodeMap.put(52, "can't remove dnode which is master");
        errorCodeMap.put(53, "wrong schema");
        errorCodeMap.put(54, "no results");
        errorCodeMap.put(55, "num of users execeed maxUsers");
        errorCodeMap.put(56, "num of databases execeed maxDbs");
        errorCodeMap.put(57, "num of tables execeed maxTables");
        errorCodeMap.put(58, "num of dnodes execeed maxDnodes");
        errorCodeMap.put(59, "num of accounts execeed maxAccts");
        errorCodeMap.put(60, "accout name exists");
        errorCodeMap.put(61, "dnode ip exists");
        errorCodeMap.put(62, "sdb error");
        errorCodeMap.put(63, "metric meta expired");
        errorCodeMap.put(64, "not ready");
        errorCodeMap.put(65, "too many sessions on server");
        errorCodeMap.put(66, "too many sessions from app");
        errorCodeMap.put(67, "session to dest is already there");
        errorCodeMap.put(68, "query list not there); please show again");
        errorCodeMap.put(69, "server out of memory");
        errorCodeMap.put(70, "invalid query handle");
        errorCodeMap.put(71, "tables related to metric exist");
        errorCodeMap.put(72, "can't drop monitor database or tables");
        errorCodeMap.put(73, "commit log init failed");
        errorCodeMap.put(74, "vgroup init failed");
        errorCodeMap.put(75, "data is already imported");
        errorCodeMap.put(76, "not supported operation");
        errorCodeMap.put(77, "invalid query id string");
        errorCodeMap.put(78, "invalid stream id string");
        errorCodeMap.put(79, "invalid connection string");
        errorCodeMap.put(80, "dnode not balanced");
        errorCodeMap.put(81, "client out of memory");
        errorCodeMap.put(82, "data value overflow");
        errorCodeMap.put(83, "query cancelled");
        errorCodeMap.put(84, "grant points limited");
        errorCodeMap.put(85, "grant expired");
        errorCodeMap.put(86, "client no disk space");
        errorCodeMap.put(87, "DB file corrupted");
        errorCodeMap.put(88, "version of client and server not match");
    }
}

