/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBResultSet;
import java.sql.SQLException;

public class TSDBSubscribe {
    private final TSDBJNIConnector connecter;
    private final long id;

    TSDBSubscribe(TSDBJNIConnector connecter, long id) throws SQLException {
        if (connecter == null) {
            throw TSDBError.createSQLException(9044);
        }
        this.connecter = connecter;
        this.id = id;
    }

    public TSDBResultSet consume() throws SQLException {
        if (this.connecter.isClosed()) {
            throw TSDBError.createSQLException(9044);
        }
        long resultSetPointer = this.connecter.consume(this.id);
        if (resultSetPointer == -2L) {
            throw TSDBError.createSQLException(9044);
        }
        if (resultSetPointer == 0L) {
            return null;
        }
        return new TSDBResultSet(null, this.connecter, resultSetPointer);
    }

    public void close(boolean keepProgress) throws SQLException {
        if (this.connecter.isClosed()) {
            throw TSDBError.createSQLException(9044);
        }
        this.connecter.unsubscribe(this.id, keepProgress);
    }
}

