/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.ws.ResponseFuture;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class InFlightRequest
implements AutoCloseable {
    private final int timeoutSec;
    private final Semaphore semaphore;
    private final Map<String, ResponseFuture> futureMap = new ConcurrentHashMap<String, ResponseFuture>();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final ScheduledFuture<?> scheduledFuture;

    public InFlightRequest(int timeoutSec, int concurrentNum) {
        this.timeoutSec = timeoutSec;
        this.semaphore = new Semaphore(concurrentNum);
        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(this::removeTimeoutFuture, timeoutSec, timeoutSec, TimeUnit.MILLISECONDS);
    }

    public void put(ResponseFuture responseFuture) throws InterruptedException, TimeoutException {
        if (!this.semaphore.tryAcquire(this.timeoutSec, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException();
        }
        this.futureMap.put(responseFuture.getId(), responseFuture);
    }

    public ResponseFuture remove(String id) {
        ResponseFuture future = this.futureMap.remove(id);
        if (null != future) {
            this.semaphore.release();
        }
        return future;
    }

    private void removeTimeoutFuture() {
        this.futureMap.entrySet().removeIf(entry -> {
            if (System.nanoTime() - ((ResponseFuture)entry.getValue()).getTimestamp() > (long)this.timeoutSec * 1000000L) {
                try {
                    ((ResponseFuture)entry.getValue()).getFuture().completeExceptionally(new TimeoutException());
                }
                finally {
                    this.semaphore.release();
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public void close() {
        this.scheduledFuture.cancel(true);
        this.scheduledExecutorService.shutdown();
    }
}

