/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.entity;

import com.alibaba.fastjson.JSON;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.ConnectReq;
import com.taosdata.jdbc.ws.entity.FetchReq;
import com.taosdata.jdbc.ws.entity.IdUtil;
import com.taosdata.jdbc.ws.entity.Payload;
import com.taosdata.jdbc.ws.entity.QueryReq;

public class Request {
    private String action;
    private Payload args;

    public Request(String action, Payload args) {
        this.action = action;
        this.args = args;
    }

    public String id() {
        return this.action + "_" + this.args.getReqId();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Payload getArgs() {
        return this.args;
    }

    public void setArgs(Payload args) {
        this.args = args;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public static Request generateConnect(String user, String password, String db) {
        long reqId = IdUtil.getId(Action.CONN.getAction());
        ConnectReq connectReq = new ConnectReq(reqId, user, password, db);
        return new Request(Action.CONN.getAction(), connectReq);
    }

    public static Request generateQuery(String sql) {
        long reqId = IdUtil.getId(Action.QUERY.getAction());
        QueryReq queryReq = new QueryReq(reqId, sql);
        return new Request(Action.QUERY.getAction(), queryReq);
    }

    public static Request generateFetch(long id) {
        long reqId = IdUtil.getId(Action.FETCH.getAction());
        FetchReq fetchReq = new FetchReq(reqId, id);
        return new Request(Action.FETCH.getAction(), fetchReq);
    }

    public static Request generateFetchJson(long id) {
        long reqId = IdUtil.getId(Action.FETCH_JSON.getAction());
        FetchReq fetchReq = new FetchReq(reqId, id);
        return new Request(Action.FETCH_JSON.getAction(), fetchReq);
    }

    public static Request generateFetchBlock(long id) {
        long reqId = IdUtil.getId(Action.FETCH_BLOCK.getAction());
        FetchReq fetchReq = new FetchReq(reqId, id);
        return new Request(Action.FETCH_BLOCK.getAction(), fetchReq);
    }
}

