/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

public class NullType {
    private static final byte NULL_BOOL_VAL = 2;
    private static final String NULL_STR = "null";

    public String toString() {
        return NULL_STR;
    }

    public static boolean isBooleanNull(byte val) {
        return val == 2;
    }

    public static boolean isTinyIntNull(byte val) {
        return val == -128;
    }

    public static boolean isUnsignedTinyIntNull(byte val) {
        return val == -1;
    }

    public static boolean isSmallIntNull(short val) {
        return val == Short.MIN_VALUE;
    }

    public static boolean isUnsignedSmallIntNull(short val) {
        return val == -1;
    }

    public static boolean isIntNull(int val) {
        return val == Integer.MIN_VALUE;
    }

    public static boolean isUnsignedIntNull(int val) {
        return val == -1;
    }

    public static boolean isBigIntNull(long val) {
        return val == Long.MIN_VALUE;
    }

    public static boolean isUnsignedBigIntNull(long val) {
        return val == -1L;
    }

    public static boolean isFloatNull(float val) {
        return Float.isNaN(val);
    }

    public static boolean isDoubleNull(double val) {
        return Double.isNaN(val);
    }

    public static boolean isBinaryNull(byte[] val, int length) {
        if (length != 1) {
            return false;
        }
        return val[0] == -1;
    }

    public static boolean isNcharNull(byte[] val, int length) {
        if (length != 4) {
            return false;
        }
        return (val[0] & val[1] & val[2] & val[3] & 0xFF) == 255;
    }

    public static byte getBooleanNull() {
        return 2;
    }

    public static byte getTinyintNull() {
        return -128;
    }

    public static int getIntNull() {
        return Integer.MIN_VALUE;
    }

    public static short getSmallIntNull() {
        return Short.MIN_VALUE;
    }

    public static long getBigIntNull() {
        return Long.MIN_VALUE;
    }

    public static int getFloatNull() {
        return 0x7FF00000;
    }

    public static long getDoubleNull() {
        return 0x7FFFFF0000000000L;
    }

    public static byte getBinaryNull() {
        return -1;
    }

    public static byte[] getNcharNull() {
        return new byte[]{-1, -1, -1, -1};
    }
}

