/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.tmq;

import com.taosdata.jdbc.tmq.ConsumerRecord;
import com.taosdata.jdbc.tmq.TopicPartition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConsumerRecords<V>
implements Iterable<ConsumerRecord<V>> {
    public static final ConsumerRecords<?> EMPTY = new ConsumerRecords(Collections.emptyMap());
    private long offset;
    private final Map<TopicPartition, List<ConsumerRecord<V>>> records;

    public ConsumerRecords(Map<TopicPartition, List<ConsumerRecord<V>>> records) {
        this.records = records;
    }

    public ConsumerRecords(long offset) {
        this.records = new HashMap<TopicPartition, List<ConsumerRecord<V>>>();
        this.offset = offset;
    }

    protected long getOffset() {
        return this.offset;
    }

    public void put(TopicPartition tp, ConsumerRecord<V> r) {
        if (this.records.containsKey(tp)) {
            this.records.get(tp).add(r);
        } else {
            ArrayList<ConsumerRecord<V>> list = new ArrayList<ConsumerRecord<V>>();
            list.add(r);
            this.records.put(tp, list);
        }
    }

    public List<ConsumerRecord<V>> get(TopicPartition partition) {
        List<ConsumerRecord<V>> recs = this.records.get(partition);
        if (recs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(recs);
    }

    @Override
    public Iterator<ConsumerRecord<V>> iterator() {
        return new Iterator<ConsumerRecord<V>>(){
            final Iterator<? extends Iterable<ConsumerRecord<V>>> iters;
            Iterator<ConsumerRecord<V>> current;
            {
                this.iters = ConsumerRecords.this.records.values().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.current == null || !this.current.hasNext()) {
                    if (this.iters.hasNext()) {
                        this.current = this.iters.next().iterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public ConsumerRecord<V> next() {
                return this.current.next();
            }
        };
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public static <T> ConsumerRecords<T> emptyRecord() {
        return EMPTY;
    }
}

