/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBParameterMetaData;
import com.taosdata.jdbc.common.ColumnInfo;
import com.taosdata.jdbc.common.SerializeBlock;
import com.taosdata.jdbc.enums.BindType;
import com.taosdata.jdbc.enums.TimestampPrecision;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.utils.SqlSyntaxValidator;
import com.taosdata.jdbc.utils.Utils;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSConnection;
import com.taosdata.jdbc.ws.WSStatement;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import com.taosdata.jdbc.ws.stmt.entity.ExecResp;
import com.taosdata.jdbc.ws.stmt.entity.RequestFactory;
import com.taosdata.jdbc.ws.stmt.entity.STMTAction;
import com.taosdata.jdbc.ws.stmt.entity.StmtResp;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TSWSPreparedStatement
extends WSStatement
implements PreparedStatement {
    private static final Pattern INSERT_PATTERN = Pattern.compile("insert\\s+into\\s+(\\w+|\\?)\\s+(using\\s+(\\w+)\\s+tags\\s*\\(.*\\))?\\s*values\\s*\\(.*\\)");
    private final ConnectionParam param;
    private Transport prepareTransport;
    private long reqId;
    private long stmtId;
    private final String rawSql;
    private int queryTimeout = 0;
    private int precision = 0;
    private final Map<Integer, Column> column = new HashMap<Integer, Column>();
    private final Map<Integer, Column> tag = new HashMap<Integer, Column>();
    private final List<ColumnInfo> data = new ArrayList<ColumnInfo>();
    private final PriorityQueue<ColumnInfo> queue = new PriorityQueue();

    public TSWSPreparedStatement(Transport transport, Transport prepareTransport, ConnectionParam param, String database, Connection connection, String sql) throws SQLException {
        super(transport, database, connection);
        ResultSet resultSet;
        this.prepareTransport = prepareTransport;
        this.rawSql = sql;
        this.param = param;
        if (!sql.contains("?")) {
            return;
        }
        String useDb = null;
        Matcher matcher = INSERT_PATTERN.matcher(sql);
        if (matcher.find()) {
            String[] split;
            String usingGroup;
            if (matcher.group(1).equals("?") && matcher.group(3) != null) {
                usingGroup = matcher.group(3);
                if (usingGroup.contains(".")) {
                    split = usingGroup.split("\\.");
                    useDb = split[0];
                }
            } else {
                usingGroup = matcher.group(1);
                if (usingGroup.contains(".")) {
                    split = usingGroup.split("\\.");
                    useDb = split[0];
                }
            }
        }
        if (useDb == null && database != null) {
            useDb = database;
        }
        if (useDb != null && (resultSet = this.executeQuery("select `precision` from information_schema.ins_databases where name = '" + useDb + "'")).next()) {
            String tmp = resultSet.getString(1);
            this.precision = TimestampPrecision.getPrecision(tmp);
        }
        this.reqId = ReqId.getReqID();
        Request request = RequestFactory.generateInit(this.reqId);
        StmtResp resp = (StmtResp)prepareTransport.send(request);
        if (Code.SUCCESS.getCode() != resp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(resp.getCode()) + ":" + resp.getMessage());
        }
        this.stmtId = resp.getStmtId();
        Request prepare = RequestFactory.generatePrepare(this.stmtId, this.reqId, sql);
        StmtResp prepareResp = (StmtResp)prepareTransport.send(prepare);
        if (Code.SUCCESS.getCode() != prepareResp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(prepareResp.getCode()) + ":" + prepareResp.getMessage());
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
        this.prepareTransport.setTimeout((long)seconds * 1000L);
    }

    private void checkUseStatement(String sql) throws SQLException {
        if (sql == null || sql.isEmpty()) {
            throw new SQLException("sql is empty");
        }
        if (SqlSyntaxValidator.isUseSql(sql)) {
            this.prepareTransport.shutdown();
            String database = SqlSyntaxValidator.getDatabaseName(sql);
            if (null != database) {
                this.prepareTransport = WSConnection.initPrepareTransport(this.param, database);
                ResultSet resultSet = this.executeQuery("select `precision` from information_schema.ins_databases where name = '" + database + "'");
                if (resultSet.next()) {
                    String tmp = resultSet.getString(1);
                    this.precision = TimestampPrecision.getPrecision(tmp);
                }
                this.reqId = ReqId.getReqID();
                Request request = RequestFactory.generateInit(this.reqId);
                StmtResp resp = (StmtResp)this.prepareTransport.send(request);
                if (Code.SUCCESS.getCode() != resp.getCode()) {
                    throw new SQLException("0x" + Integer.toHexString(resp.getCode()) + ":" + resp.getMessage());
                }
                this.stmtId = resp.getStmtId();
                Request prepare = RequestFactory.generatePrepare(this.stmtId, this.reqId, this.rawSql);
                StmtResp prepareResp = (StmtResp)this.prepareTransport.send(prepare);
                if (Code.SUCCESS.getCode() != prepareResp.getCode()) {
                    throw new SQLException("0x" + Integer.toHexString(prepareResp.getCode()) + ":" + prepareResp.getMessage());
                }
            }
        }
    }

    @Override
    public boolean execute(String sql, Long reqId) throws SQLException {
        this.checkUseStatement(sql);
        return super.execute(sql, reqId);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ArrayList list = new ArrayList();
        if (!this.tag.isEmpty()) {
            this.tag.keySet().stream().sorted().forEach(i -> {
                Column col = this.tag.get(i);
                list.add(col.data);
            });
        }
        if (!this.column.isEmpty()) {
            this.column.keySet().stream().sorted().forEach(i -> {
                Column col = this.column.get(i);
                list.add(col.data);
            });
        }
        Object[] parameters = list.toArray(new Object[0]);
        this.clearParameters();
        String sql = Utils.getNativeSql(this.rawSql, parameters);
        return this.executeQuery(sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        byte[] rawBlock;
        StmtResp bindResp;
        List<ColumnInfo> collect;
        if (this.column.isEmpty()) {
            throw new SQLException("no parameter to execute");
        }
        if (!this.data.isEmpty()) {
            throw TSDBError.undeterminedExecutionError();
        }
        if (!this.tag.isEmpty()) {
            byte[] tagBlock;
            collect = this.tag.keySet().stream().sorted().map(i -> {
                Column col = this.tag.get(i);
                return new ColumnInfo((int)i, col.data, col.type);
            }).collect(Collectors.toList());
            try {
                tagBlock = SerializeBlock.getRawBlock(collect, this.precision);
            }
            catch (IOException e) {
                throw new SQLException("data serialize error!", e);
            }
            bindResp = (StmtResp)this.prepareTransport.send(STMTAction.SET_TAGS.getAction(), this.reqId, this.stmtId, BindType.TAG.get(), tagBlock);
            if (Code.SUCCESS.getCode() != bindResp.getCode()) {
                throw new SQLException("0x" + Integer.toHexString(bindResp.getCode()) + ":" + bindResp.getMessage());
            }
        }
        collect = this.column.keySet().stream().sorted().map(i -> {
            Column col = this.column.get(i);
            return new ColumnInfo((int)i, col.data, col.type);
        }).collect(Collectors.toList());
        try {
            rawBlock = SerializeBlock.getRawBlock(collect, this.precision);
        }
        catch (IOException e) {
            throw new SQLException("data serialize error!", e);
        }
        bindResp = (StmtResp)this.prepareTransport.send(STMTAction.BIND.getAction(), this.reqId, this.stmtId, BindType.BIND.get(), rawBlock);
        if (Code.SUCCESS.getCode() != bindResp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(bindResp.getCode()) + ":" + bindResp.getMessage());
        }
        Request batch = RequestFactory.generateBatch(this.stmtId, this.reqId);
        Response send = this.prepareTransport.send(batch);
        StmtResp batchResp = (StmtResp)send;
        if (Code.SUCCESS.getCode() != batchResp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(batchResp.getCode()) + ":" + batchResp.getMessage());
        }
        this.clearParameters();
        Request request = RequestFactory.generateExec(this.stmtId, this.reqId);
        ExecResp resp = (ExecResp)this.prepareTransport.send(request);
        if (Code.SUCCESS.getCode() != resp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(resp.getCode()) + ":" + resp.getMessage());
        }
        Request close = RequestFactory.generateClose(this.stmtId, this.reqId);
        this.prepareTransport.sendWithoutRep(close);
        return resp.getAffected();
    }

    public void setTableName(String name) throws SQLException {
        Request request = RequestFactory.generateSetTableName(this.stmtId, this.reqId, name);
        StmtResp resp = (StmtResp)this.prepareTransport.send(request);
        if (Code.SUCCESS.getCode() != resp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(resp.getCode()) + ":" + resp.getMessage());
        }
    }

    public void setTagSqlTypeNull(int index, int type) throws SQLException {
        switch (type) {
            case 16: {
                this.tag.put(index, new Column(null, 1, index));
                break;
            }
            case -6: {
                this.tag.put(index, new Column(null, 2, index));
                break;
            }
            case 5: {
                this.tag.put(index, new Column(null, 3, index));
                break;
            }
            case 4: {
                this.tag.put(index, new Column(null, 4, index));
                break;
            }
            case -5: {
                this.tag.put(index, new Column(null, 5, index));
                break;
            }
            case 6: {
                this.tag.put(index, new Column(null, 6, index));
                break;
            }
            case 8: {
                this.tag.put(index, new Column(null, 7, index));
                break;
            }
            case 93: {
                this.tag.put(index, new Column(null, 9, index));
                break;
            }
            case -2: 
            case 12: {
                this.tag.put(index, new Column(null, 8, index));
                break;
            }
            case -15: {
                this.tag.put(index, new Column(null, 10, index));
                break;
            }
            case 1111: {
                this.tag.put(index, new Column(null, 15, index));
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + type);
            }
        }
    }

    public void setTagNull(int index, int type) throws SQLException {
        switch (type) {
            case 1: {
                this.tag.put(index, new Column(null, 1, index));
                break;
            }
            case 2: {
                this.tag.put(index, new Column(null, 2, index));
                break;
            }
            case 3: {
                this.tag.put(index, new Column(null, 3, index));
                break;
            }
            case 4: {
                this.tag.put(index, new Column(null, 4, index));
                break;
            }
            case 5: {
                this.tag.put(index, new Column(null, 5, index));
                break;
            }
            case 6: {
                this.tag.put(index, new Column(null, 6, index));
                break;
            }
            case 7: {
                this.tag.put(index, new Column(null, 7, index));
                break;
            }
            case 9: {
                this.tag.put(index, new Column(null, 9, index));
                break;
            }
            case 8: {
                this.tag.put(index, new Column(null, 8, index));
                break;
            }
            case 10: {
                this.tag.put(index, new Column(null, 10, index));
                break;
            }
            case 15: {
                this.tag.put(index, new Column(null, 15, index));
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + type);
            }
        }
    }

    public void setTagBoolean(int index, boolean value) {
        this.tag.put(index, new Column(value, 1, index));
    }

    public void setTagByte(int index, byte value) {
        this.tag.put(index, new Column(value, 2, index));
    }

    public void setTagShort(int index, short value) {
        this.tag.put(index, new Column(value, 3, index));
    }

    public void setTagInt(int index, int value) {
        this.tag.put(index, new Column(value, 4, index));
    }

    public void setTagLong(int index, long value) {
        this.tag.put(index, new Column(value, 5, index));
    }

    public void setTagFloat(int index, float value) {
        this.tag.put(index, new Column(Float.valueOf(value), 6, index));
    }

    public void setTagDouble(int index, double value) {
        this.tag.put(index, new Column(value, 7, index));
    }

    public void setTagTimestamp(int index, long value) {
        this.tag.put(index, new Column(new Timestamp(value), 9, index));
    }

    public void setTagTimestamp(int index, Timestamp value) {
        this.tag.put(index, new Column(value, 9, index));
    }

    public void setTagString(int index, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.tag.put(index, new Column(bytes, 8, index));
    }

    public void setTagNString(int index, String value) {
        this.tag.put(index, new Column(value, 10, index));
    }

    public void setTagJson(int index, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.tag.put(index, new Column(bytes, 15, index));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        switch (sqlType) {
            case 16: {
                this.column.put(parameterIndex, new Column(null, 1, parameterIndex));
                break;
            }
            case -6: {
                this.column.put(parameterIndex, new Column(null, 2, parameterIndex));
                break;
            }
            case 5: {
                this.column.put(parameterIndex, new Column(null, 3, parameterIndex));
                break;
            }
            case 4: {
                this.column.put(parameterIndex, new Column(null, 4, parameterIndex));
                break;
            }
            case -5: {
                this.column.put(parameterIndex, new Column(null, 5, parameterIndex));
                break;
            }
            case 6: {
                this.column.put(parameterIndex, new Column(null, 6, parameterIndex));
                break;
            }
            case 8: {
                this.column.put(parameterIndex, new Column(null, 7, parameterIndex));
                break;
            }
            case 93: {
                this.column.put(parameterIndex, new Column(null, 9, parameterIndex));
                break;
            }
            case -2: 
            case 12: {
                this.column.put(parameterIndex, new Column(null, 8, parameterIndex));
                break;
            }
            case -15: {
                this.column.put(parameterIndex, new Column(null, 10, parameterIndex));
                break;
            }
            case 1111: {
                this.column.put(parameterIndex, new Column(null, 15, parameterIndex));
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + sqlType);
            }
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.column.put(parameterIndex, new Column(x, 1, parameterIndex));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.column.put(parameterIndex, new Column(x, 2, parameterIndex));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.column.put(parameterIndex, new Column(x, 3, parameterIndex));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.column.put(parameterIndex, new Column(x, 4, parameterIndex));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.column.put(parameterIndex, new Column(x, 5, parameterIndex));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.column.put(parameterIndex, new Column(Float.valueOf(x), 6, parameterIndex));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.column.put(parameterIndex, new Column(x, 7, parameterIndex));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        byte[] bytes = x.getBytes(StandardCharsets.UTF_8);
        this.setBytes(parameterIndex, bytes);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.column.put(parameterIndex, new Column(x, 8, parameterIndex));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        Timestamp timestamp = new Timestamp(x.getTime());
        this.setTimestamp(parameterIndex, timestamp);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
            return;
        }
        Timestamp timestamp = new Timestamp(x.getTime());
        this.setTimestamp(parameterIndex, timestamp);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.column.put(parameterIndex, new Column(x, 9, parameterIndex));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.column.clear();
        this.tag.clear();
        this.data.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case 16: {
                this.column.put(parameterIndex, new Column(x, 1, parameterIndex));
                break;
            }
            case -6: {
                this.column.put(parameterIndex, new Column(x, 2, parameterIndex));
                break;
            }
            case 5: {
                this.column.put(parameterIndex, new Column(x, 3, parameterIndex));
                break;
            }
            case 4: {
                this.column.put(parameterIndex, new Column(x, 4, parameterIndex));
                break;
            }
            case -5: {
                this.column.put(parameterIndex, new Column(x, 5, parameterIndex));
                break;
            }
            case 6: {
                this.column.put(parameterIndex, new Column(x, 6, parameterIndex));
                break;
            }
            case 8: {
                this.column.put(parameterIndex, new Column(x, 7, parameterIndex));
                break;
            }
            case 93: {
                this.column.put(parameterIndex, new Column(x, 9, parameterIndex));
                break;
            }
            case -2: 
            case 12: {
                this.column.put(parameterIndex, new Column(x, 8, parameterIndex));
                break;
            }
            case -15: {
                this.column.put(parameterIndex, new Column(x, 10, parameterIndex));
                break;
            }
            case 1111: {
                this.column.put(parameterIndex, new Column(x, 15, parameterIndex));
                break;
            }
            default: {
                throw new SQLException("unsupported type: " + targetSqlType);
            }
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        ArrayList list = new ArrayList();
        if (!this.tag.isEmpty()) {
            this.tag.keySet().stream().sorted().forEach(i -> {
                Column col = this.tag.get(i);
                list.add(col.data);
            });
        }
        if (!this.column.isEmpty()) {
            this.column.keySet().stream().sorted().forEach(i -> {
                Column col = this.column.get(i);
                list.add(col.data);
            });
        }
        Object[] parameters = list.toArray(new Object[0]);
        this.clearParameters();
        String sql = Utils.getNativeSql(this.rawSql, parameters);
        return this.execute(sql);
    }

    @Override
    public void addBatch() throws SQLException {
        List collect = this.column.keySet().stream().sorted().map(this.column::get).collect(Collectors.toList());
        if (this.data.isEmpty()) {
            for (Column col : collect) {
                this.data.add(new ColumnInfo(col.index, col.data, col.type));
            }
        } else {
            if (collect.size() != this.data.size()) {
                throw new SQLException("batch add column size not match, expected: " + this.data.size() + ", actual: " + collect.size());
            }
            for (int i = 0; i < collect.size(); ++i) {
                Column col = (Column)collect.get(i);
                ColumnInfo columnInfo = this.data.get(i);
                if (columnInfo.getIndex() != col.index) {
                    throw new SQLException("batch add column index not match, expected: " + columnInfo.getIndex() + ", actual: " + col.index);
                }
                if (columnInfo.getType() != col.type) {
                    throw new SQLException("batch add column type not match, expected type: " + columnInfo.getType() + ", actual type: " + col.type);
                }
                columnInfo.add(col.data);
            }
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        byte[] rawBlock;
        if (this.column.isEmpty()) {
            throw TSDBError.createSQLException(8966);
        }
        if (!this.tag.isEmpty()) {
            byte[] tagBlock;
            List<ColumnInfo> collect = this.tag.keySet().stream().sorted().map(i -> {
                Column col = this.tag.get(i);
                return new ColumnInfo((int)i, col.data, col.type);
            }).collect(Collectors.toList());
            try {
                tagBlock = SerializeBlock.getRawBlock(collect, this.precision);
            }
            catch (IOException e) {
                throw new SQLException("data serialize error!", e);
            }
            StmtResp bindResp = (StmtResp)this.prepareTransport.send(STMTAction.SET_TAGS.getAction(), this.reqId, this.stmtId, BindType.TAG.get(), tagBlock);
            if (Code.SUCCESS.getCode() != bindResp.getCode()) {
                throw new SQLException("0x" + Integer.toHexString(bindResp.getCode()) + ":" + bindResp.getMessage());
            }
        }
        try {
            rawBlock = SerializeBlock.getRawBlock(this.data, this.precision);
        }
        catch (IOException e) {
            throw new SQLException("data serialize error!", e);
        }
        StmtResp bindResp = (StmtResp)this.prepareTransport.send(STMTAction.BIND.getAction(), this.reqId, this.stmtId, BindType.BIND.get(), rawBlock);
        if (Code.SUCCESS.getCode() != bindResp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(bindResp.getCode()) + ":" + bindResp.getMessage());
        }
        Request batch = RequestFactory.generateBatch(this.stmtId, this.reqId);
        Response send = this.prepareTransport.send(batch);
        StmtResp batchResp = (StmtResp)send;
        if (Code.SUCCESS.getCode() != batchResp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(batchResp.getCode()) + ":" + batchResp.getMessage());
        }
        this.clearParameters();
        Request request = RequestFactory.generateExec(this.stmtId, this.reqId);
        ExecResp resp = (ExecResp)this.prepareTransport.send(request);
        if (Code.SUCCESS.getCode() != resp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(resp.getCode()) + ":" + resp.getMessage());
        }
        int[] ints = new int[resp.getAffected()];
        int len = ints.length;
        for (int i2 = 0; i2 < len; ++i2) {
            ints[i2] = -2;
        }
        return ints;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        Request close = RequestFactory.generateClose(this.stmtId, this.reqId);
        this.prepareTransport.sendWithoutRep(close);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.getResultSet() == null) {
            return null;
        }
        return this.getResultSet().getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        ArrayList list = new ArrayList();
        if (!this.tag.isEmpty()) {
            this.tag.keySet().stream().sorted().forEach(i -> {
                Column col = this.tag.get(i);
                list.add(col.data);
            });
        }
        if (!this.column.isEmpty()) {
            this.column.keySet().stream().sorted().forEach(i -> {
                Column col = this.column.get(i);
                list.add(col.data);
            });
        }
        return new TSDBParameterMetaData(list.toArray(new Object[0]));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.column.put(parameterIndex, new Column(value, 10, parameterIndex));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        throw TSDBError.createSQLException(8962);
    }

    public void setInt(int columnIndex, List<Integer> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 4, 4);
    }

    public void setFloat(int columnIndex, List<Float> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 6, 4);
    }

    public void setTimestamp(int columnIndex, List<Long> list) throws SQLException {
        List collect = list.stream().map(x -> {
            if (x == null) {
                return null;
            }
            return new Timestamp((long)x);
        }).collect(Collectors.toList());
        this.setValueImpl(columnIndex, collect, 9, 8);
    }

    public void setLong(int columnIndex, List<Long> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 5, 8);
    }

    public void setDouble(int columnIndex, List<Double> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 7, 8);
    }

    public void setBoolean(int columnIndex, List<Boolean> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 1, 1);
    }

    public void setByte(int columnIndex, List<Byte> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 2, 1);
    }

    public void setShort(int columnIndex, List<Short> list) throws SQLException {
        this.setValueImpl(columnIndex, list, 3, 2);
    }

    public void setString(int columnIndex, List<String> list, int size) throws SQLException {
        List collect = list.stream().map(x -> {
            if (x == null) {
                return null;
            }
            return x.getBytes(StandardCharsets.UTF_8);
        }).collect(Collectors.toList());
        this.setValueImpl(columnIndex, collect, 8, size);
    }

    public void setNString(int columnIndex, List<String> list, int size) throws SQLException {
        this.setValueImpl(columnIndex, list, 10, size * 4);
    }

    public <T> void setValueImpl(int columnIndex, List<T> list, int type, int bytes) throws SQLException {
        List<Object> listObject = list.stream().map(Object.class::cast).collect(Collectors.toList());
        ColumnInfo p = new ColumnInfo(columnIndex, listObject, type, null);
        this.queue.add(p);
    }

    public void columnDataAddBatch() throws SQLException {
        while (!this.queue.isEmpty()) {
            this.data.add(this.queue.poll());
        }
    }

    public void columnDataExecuteBatch() throws SQLException {
        byte[] rawBlock;
        if (!this.tag.isEmpty()) {
            byte[] tagBlock;
            List<ColumnInfo> collect = this.tag.keySet().stream().sorted().map(i -> {
                Column col = this.tag.get(i);
                return new ColumnInfo((int)i, col.data, col.type);
            }).collect(Collectors.toList());
            try {
                tagBlock = SerializeBlock.getRawBlock(collect, this.precision);
            }
            catch (IOException e) {
                throw new SQLException("data serialize error!", e);
            }
            StmtResp bindResp = (StmtResp)this.prepareTransport.send(STMTAction.SET_TAGS.getAction(), this.reqId, this.stmtId, BindType.TAG.get(), tagBlock);
            if (Code.SUCCESS.getCode() != bindResp.getCode()) {
                throw new SQLException("0x" + Integer.toHexString(bindResp.getCode()) + ":" + bindResp.getMessage());
            }
        }
        try {
            rawBlock = SerializeBlock.getRawBlock(this.data, this.precision);
        }
        catch (IOException e) {
            throw new SQLException("data serialize error!", e);
        }
        StmtResp bindResp = (StmtResp)this.prepareTransport.send(STMTAction.BIND.getAction(), this.reqId, this.stmtId, BindType.BIND.get(), rawBlock);
        if (Code.SUCCESS.getCode() != bindResp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(bindResp.getCode()) + ":" + bindResp.getMessage());
        }
        Request batch = RequestFactory.generateBatch(this.stmtId, this.reqId);
        Response send = this.prepareTransport.send(batch);
        StmtResp batchResp = (StmtResp)send;
        if (Code.SUCCESS.getCode() != batchResp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(batchResp.getCode()) + ":" + batchResp.getMessage());
        }
        this.clearParameters();
        Request request = RequestFactory.generateExec(this.stmtId, this.reqId);
        ExecResp resp = (ExecResp)this.prepareTransport.send(request);
        if (Code.SUCCESS.getCode() != resp.getCode()) {
            throw new SQLException("0x" + Integer.toHexString(resp.getCode()) + ":" + resp.getMessage());
        }
    }

    public void columnDataCloseBatch() throws SQLException {
        this.close();
    }

    static class Column {
        private final Object data;
        private final int type;
        private final int index;

        public Column(Object data, int type, int index) {
            this.data = data;
            this.type = type;
            this.index = index;
        }
    }
}

