/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.common;

import com.taosdata.jdbc.common.ColumnInfo;
import com.taosdata.jdbc.enums.DataLength;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class SerializeBlock {
    private SerializeBlock() {
    }

    private static int bitMapLen(int n) {
        return n + 7 >> 3;
    }

    private static int bitPos(int n) {
        return n & 7;
    }

    private static int charOffset(int n) {
        return n >> 3;
    }

    private static byte bmSetNull(byte c, int n) {
        return (byte)(c + (1 << 7 - SerializeBlock.bitPos(n)));
    }

    public static byte[] getRawBlock(List<ColumnInfo> list, int precision) throws IOException, SQLException {
        int columns = list.size();
        int rows = list.get(0).getDataList().size();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(SerializeBlock.intToBytes(1));
        buffer.write(SerializeBlock.intToBytes(0));
        buffer.write(SerializeBlock.intToBytes(rows));
        buffer.write(SerializeBlock.intToBytes(columns));
        buffer.write(SerializeBlock.intToBytes(0));
        buffer.write(SerializeBlock.longToBytes(0L));
        byte[] colInfoData = new byte[5 * columns];
        byte[] lengthData = new byte[4 * columns];
        int bitMapLen = SerializeBlock.bitMapLen(rows);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        block14: for (int colIndex = 0; colIndex < list.size(); ++colIndex) {
            ColumnInfo column = list.get(colIndex);
            switch (column.getType()) {
                case 1: {
                    colInfoData[colIndex * 5] = 1;
                    int typeLen = DataLength.TSDB_DATA_TYPE_BOOL.getLength();
                    byte[] typeBytes = SerializeBlock.intToBytes(typeLen);
                    System.arraycopy(typeBytes, 0, colInfoData, colIndex * 5 + 1, 4);
                    byte[] array = SerializeBlock.intToBytes(typeLen * rows);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    Object tmp = new byte[bitMapLen + rows];
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        if (rowData.get(rowIndex) == null) {
                            int charOffset = SerializeBlock.charOffset(rowIndex);
                            tmp[charOffset] = SerializeBlock.bmSetNull((byte)tmp[charOffset], rowIndex);
                            continue;
                        }
                        boolean v = (Boolean)rowData.get(rowIndex);
                        if (!v) continue;
                        tmp[bitMapLen + rowIndex] = true;
                    }
                    data.write((byte[])tmp);
                    continue block14;
                }
                case 2: {
                    colInfoData[colIndex * 5] = 2;
                    int typeLen = DataLength.TSDB_DATA_TYPE_TINYINT.getLength();
                    byte[] typeBytes = SerializeBlock.intToBytes(typeLen);
                    System.arraycopy(typeBytes, 0, colInfoData, colIndex * 5 + 1, 4);
                    byte[] array = SerializeBlock.intToBytes(typeLen * rows);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    Object tmp = new byte[bitMapLen + rows];
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        if (rowData.get(rowIndex) == null) {
                            int charOffset = SerializeBlock.charOffset(rowIndex);
                            tmp[charOffset] = SerializeBlock.bmSetNull((byte)tmp[charOffset], rowIndex);
                            continue;
                        }
                        tmp[rowIndex + bitMapLen] = (Byte)rowData.get(rowIndex);
                    }
                    data.write((byte[])tmp);
                    continue block14;
                }
                case 3: {
                    colInfoData[colIndex * 5] = 3;
                    int typeLen = DataLength.TSDB_DATA_TYPE_SMALLINT.getLength();
                    byte[] typeBytes = SerializeBlock.intToBytes(typeLen);
                    System.arraycopy(typeBytes, 0, colInfoData, colIndex * 5 + 1, 4);
                    byte[] array = SerializeBlock.intToBytes(typeLen * rows);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    Object tmp = new byte[bitMapLen + rows * 2];
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        if (rowData.get(rowIndex) == null) {
                            int charOffset = SerializeBlock.charOffset(rowIndex);
                            tmp[charOffset] = SerializeBlock.bmSetNull((byte)tmp[charOffset], rowIndex);
                            continue;
                        }
                        short v = (Short)rowData.get(rowIndex);
                        int offset = rowIndex * 2 + bitMapLen;
                        tmp[offset] = (byte)(v & 0xFF);
                        tmp[offset + 1] = (byte)(v >> 8 & 0xFF);
                    }
                    data.write((byte[])tmp);
                    continue block14;
                }
                case 4: {
                    colInfoData[colIndex * 5] = 4;
                    int typeLen = DataLength.TSDB_DATA_TYPE_INT.getLength();
                    byte[] typeBytes = SerializeBlock.intToBytes(typeLen);
                    System.arraycopy(typeBytes, 0, colInfoData, colIndex * 5 + 1, 4);
                    byte[] array = SerializeBlock.intToBytes(typeLen * rows);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    Object tmp = new byte[bitMapLen + rows * 4];
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        if (rowData.get(rowIndex) == null) {
                            int charOffset = SerializeBlock.charOffset(rowIndex);
                            tmp[charOffset] = SerializeBlock.bmSetNull((byte)tmp[charOffset], rowIndex);
                            continue;
                        }
                        int v = (Integer)rowData.get(rowIndex);
                        int offset = rowIndex * 4 + bitMapLen;
                        tmp[offset] = (byte)(v & 0xFF);
                        tmp[offset + 1] = (byte)(v >> 8 & 0xFF);
                        tmp[offset + 2] = (byte)(v >> 16 & 0xFF);
                        tmp[offset + 3] = (byte)(v >> 24 & 0xFF);
                    }
                    data.write((byte[])tmp);
                    continue block14;
                }
                case 5: {
                    int offset;
                    colInfoData[colIndex * 5] = 5;
                    int typeLen = DataLength.TSDB_DATA_TYPE_BIGINT.getLength();
                    byte[] typeBytes = SerializeBlock.intToBytes(typeLen);
                    System.arraycopy(typeBytes, 0, colInfoData, colIndex * 5 + 1, 4);
                    byte[] array = SerializeBlock.intToBytes(typeLen * rows);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    Object tmp = new byte[bitMapLen + rows * 8];
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        if (rowData.get(rowIndex) == null) {
                            int charOffset = SerializeBlock.charOffset(rowIndex);
                            tmp[charOffset] = SerializeBlock.bmSetNull((byte)tmp[charOffset], rowIndex);
                            continue;
                        }
                        long v = (Long)rowData.get(rowIndex);
                        offset = rowIndex * 8 + bitMapLen;
                        tmp[offset] = (byte)(v & 0xFFL);
                        tmp[offset + 1] = (byte)(v >> 8 & 0xFFL);
                        tmp[offset + 2] = (byte)(v >> 16 & 0xFFL);
                        tmp[offset + 3] = (byte)(v >> 24 & 0xFFL);
                        tmp[offset + 4] = (byte)(v >> 32 & 0xFFL);
                        tmp[offset + 5] = (byte)(v >> 40 & 0xFFL);
                        tmp[offset + 6] = (byte)(v >> 48 & 0xFFL);
                        tmp[offset + 7] = (byte)(v >> 56 & 0xFFL);
                    }
                    data.write((byte[])tmp);
                    continue block14;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    continue block14;
                }
                case 6: {
                    colInfoData[colIndex * 5] = 6;
                    int typeLen = DataLength.TSDB_DATA_TYPE_FLOAT.getLength();
                    byte[] typeBytes = SerializeBlock.intToBytes(typeLen);
                    System.arraycopy(typeBytes, 0, colInfoData, colIndex * 5 + 1, 4);
                    byte[] array = SerializeBlock.intToBytes(typeLen * rows);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    Object tmp = new byte[bitMapLen + rows * 4];
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        if (rowData.get(rowIndex) == null) {
                            int charOffset = SerializeBlock.charOffset(rowIndex);
                            tmp[charOffset] = SerializeBlock.bmSetNull((byte)tmp[charOffset], rowIndex);
                            continue;
                        }
                        float v = ((Float)rowData.get(rowIndex)).floatValue();
                        int offset = rowIndex * 4 + bitMapLen;
                        int f = Float.floatToIntBits(v);
                        tmp[offset] = (byte)(f & 0xFF);
                        tmp[offset + 1] = (byte)(f >> 8 & 0xFF);
                        tmp[offset + 2] = (byte)(f >> 16 & 0xFF);
                        tmp[offset + 3] = (byte)(f >> 24 & 0xFF);
                    }
                    data.write((byte[])tmp);
                    continue block14;
                }
                case 7: {
                    int offset;
                    colInfoData[colIndex * 5] = 7;
                    int typeLen = DataLength.TSDB_DATA_TYPE_DOUBLE.getLength();
                    byte[] typeBytes = SerializeBlock.intToBytes(typeLen);
                    System.arraycopy(typeBytes, 0, colInfoData, colIndex * 5 + 1, 4);
                    byte[] array = SerializeBlock.intToBytes(typeLen * rows);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    Object tmp = new byte[bitMapLen + rows * 8];
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        if (rowData.get(rowIndex) == null) {
                            int charOffset = SerializeBlock.charOffset(rowIndex);
                            tmp[charOffset] = SerializeBlock.bmSetNull((byte)tmp[charOffset], rowIndex);
                            continue;
                        }
                        double v = (Double)rowData.get(rowIndex);
                        offset = rowIndex * 8 + bitMapLen;
                        long l = Double.doubleToLongBits(v);
                        tmp[offset] = (byte)(l & 0xFFL);
                        tmp[offset + 1] = (byte)(l >> 8 & 0xFFL);
                        tmp[offset + 2] = (byte)(l >> 16 & 0xFFL);
                        tmp[offset + 3] = (byte)(l >> 24 & 0xFFL);
                        tmp[offset + 4] = (byte)(l >> 32 & 0xFFL);
                        tmp[offset + 5] = (byte)(l >> 40 & 0xFFL);
                        tmp[offset + 6] = (byte)(l >> 48 & 0xFFL);
                        tmp[offset + 7] = (byte)(l >> 56 & 0xFFL);
                    }
                    data.write((byte[])tmp);
                    continue block14;
                }
                case 8: {
                    int b;
                    int n;
                    colInfoData[colIndex * 5] = 8;
                    int length = 0;
                    List<Object> rowData = column.getDataList();
                    byte[] index = new byte[rows * 4];
                    Object tmp = new ArrayList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        int offset = rowIndex * 4;
                        if (rowData.get(rowIndex) == null) {
                            for (int i = 0; i < 4; ++i) {
                                index[offset + i] = -1;
                            }
                            continue;
                        }
                        byte[] v = (byte[])rowData.get(rowIndex);
                        for (int i = 0; i < 4; ++i) {
                            index[offset + i] = (byte)(length >> 8 * i & 0xFF);
                        }
                        short len = (short)v.length;
                        tmp.add((byte)(len & 0xFF));
                        tmp.add((byte)(len >> 8 & 0xFF));
                        byte[] offset2 = v;
                        int l = offset2.length;
                        for (n = 0; n < l; ++n) {
                            b = offset2[n];
                            tmp.add((byte)b);
                        }
                        length += v.length + 2;
                    }
                    byte[] array = SerializeBlock.intToBytes(length);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    data.write(index);
                    byte[] bytes = new byte[tmp.size()];
                    for (int i = 0; i < tmp.size(); ++i) {
                        bytes[i] = (Byte)tmp.get(i);
                    }
                    data.write(bytes);
                    continue block14;
                }
                case 10: {
                    int b;
                    int n;
                    colInfoData[colIndex * 5] = 10;
                    int length = 0;
                    byte[] index = new byte[rows * 4];
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        int[] t;
                        int offset = rowIndex * 4;
                        if (rowData.get(rowIndex) == null) {
                            for (int i = 0; i < 4; ++i) {
                                index[offset + i] = -1;
                            }
                            continue;
                        }
                        String v = (String)rowData.get(rowIndex);
                        for (int i = 0; i < 4; ++i) {
                            index[offset + i] = (byte)(length >> 8 * i & 0xFF);
                        }
                        short len = (short)(v.length() * 4);
                        tmp.write((byte)(len & 0xFF));
                        tmp.write((byte)(len >> 8 & 0xFF));
                        int[] l = t = v.codePoints().toArray();
                        n = l.length;
                        for (b = 0; b < n; ++b) {
                            int i = l[b];
                            tmp.write(SerializeBlock.intToBytes(i));
                        }
                        length += t.length * 4 + 2;
                    }
                    byte[] array = SerializeBlock.intToBytes(length);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    data.write(index);
                    data.write(tmp.toByteArray());
                    continue block14;
                }
                case 9: {
                    colInfoData[colIndex * 5] = 9;
                    int typeLen = DataLength.TSDB_DATA_TYPE_TIMESTAMP.getLength();
                    byte[] typeBytes = SerializeBlock.intToBytes(typeLen);
                    System.arraycopy(typeBytes, 0, colInfoData, colIndex * 5 + 1, 4);
                    byte[] array = SerializeBlock.intToBytes(typeLen * rows);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    Object tmp = new byte[bitMapLen + rows * 8];
                    List<Object> rowData = column.getDataList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        if (rowData.get(rowIndex) == null) {
                            int charOffset = SerializeBlock.charOffset(rowIndex);
                            tmp[charOffset] = SerializeBlock.bmSetNull((byte)tmp[charOffset], rowIndex);
                            continue;
                        }
                        Timestamp t = (Timestamp)rowData.get(rowIndex);
                        long v = precision == 0 ? t.getTime() : (precision == 1 ? t.getTime() * 1000L + (long)(t.getNanos() / 1000 % 1000) : t.getTime() * 1000000L + (long)t.getNanos() % 1000000L);
                        int offset = rowIndex * 8 + bitMapLen;
                        tmp[offset] = (byte)(v & 0xFFL);
                        tmp[offset + 1] = (byte)(v >> 8 & 0xFFL);
                        tmp[offset + 2] = (byte)(v >> 16 & 0xFFL);
                        tmp[offset + 3] = (byte)(v >> 24 & 0xFFL);
                        tmp[offset + 4] = (byte)(v >> 32 & 0xFFL);
                        tmp[offset + 5] = (byte)(v >> 40 & 0xFFL);
                        tmp[offset + 6] = (byte)(v >> 48 & 0xFFL);
                        tmp[offset + 7] = (byte)(v >> 56 & 0xFFL);
                    }
                    data.write((byte[])tmp);
                    continue block14;
                }
                case 15: {
                    int b;
                    int n;
                    colInfoData[colIndex * 5] = 15;
                    int length = 0;
                    List<Object> rowData = column.getDataList();
                    byte[] index = new byte[rows * 4];
                    Object tmp = new ArrayList();
                    for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                        int offset = rowIndex * 4;
                        if (rowData.get(rowIndex) == null) {
                            for (int i = 0; i < 4; ++i) {
                                index[offset + i] = -1;
                            }
                            continue;
                        }
                        byte[] v = (byte[])rowData.get(rowIndex);
                        for (int i = 0; i < 4; ++i) {
                            index[offset + i] = (byte)(length >> 8 * i & 0xFF);
                        }
                        short len = (short)v.length;
                        tmp.add((byte)(len & 0xFF));
                        tmp.add((byte)(len >> 8 & 0xFF));
                        byte[] byArray = v;
                        int n2 = byArray.length;
                        for (n = 0; n < n2; ++n) {
                            b = byArray[n];
                            tmp.add((byte)b);
                        }
                        length += v.length + 2;
                    }
                    byte[] array = SerializeBlock.intToBytes(length);
                    System.arraycopy(array, 0, lengthData, colIndex * 4, 4);
                    data.write(index);
                    byte[] bytes = new byte[tmp.size()];
                    for (int i = 0; i < tmp.size(); ++i) {
                        bytes[i] = (Byte)tmp.get(i);
                    }
                    data.write(bytes);
                    continue block14;
                }
                default: {
                    throw new SQLException("unsupported data type : " + column.getType());
                }
            }
        }
        buffer.write(colInfoData);
        buffer.write(lengthData);
        buffer.write(data.toByteArray());
        byte[] block = buffer.toByteArray();
        for (int i = 0; i < 4; ++i) {
            block[4 + i] = (byte)(block.length >> 8 * i);
        }
        return block;
    }

    public static byte[] intToBytes(int v) {
        byte[] result = new byte[]{(byte)(v & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 24 & 0xFF)};
        return result;
    }

    public static byte[] longToBytes(long v) {
        byte[] result = new byte[]{(byte)(v & 0xFFL), (byte)(v >> 8 & 0xFFL), (byte)(v >> 16 & 0xFFL), (byte)(v >> 24 & 0xFFL), (byte)(v >> 32 & 0xFFL), (byte)(v >> 40 & 0xFFL), (byte)(v >> 48 & 0xFFL), (byte)(v >> 56 & 0xFFL)};
        return result;
    }
}

