/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.tmq;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.tmq.ConsumerRecords;
import com.taosdata.jdbc.tmq.JNIConsumer;
import com.taosdata.jdbc.tmq.OffsetCommitCallback;
import java.sql.SQLException;

public class OffsetWaitCallback<V> {
    private final ConsumerRecords<V> cRecord;
    private final JNIConsumer<?> consumer;
    private final OffsetCommitCallback<V> callback;

    public OffsetWaitCallback(ConsumerRecords<V> cRecord, JNIConsumer<?> consumer, OffsetCommitCallback<V> callback) {
        this.cRecord = cRecord;
        this.consumer = consumer;
        this.callback = callback;
    }

    public void commitCallbackHandler(int code) throws SQLException {
        if (0 != code) {
            SQLException exception = TSDBError.createSQLException(code, this.consumer.getErrMsg(code));
            this.callback.onComplete(this.cRecord, exception);
        } else {
            this.callback.onComplete(this.cRecord, null);
        }
        this.consumer.closeOffset(this.cRecord.getOffset());
        this.consumer.releaseResultSet(this.cRecord.getOffset());
    }
}

