/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.tmq;

import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBResultSetBlockData;
import com.taosdata.jdbc.TSDBResultSetMetaData;
import com.taosdata.jdbc.tmq.TMQConnector;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class TMQResultSet
extends AbstractResultSet {
    private final TMQConnector jniConnector;
    private final long resultSetPointer;
    private final List<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
    private final TSDBResultSetBlockData blockData;
    private String dbName;
    private String tableName;
    private boolean isClosed;

    public TMQResultSet(TMQConnector connector, long resultSetPointer, int timestampPrecision) {
        this.jniConnector = connector;
        this.resultSetPointer = resultSetPointer;
        this.timestampPrecision = timestampPrecision;
        this.blockData = new TSDBResultSetBlockData(this.columnMetaDataList, timestampPrecision);
    }

    public TMQResultSet(TMQConnector connector, long resultSetPointer, int timestampPrecision, String dbName, String tableName) {
        this.jniConnector = connector;
        this.resultSetPointer = resultSetPointer;
        this.timestampPrecision = timestampPrecision;
        this.dbName = dbName;
        this.tableName = tableName;
        this.blockData = new TSDBResultSetBlockData(this.columnMetaDataList, timestampPrecision);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.blockData.forward()) {
            return true;
        }
        this.columnMetaDataList.clear();
        int code = this.jniConnector.fetchBlock(this.resultSetPointer, this.blockData, this.columnMetaDataList);
        if (code == -2) {
            throw TSDBError.createSQLException(9044);
        }
        if (code == -3) {
            throw TSDBError.createSQLException(9045);
        }
        if (code == -4) {
            throw TSDBError.createSQLException(9046);
        }
        if (code == -6) {
            return false;
        }
        this.blockData.reset();
        return true;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.jniConnector != null) {
            int code = this.jniConnector.freeResultSet(this.resultSetPointer);
            if (code == -2) {
                throw TSDBError.createSQLException(9044);
            }
            if (code == -3) {
                throw TSDBError.createSQLException(9045);
            }
        }
        this.isClosed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.blockData.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getString(columnIndex - 1);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getBoolean(columnIndex - 1);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return (byte)this.blockData.getInt(columnIndex - 1);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return (short)this.blockData.getInt(columnIndex - 1);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getInt(columnIndex - 1);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getLong(columnIndex - 1);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return (float)this.blockData.getDouble(columnIndex - 1);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getDouble(columnIndex - 1);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getBytes(columnIndex - 1);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.getTimestamp(columnIndex - 1);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return new TSDBResultSetMetaData(this.columnMetaDataList, this.dbName, this.tableName);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return this.blockData.get(columnIndex - 1);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (ColumnMetaData colMetaData : this.columnMetaDataList) {
            if (colMetaData.getColName() == null || !colMetaData.getColName().equalsIgnoreCase(columnLabel)) continue;
            return colMetaData.getColIndex();
        }
        throw TSDBError.createSQLException(8963);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.columnMetaDataList.size());
        return BigDecimal.valueOf(this.blockData.getDouble(columnIndex - 1));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }
}

