/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.DatabaseMetaDataResultSet;
import com.taosdata.jdbc.EmptyResultSet;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBResultSetRowData;
import com.taosdata.jdbc.WrapperImpl;
import com.taosdata.jdbc.enums.DataType;
import com.taosdata.jdbc.utils.StringUtils;
import com.taosdata.jdbc.ws.WSConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractDatabaseMetaData
extends WrapperImpl
implements DatabaseMetaData {
    private static final String PRODUCT_NAME;
    private static final String PRODUCT_VERSION;
    private static final String DRIVER_VERSION;
    private static final int DRIVER_MAJAR_VERSION;
    private static final int DRIVER_MINOR_VERSION;
    public static final String NUMERIC_FUNCTIONS = "ABS,ACOS,ASIN,ATAN,CEIL,COS,FLOOR,LOG,POW,ROUND,SIN,SQRT,TAN";
    public static final String STRING_FUNCTIONS = "CHAR_LENGTH,CONCAT,CONCAT_WS,LENGTH,LOWER,LTRIM,RTRIM,SUBSTR,UPPER";
    public static final String SYSTEM_FUNCTIONS = "DATABASE,CLIENT_VERSION,SERVER_VERSION,SERVER_STATUS,CURRENT_USER";
    public static final String TIME_DATE_FUNCTIONS = "NOW,TIMEDIFF,TIMETRUNCATE,TIMEZONE,TODAY";
    private static final Set<String> tableTypeSet;
    Pattern pattern = Pattern.compile("\\((\\d+)\\)");

    private static InputStream loadProperties() throws IOException {
        String currentJar = AbstractDatabaseMetaData.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        Enumeration<URL> urls = AbstractDatabaseMetaData.class.getClassLoader().getResources("taos-jdbc-version.properties");
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (!url.getFile().contains(currentJar)) continue;
            return url.openStream();
        }
        return null;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public abstract String getURL() throws SQLException;

    @Override
    public abstract String getUserName() throws SQLException;

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return !this.nullsAreSortedAtStart();
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return PRODUCT_NAME;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        Connection conn = this.getConnection();
        if (conn == null || conn.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        String version = null;
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("select server_version()  as version");){
            while (rs.next()) {
                version = rs.getString("version");
            }
        }
        if (StringUtils.isEmpty(version)) {
            return PRODUCT_VERSION;
        }
        return version;
    }

    @Override
    public abstract String getDriverName() throws SQLException;

    @Override
    public String getDriverVersion() throws SQLException {
        return DRIVER_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return DRIVER_MAJAR_VERSION;
    }

    @Override
    public int getDriverMinorVersion() {
        return DRIVER_MINOR_VERSION;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "`";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return null;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return NUMERIC_FUNCTIONS;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return STRING_FUNCTIONS;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return SYSTEM_FUNCTIONS;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return TIME_DATE_FUNCTIONS;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return null;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public abstract ResultSet getTables(String var1, String var2, String var3, String[] var4) throws SQLException;

    private List<ColumnMetaData> buildGetTablesColumnMetaDataList() {
        ArrayList<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
        columnMetaDataList.add(this.buildTableCatalogMeta(1));
        columnMetaDataList.add(this.buildTableSchemaMeta(2));
        columnMetaDataList.add(this.buildTableNameMeta(3));
        columnMetaDataList.add(this.buildTableTypeMeta(4));
        columnMetaDataList.add(this.buildRemarksMeta(5));
        columnMetaDataList.add(this.buildTypeCatMeta(6));
        columnMetaDataList.add(this.buildTypeSchemaMeta(7));
        columnMetaDataList.add(this.buildTypeNameMeta(8));
        columnMetaDataList.add(this.buildSelfReferencingColName(9));
        columnMetaDataList.add(this.buildRefGenerationMeta(10));
        return columnMetaDataList;
    }

    private ColumnMetaData buildTypeCatMeta(int colIndex) {
        ColumnMetaData col6 = new ColumnMetaData();
        col6.setColIndex(colIndex);
        col6.setColName("TYPE_CAT");
        col6.setColType(10);
        return col6;
    }

    private ColumnMetaData buildTypeSchemaMeta(int colIndex) {
        ColumnMetaData col7 = new ColumnMetaData();
        col7.setColIndex(colIndex);
        col7.setColName("TYPE_SCHEM");
        col7.setColType(10);
        return col7;
    }

    private ColumnMetaData buildTypeNameMeta(int colIndex) {
        ColumnMetaData col8 = new ColumnMetaData();
        col8.setColIndex(colIndex);
        col8.setColName("TYPE_NAME");
        col8.setColType(10);
        return col8;
    }

    private ColumnMetaData buildSelfReferencingColName(int colIndex) {
        ColumnMetaData col9 = new ColumnMetaData();
        col9.setColIndex(colIndex);
        col9.setColName("SELF_REFERENCING_COL_NAME");
        col9.setColType(10);
        return col9;
    }

    private ColumnMetaData buildRefGenerationMeta(int colIndex) {
        ColumnMetaData col10 = new ColumnMetaData();
        col10.setColIndex(colIndex);
        col10.setColName("REF_GENERATION");
        col10.setColType(10);
        return col10;
    }

    protected ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types, Connection connection) throws SQLException {
        WSConnection wsConnection;
        String dbHelperStr = "";
        String tableHelperStr = "";
        if (connection instanceof WSConnection && (wsConnection = (WSConnection)connection).getParam().getConnectMode() == 1) {
            dbHelperStr = "user";
            tableHelperStr = "normal ";
        }
        if (!StringUtils.isEmpty(catalog) && !this.isAvailableCatalog(connection, catalog)) {
            return new EmptyResultSet();
        }
        DatabaseMetaDataResultSet resultSet = new DatabaseMetaDataResultSet();
        resultSet.setColumnMetaDataList(this.buildGetTablesColumnMetaDataList());
        ArrayList<TSDBResultSetRowData> rowDataList = new ArrayList<TSDBResultSetRowData>();
        try (Statement stmt = connection.createStatement();){
            ArrayList<String> dbs = new ArrayList<String>();
            if (!StringUtils.isEmpty(catalog)) {
                dbs.add(catalog);
            } else {
                try (ResultSet dbRs = stmt.executeQuery("show " + dbHelperStr + " databases");){
                    while (dbRs.next()) {
                        dbs.add(dbRs.getString("name"));
                    }
                }
            }
            if (dbs.isEmpty()) {
                EmptyResultSet emptyResultSet = new EmptyResultSet();
                return emptyResultSet;
            }
            for (String db : dbs) {
                TSDBResultSetRowData rowData2;
                Throwable throwable;
                ResultSet rs;
                Set<String> tempTableTypeSet = types == null || types.length == 0 ? tableTypeSet : new HashSet<String>(Arrays.asList(types));
                StringBuilder sql = new StringBuilder().append("show ").append(tableHelperStr).append(db).append(".tables ");
                StringBuilder Ssql = new StringBuilder().append("show ").append(db).append(".stables ");
                StringBuilder vsql = new StringBuilder().append("show ").append(db).append(".views ");
                if (!StringUtils.isEmpty(tableNamePattern)) {
                    sql.append("like '").append(tableNamePattern).append("'");
                    Ssql.append("like '").append(tableNamePattern).append("'");
                    vsql.append("like '").append(tableNamePattern).append("'");
                }
                if (tempTableTypeSet.contains("TABLE")) {
                    rs = stmt.executeQuery(sql.toString());
                    throwable = null;
                    try {
                        while (rs.next()) {
                            rowData2 = new TSDBResultSetRowData(10);
                            rowData2.setStringValue(1, db);
                            rowData2.setStringValue(2, null);
                            rowData2.setStringValue(3, rs.getString("table_name"));
                            rowData2.setStringValue(4, "TABLE");
                            rowData2.setStringValue(5, "");
                            rowDataList.add(rowData2);
                        }
                    }
                    catch (Throwable rowData2) {
                        throwable = rowData2;
                        throw rowData2;
                    }
                    finally {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable rowData2) {
                                    throwable.addSuppressed(rowData2);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                    rs = stmt.executeQuery(Ssql.toString());
                    throwable = null;
                    try {
                        while (rs.next()) {
                            rowData2 = new TSDBResultSetRowData(10);
                            rowData2.setStringValue(1, db);
                            rowData2.setStringValue(2, null);
                            rowData2.setStringValue(3, rs.getString("stable_name"));
                            rowData2.setStringValue(4, "TABLE");
                            rowData2.setStringValue(5, "STABLE");
                            rowDataList.add(rowData2);
                        }
                    }
                    catch (Throwable rowData3) {
                        throwable = rowData3;
                        throw rowData3;
                    }
                    finally {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable rowData3) {
                                    throwable.addSuppressed(rowData3);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                if (!tempTableTypeSet.contains("VIEW")) continue;
                rs = stmt.executeQuery(vsql.toString());
                throwable = null;
                try {
                    while (rs.next()) {
                        rowData2 = new TSDBResultSetRowData(10);
                        rowData2.setStringValue(1, db);
                        rowData2.setStringValue(2, null);
                        rowData2.setStringValue(3, rs.getString("view_name"));
                        rowData2.setStringValue(4, "VIEW");
                        rowData2.setStringValue(5, "VIEW");
                        rowDataList.add(rowData2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs == null) continue;
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rs.close();
                }
            }
            resultSet.setRowDataList(rowDataList);
        }
        return resultSet;
    }

    private ColumnMetaData buildTableTypeMeta(int colIndex) {
        ColumnMetaData col4 = new ColumnMetaData();
        col4.setColIndex(colIndex);
        col4.setColName("TABLE_TYPE");
        col4.setColType(10);
        return col4;
    }

    @Override
    public ResultSet getSchemas() {
        return this.getEmptyResultSet();
    }

    @Override
    public abstract ResultSet getCatalogs() throws SQLException;

    private List<ColumnMetaData> buildTableTypesColumnMetadataList() {
        ArrayList<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
        columnMetaDataList.add(this.buildTableTypeMeta(1));
        return columnMetaDataList;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        DatabaseMetaDataResultSet resultSet = new DatabaseMetaDataResultSet();
        resultSet.setColumnMetaDataList(this.buildTableTypesColumnMetadataList());
        ArrayList<TSDBResultSetRowData> rowDataList = new ArrayList<TSDBResultSetRowData>();
        for (String tableType : tableTypeSet) {
            TSDBResultSetRowData rowData = new TSDBResultSetRowData(1);
            rowData.setStringValue(1, tableType);
            rowDataList.add(rowData);
        }
        resultSet.setRowDataList(rowDataList);
        return resultSet;
    }

    @Override
    public abstract ResultSet getColumns(String var1, String var2, String var3, String var4) throws SQLException;

    private Map<String, String> getCatalogMate(Connection connection, String catalog) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        try (Statement stmt = connection.createStatement();
             ResultSet databases = stmt.executeQuery("select name, `precision` as `precision` from information_schema.ins_databases");){
            while (databases.next()) {
                String dbname = databases.getString("name");
                String precision = databases.getString("precision");
                if (catalog == null) {
                    result.put(dbname, precision);
                    continue;
                }
                if (!dbname.equalsIgnoreCase(catalog)) continue;
                result.put(dbname, precision);
            }
        }
        return result;
    }

    private Map<String, Set<String>> getSTableMate(Connection connection, String sTable, String db) throws SQLException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        String sql = "select stable_name, db_name from information_schema.ins_stables where 1 = 1 ";
        if (sTable != null) {
            sql = sql + " and stable_name='" + sTable + "'";
        }
        if (db != null) {
            sql = sql + " and db_name= '" + db + "'";
        }
        try (Statement stmt = connection.createStatement();
             ResultSet databases = stmt.executeQuery(sql);){
            while (databases.next()) {
                Set<String> stables;
                String name = databases.getString("stable_name");
                String dbName = databases.getString("db_name");
                if (result.containsKey(dbName)) {
                    stables = (Set)result.get(dbName);
                } else {
                    stables = new HashSet();
                    result.put(dbName, stables);
                }
                stables.add(name);
            }
        }
        return result;
    }

    private Map<String, Set<String>> getTableMate(Connection connection, String table, String db) throws SQLException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        String sql = "select table_name, db_name, stable_name from information_schema.ins_tables where 1 = 1 ";
        if (table != null) {
            sql = sql + " and table_name='" + table + "'";
        }
        if (db != null) {
            sql = sql + " and db_name='" + db + "'";
        }
        try (Statement stmt = connection.createStatement();
             ResultSet tables = stmt.executeQuery(sql);){
            while (tables.next()) {
                Set<String> set;
                String name = tables.getString("table_name");
                String dbName = tables.getString("db_name");
                if (result.containsKey(dbName)) {
                    set = (Set)result.get(dbName);
                    set.add(name);
                    continue;
                }
                set = new HashSet();
                set.add(name);
                result.put(dbName, set);
            }
        }
        return result;
    }

    private Map<String, Set<String>> getViewMate(Connection connection, String viewName, String db) throws SQLException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        String sql = "select view_name, db_name from information_schema.ins_views where 1 = 1 ";
        if (viewName != null) {
            sql = sql + " and view_name='" + viewName + "'";
        }
        if (db != null) {
            sql = sql + " and db_name= '" + db + "'";
        }
        try (Statement stmt = connection.createStatement();
             ResultSet databases = stmt.executeQuery(sql);){
            while (databases.next()) {
                Set<String> views;
                String name = databases.getString("view_name");
                String dbName = databases.getString("db_name");
                if (result.containsKey(dbName)) {
                    views = (Set)result.get(dbName);
                } else {
                    views = new HashSet();
                    result.put(dbName, views);
                }
                views.add(name);
            }
        }
        return result;
    }

    private void show2RowData(ResultSet rs, List<TSDBResultSetRowData> rowDataList, String precision, String db, String tableName, String colName) throws SQLException {
        int rowIndex = 0;
        while (rs.next()) {
            TSDBResultSetRowData rowData = new TSDBResultSetRowData(24);
            rowData.setStringValue(1, db);
            rowData.setStringValue(2, null);
            rowData.setStringValue(3, tableName);
            String field = rs.getString("field");
            if (colName != null && !colName.equals("%") && !colName.equals(field)) continue;
            rowData.setStringValue(4, field);
            String typeName = rs.getString("type");
            rowData.setIntValue(5, DataType.getDataType(typeName).getJdbcTypeValue());
            rowData.setStringValue(6, typeName);
            int length = rs.getInt("length");
            int size = DataType.calculateColumnSize(typeName, precision, length);
            if (size != -1) {
                rowData.setIntValue(7, size);
            } else {
                rowData.setString(7, null);
            }
            rowData.setStringValue(8, null);
            Integer decimalDigits = DataType.calculateDecimalDigits(typeName);
            if (decimalDigits != null) {
                rowData.setIntValue(9, decimalDigits);
            } else {
                rowData.setStringValue(9, null);
            }
            rowData.setIntValue(10, 10);
            rowData.setIntValue(11, this.isNullable(rowIndex, typeName));
            String note = rs.getString("note");
            rowData.setStringValue(12, note.trim().isEmpty() ? null : note);
            rowDataList.add(rowData);
            ++rowIndex;
        }
    }

    private void colResultSet2RowData(ResultSet rs, List<TSDBResultSetRowData> rowDataList, Map<String, String> precision) throws SQLException {
        int rowIndex = 0;
        while (rs.next()) {
            TSDBResultSetRowData rowData = new TSDBResultSetRowData(24);
            String db = rs.getString("db_name");
            rowData.setStringValue(1, db);
            rowData.setStringValue(2, null);
            String tableName = rs.getString("table_name");
            rowData.setStringValue(3, tableName);
            rowData.setStringValue(4, rs.getString("col_name"));
            String typeName = rs.getString("col_type");
            int length = 0;
            if (typeName.startsWith("VARCHAR")) {
                rowData.setIntValue(5, DataType.getDataType("VARCHAR").getJdbcTypeValue());
                length = rs.getInt("col_length") - 2;
                typeName = "VARCHAR";
            } else if (typeName.startsWith("NCHAR")) {
                rowData.setIntValue(5, DataType.getDataType("NCHAR").getJdbcTypeValue());
                Matcher matcher = this.pattern.matcher(typeName);
                if (matcher.find()) {
                    length = Integer.parseInt(matcher.group(1));
                }
                typeName = "NCHAR";
            } else {
                rowData.setIntValue(5, DataType.getDataType(typeName).getJdbcTypeValue());
                length = rs.getInt("col_length");
            }
            rowData.setStringValue(6, typeName);
            String p = precision.get(db);
            int size = DataType.calculateColumnSize(typeName, p, length);
            if (size != -1) {
                rowData.setIntValue(7, size);
            } else {
                rowData.setString(7, null);
            }
            rowData.setStringValue(8, null);
            Integer decimalDigits = DataType.calculateDecimalDigits(typeName);
            if (decimalDigits != null) {
                rowData.setIntValue(9, decimalDigits);
            } else {
                rowData.setStringValue(9, null);
            }
            rowData.setIntValue(10, 10);
            rowData.setIntValue(11, this.isNullable(rowIndex, typeName));
            rowData.setStringValue(12, null);
            rowDataList.add(rowData);
            ++rowIndex;
        }
    }

    private void tagResultSet2RowData(ResultSet rs, List<TSDBResultSetRowData> rowDataList, Map<String, String> precision) throws SQLException {
        int rowIndex = 0;
        while (rs.next()) {
            Matcher matcher;
            TSDBResultSetRowData rowData = new TSDBResultSetRowData(24);
            String db = rs.getString("db_name");
            rowData.setStringValue(1, db);
            rowData.setStringValue(2, null);
            rowData.setStringValue(3, rs.getString("table_name"));
            rowData.setStringValue(4, rs.getString("tag_name"));
            String typeName = rs.getString("tag_type");
            int length = 0;
            if (typeName.startsWith("VARCHAR")) {
                rowData.setIntValue(5, DataType.getDataType("VARCHAR").getJdbcTypeValue());
                matcher = this.pattern.matcher(typeName);
                if (matcher.find()) {
                    length = Integer.parseInt(matcher.group(1));
                }
                typeName = "VARCHAR";
            } else if (typeName.startsWith("NCHAR")) {
                rowData.setIntValue(5, DataType.getDataType("NCHAR").getJdbcTypeValue());
                matcher = this.pattern.matcher(typeName);
                if (matcher.find()) {
                    length = Integer.parseInt(matcher.group(1));
                }
                typeName = "NCHAR";
            } else {
                rowData.setIntValue(5, DataType.getDataType(typeName).getJdbcTypeValue());
                length = 0;
            }
            rowData.setStringValue(6, typeName);
            String p = precision.get(db);
            int size = DataType.calculateColumnSize(typeName, p, length);
            if (size != -1) {
                rowData.setIntValue(7, size);
            } else {
                rowData.setString(7, null);
            }
            rowData.setStringValue(8, null);
            Integer decimalDigits = DataType.calculateDecimalDigits(typeName);
            if (decimalDigits != null) {
                rowData.setIntValue(9, decimalDigits);
            } else {
                rowData.setStringValue(9, null);
            }
            rowData.setIntValue(10, 10);
            rowData.setIntValue(11, this.isNullable(rowIndex, typeName));
            rowData.setStringValue(12, null);
            rowDataList.add(rowData);
            ++rowIndex;
        }
    }

    protected ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, Connection conn) throws SQLException {
        ArrayList<TSDBResultSetRowData> rowDataList;
        DatabaseMetaDataResultSet resultSet;
        block312: {
            resultSet = new DatabaseMetaDataResultSet();
            resultSet.setColumnMetaDataList(this.buildGetColumnsColumnMetaDataList());
            rowDataList = new ArrayList<TSDBResultSetRowData>();
            if (catalog == null || catalog.equals("%")) {
                Object rs72;
                Map<String, String> precisions = this.getCatalogMate(conn, null);
                if (tableNamePattern == null || tableNamePattern.equals("%")) {
                    if (columnNamePattern == null || columnNamePattern.equals("%")) {
                        Map<String, Set<String>> sTableMate = this.getSTableMate(conn, null, null);
                        for (String string : sTableMate.keySet()) {
                            for (String string2 : sTableMate.get(string)) {
                                Statement stmt2 = conn.createStatement();
                                Throwable throwable = null;
                                try {
                                    ResultSet rs5 = stmt2.executeQuery(this.generateDescribeSql(string, string2));
                                    Throwable throwable2 = null;
                                    try {
                                        this.show2RowData(rs5, rowDataList, precisions.get(string), string, string2, null);
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        if (rs5 == null) continue;
                                        if (throwable2 != null) {
                                            try {
                                                rs5.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable2.addSuppressed(throwable4);
                                            }
                                            continue;
                                        }
                                        rs5.close();
                                    }
                                }
                                catch (Throwable rs5) {
                                    throwable = rs5;
                                    throw rs5;
                                }
                                finally {
                                    if (stmt2 == null) continue;
                                    if (throwable != null) {
                                        try {
                                            stmt2.close();
                                        }
                                        catch (Throwable rs5) {
                                            throwable.addSuppressed(rs5);
                                        }
                                        continue;
                                    }
                                    stmt2.close();
                                }
                            }
                        }
                        Throwable throwable = null;
                        try (Statement stmt = conn.createStatement();){
                            Throwable throwable5 = null;
                            try (ResultSet resultSet2 = stmt.executeQuery("select table_name, db_name, table_type, col_name, col_type, col_length from information_schema.ins_columns");){
                                this.colResultSet2RowData(resultSet2, rowDataList, precisions);
                            }
                            catch (Throwable stmt2) {
                                Throwable throwable6 = stmt2;
                                throw stmt2;
                            }
                        }
                        catch (Throwable throwable7) {
                            Throwable throwable8 = throwable7;
                            throw throwable7;
                        }
                        stmt = conn.createStatement();
                        Throwable throwable9 = null;
                        try {
                            Throwable throwable10 = null;
                            try (ResultSet resultSet3 = stmt.executeQuery("select table_name, db_name, stable_name, tag_name, tag_type from information_schema.ins_tags");){
                                this.tagResultSet2RowData(resultSet3, rowDataList, precisions);
                                break block312;
                            }
                            catch (Throwable stmt2) {
                                Throwable throwable11 = stmt2;
                                throw stmt2;
                            }
                        }
                        catch (Throwable throwable12) {
                            Throwable throwable13 = throwable12;
                            throw throwable12;
                        }
                        finally {
                            if (stmt != null) {
                                if (throwable9 != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable14) {
                                        throwable9.addSuppressed(throwable14);
                                    }
                                } else {
                                    stmt.close();
                                }
                            }
                        }
                    }
                    try (Statement stmt = conn.createStatement();){
                        Throwable throwable = null;
                        try (ResultSet resultSet4 = stmt.executeQuery("select table_name, db_name, table_type, col_name, col_type, col_length from information_schema.ins_columns where col_name = '" + columnNamePattern + "'");){
                            this.colResultSet2RowData(resultSet4, rowDataList, precisions);
                        }
                        catch (Throwable throwable15) {
                            Throwable throwable16 = throwable15;
                            throw throwable15;
                        }
                    }
                    stmt = conn.createStatement();
                    stmt = null;
                    try {
                        Throwable throwable = null;
                        try (ResultSet resultSet5 = stmt.executeQuery("select table_name, db_name, stable_name, tag_name, tag_type from information_schema.ins_tags where tag_name = '" + columnNamePattern + "'");){
                            this.tagResultSet2RowData(resultSet5, rowDataList, precisions);
                            break block312;
                        }
                        catch (Throwable throwable17) {
                            Throwable throwable18 = throwable17;
                            throw throwable17;
                        }
                    }
                    catch (Throwable throwable) {
                        stmt = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stmt != null) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable) {
                                    stmt.addSuppressed(throwable);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                Map<String, Set<String>> sTableMate = this.getSTableMate(conn, tableNamePattern, null);
                for (String string : sTableMate.keySet()) {
                    for (String string3 : sTableMate.get(string)) {
                        Statement stmt = conn.createStatement();
                        Throwable throwable = null;
                        try {
                            rs72 = stmt.executeQuery(this.generateDescribeSql(string, string3));
                            Throwable throwable19 = null;
                            try {
                                this.show2RowData((ResultSet)rs72, rowDataList, precisions.get(string), string, string3, columnNamePattern);
                            }
                            catch (Throwable throwable20) {
                                throwable19 = throwable20;
                                throw throwable20;
                            }
                            finally {
                                if (rs72 == null) continue;
                                if (throwable19 != null) {
                                    try {
                                        rs72.close();
                                    }
                                    catch (Throwable throwable21) {
                                        throwable19.addSuppressed(throwable21);
                                    }
                                    continue;
                                }
                                rs72.close();
                            }
                        }
                        catch (Throwable rs72) {
                            throwable = rs72;
                            throw rs72;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable rs72) {
                                    throwable.addSuppressed(rs72);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                }
                Map<String, Set<String>> tableMate = this.getTableMate(conn, tableNamePattern, null);
                for (Map.Entry<String, Set<String>> entry : tableMate.entrySet()) {
                    for (String table : entry.getValue()) {
                        Statement stmt = conn.createStatement();
                        rs72 = null;
                        try {
                            ResultSet rs8 = stmt.executeQuery(this.generateDescribeSql(entry.getKey(), table));
                            Throwable throwable = null;
                            try {
                                this.show2RowData(rs8, rowDataList, precisions.get(entry.getKey()), entry.getKey(), table, columnNamePattern);
                            }
                            catch (Throwable throwable22) {
                                throwable = throwable22;
                                throw throwable22;
                            }
                            finally {
                                if (rs8 == null) continue;
                                if (throwable != null) {
                                    try {
                                        rs8.close();
                                    }
                                    catch (Throwable throwable23) {
                                        throwable.addSuppressed(throwable23);
                                    }
                                    continue;
                                }
                                rs8.close();
                            }
                        }
                        catch (Throwable throwable) {
                            rs72 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (rs72 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)rs72).addSuppressed(throwable);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                }
            } else {
                if (catalog.isEmpty()) {
                    return new EmptyResultSet();
                }
                Map<String, String> precisions = this.getCatalogMate(conn, catalog);
                if (precisions.get(catalog) == null) {
                    return new EmptyResultSet();
                }
                if (tableNamePattern == null || tableNamePattern.equals("%")) {
                    if (columnNamePattern == null || columnNamePattern.equals("%")) {
                        Map<String, Set<String>> stableMate = this.getSTableMate(conn, null, catalog);
                        for (String string : stableMate.keySet()) {
                            for (String string4 : stableMate.get(string)) {
                                Statement stmt3 = conn.createStatement();
                                Throwable throwable = null;
                                try {
                                    ResultSet rs11 = stmt3.executeQuery(this.generateDescribeSql(catalog, string4));
                                    Throwable throwable24 = null;
                                    try {
                                        this.show2RowData(rs11, rowDataList, precisions.get(catalog), catalog, string4, null);
                                    }
                                    catch (Throwable throwable25) {
                                        throwable24 = throwable25;
                                        throw throwable25;
                                    }
                                    finally {
                                        if (rs11 == null) continue;
                                        if (throwable24 != null) {
                                            try {
                                                rs11.close();
                                            }
                                            catch (Throwable throwable26) {
                                                throwable24.addSuppressed(throwable26);
                                            }
                                            continue;
                                        }
                                        rs11.close();
                                    }
                                }
                                catch (Throwable rs11) {
                                    throwable = rs11;
                                    throw rs11;
                                }
                                finally {
                                    if (stmt3 == null) continue;
                                    if (throwable != null) {
                                        try {
                                            stmt3.close();
                                        }
                                        catch (Throwable rs11) {
                                            throwable.addSuppressed(rs11);
                                        }
                                        continue;
                                    }
                                    stmt3.close();
                                }
                            }
                        }
                        Throwable throwable = null;
                        try (Statement stmt = conn.createStatement();){
                            Throwable throwable27 = null;
                            try (ResultSet resultSet6 = stmt.executeQuery("select table_name, db_name, table_type, col_name, col_type, col_length from information_schema.ins_columns where db_name = '" + catalog + "'");){
                                this.colResultSet2RowData(resultSet6, rowDataList, precisions);
                            }
                            catch (Throwable stmt3) {
                                Throwable throwable28 = stmt3;
                                throw stmt3;
                            }
                        }
                        catch (Throwable throwable29) {
                            Throwable throwable30 = throwable29;
                            throw throwable29;
                        }
                        stmt = conn.createStatement();
                        Throwable throwable31 = null;
                        try {
                            Throwable throwable32 = null;
                            try (ResultSet resultSet7 = stmt.executeQuery("select table_name, db_name, stable_name, tag_name, tag_type from information_schema.ins_tags where db_name = '" + catalog + "'");){
                                this.tagResultSet2RowData(resultSet7, rowDataList, precisions);
                                break block312;
                            }
                            catch (Throwable stmt3) {
                                Throwable throwable33 = stmt3;
                                throw stmt3;
                            }
                        }
                        catch (Throwable throwable34) {
                            Throwable throwable35 = throwable34;
                            throw throwable34;
                        }
                        finally {
                            if (stmt != null) {
                                if (throwable31 != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable36) {
                                        throwable31.addSuppressed(throwable36);
                                    }
                                } else {
                                    stmt.close();
                                }
                            }
                        }
                    }
                    try (Statement stmt = conn.createStatement();){
                        Throwable throwable = null;
                        try (ResultSet resultSet8 = stmt.executeQuery("select table_name, db_name, table_type, col_name, col_type, col_length from information_schema.ins_columns where col_name = '" + columnNamePattern + "' and db_name = '" + catalog + "'");){
                            this.colResultSet2RowData(resultSet8, rowDataList, precisions);
                        }
                        catch (Throwable throwable37) {
                            Throwable throwable38 = throwable37;
                            throw throwable37;
                        }
                    }
                    stmt = conn.createStatement();
                    stmt = null;
                    try {
                        Throwable throwable = null;
                        try (ResultSet resultSet9 = stmt.executeQuery("select table_name, db_name, stable_name, tag_name, tag_type from information_schema.ins_tags where tag_name = '" + columnNamePattern + "' and db_name = '" + catalog + "'");){
                            this.tagResultSet2RowData(resultSet9, rowDataList, precisions);
                            break block312;
                        }
                        catch (Throwable throwable39) {
                            Throwable throwable40 = throwable39;
                            throw throwable39;
                        }
                    }
                    catch (Throwable throwable) {
                        stmt = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stmt != null) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable) {
                                    stmt.addSuppressed(throwable);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                Map<String, Set<String>> sTableMate = this.getSTableMate(conn, tableNamePattern, catalog);
                Map<String, Set<String>> tableMate = this.getTableMate(conn, tableNamePattern, catalog);
                Map<String, Set<String>> map = this.getViewMate(conn, tableNamePattern, catalog);
                ArrayList<Map> arrayList = new ArrayList<Map>(Arrays.asList(sTableMate, tableMate, map));
                for (Map tmpMap : arrayList) {
                    for (Map.Entry dbs : tmpMap.entrySet()) {
                        for (String table : (Set)dbs.getValue()) {
                            Statement stmt = conn.createStatement();
                            Throwable throwable = null;
                            try {
                                ResultSet rs = stmt.executeQuery(this.generateDescribeSql(catalog, table));
                                Throwable throwable41 = null;
                                try {
                                    this.show2RowData(rs, rowDataList, precisions.get(catalog), catalog, table, columnNamePattern);
                                }
                                catch (Throwable throwable42) {
                                    throwable41 = throwable42;
                                    throw throwable42;
                                }
                                finally {
                                    if (rs == null) continue;
                                    if (throwable41 != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable43) {
                                            throwable41.addSuppressed(throwable43);
                                        }
                                        continue;
                                    }
                                    rs.close();
                                }
                            }
                            catch (Throwable throwable44) {
                                throwable = throwable44;
                                throw throwable44;
                            }
                            finally {
                                if (stmt == null) continue;
                                if (throwable != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable45) {
                                        throwable.addSuppressed(throwable45);
                                    }
                                    continue;
                                }
                                stmt.close();
                            }
                        }
                    }
                }
            }
        }
        resultSet.setRowDataList(rowDataList);
        return resultSet;
    }

    private int isNullable(int index, String typeName) {
        if (index == 0 && "TIMESTAMP".equals(typeName)) {
            return 0;
        }
        return 1;
    }

    private ColumnMetaData buildTableCatalogMeta(int colIndex) {
        ColumnMetaData col1 = new ColumnMetaData();
        col1.setColIndex(colIndex);
        col1.setColName("TABLE_CAT");
        col1.setColType(10);
        return col1;
    }

    private ColumnMetaData buildTableSchemaMeta(int colIndex) {
        ColumnMetaData col2 = new ColumnMetaData();
        col2.setColIndex(colIndex);
        col2.setColName("TABLE_SCHEM");
        col2.setColType(10);
        return col2;
    }

    private ColumnMetaData buildTableNameMeta(int colIndex) {
        ColumnMetaData col3 = new ColumnMetaData();
        col3.setColIndex(colIndex);
        col3.setColName("TABLE_NAME");
        col3.setColSize(193);
        col3.setColType(10);
        return col3;
    }

    private ColumnMetaData buildColumnNameMeta(int colIndex) {
        ColumnMetaData col4 = new ColumnMetaData();
        col4.setColIndex(colIndex);
        col4.setColName("COLUMN_NAME");
        col4.setColSize(65);
        col4.setColType(10);
        return col4;
    }

    private ColumnMetaData buildDataTypeMeta(int colIndex) {
        ColumnMetaData col5 = new ColumnMetaData();
        col5.setColIndex(colIndex);
        col5.setColName("DATA_TYPE");
        col5.setColType(4);
        return col5;
    }

    private ColumnMetaData buildColumnSizeMeta() {
        ColumnMetaData col7 = new ColumnMetaData();
        col7.setColIndex(7);
        col7.setColName("COLUMN_SIZE");
        col7.setColType(4);
        return col7;
    }

    private ColumnMetaData buildBufferLengthMeta() {
        ColumnMetaData col8 = new ColumnMetaData();
        col8.setColIndex(8);
        col8.setColName("BUFFER_LENGTH");
        return col8;
    }

    private ColumnMetaData buildDecimalDigitsMeta() {
        ColumnMetaData col9 = new ColumnMetaData();
        col9.setColIndex(9);
        col9.setColName("DECIMAL_DIGITS");
        col9.setColType(4);
        return col9;
    }

    private ColumnMetaData buildNumPrecRadixMeta() {
        ColumnMetaData col10 = new ColumnMetaData();
        col10.setColIndex(10);
        col10.setColName("NUM_PREC_RADIX");
        col10.setColType(4);
        return col10;
    }

    private ColumnMetaData buildNullableMeta() {
        ColumnMetaData col11 = new ColumnMetaData();
        col11.setColIndex(11);
        col11.setColName("NULLABLE");
        col11.setColType(4);
        return col11;
    }

    private ColumnMetaData buildRemarksMeta(int colIndex) {
        ColumnMetaData col12 = new ColumnMetaData();
        col12.setColIndex(colIndex);
        col12.setColName("REMARKS");
        col12.setColType(10);
        return col12;
    }

    private ColumnMetaData buildColumnDefMeta() {
        ColumnMetaData col13 = new ColumnMetaData();
        col13.setColIndex(13);
        col13.setColName("COLUMN_DEF");
        col13.setColType(10);
        return col13;
    }

    private ColumnMetaData buildSqlDataTypeMeta() {
        ColumnMetaData col14 = new ColumnMetaData();
        col14.setColIndex(14);
        col14.setColName("SQL_DATA_TYPE");
        col14.setColType(4);
        return col14;
    }

    private ColumnMetaData buildSqlDatetimeSubMeta() {
        ColumnMetaData col15 = new ColumnMetaData();
        col15.setColIndex(15);
        col15.setColName("SQL_DATETIME_SUB");
        col15.setColType(4);
        return col15;
    }

    private ColumnMetaData buildCharOctetLengthMeta() {
        ColumnMetaData col16 = new ColumnMetaData();
        col16.setColIndex(16);
        col16.setColName("CHAR_OCTET_LENGTH");
        col16.setColType(4);
        return col16;
    }

    private ColumnMetaData buildOrdinalPositionMeta() {
        ColumnMetaData col17 = new ColumnMetaData();
        col17.setColIndex(17);
        col17.setColName("ORDINAL_POSITION");
        col17.setColType(4);
        return col17;
    }

    private ColumnMetaData buildIsNullableMeta() {
        ColumnMetaData col18 = new ColumnMetaData();
        col18.setColIndex(18);
        col18.setColName("IS_NULLABLE");
        col18.setColType(10);
        return col18;
    }

    private ColumnMetaData buildScopeCatalogMeta() {
        ColumnMetaData col19 = new ColumnMetaData();
        col19.setColIndex(19);
        col19.setColName("SCOPE_CATALOG");
        col19.setColType(10);
        return col19;
    }

    private ColumnMetaData buildScopeSchemaMeta() {
        ColumnMetaData col20 = new ColumnMetaData();
        col20.setColIndex(20);
        col20.setColName("SCOPE_SCHEMA");
        col20.setColType(10);
        return col20;
    }

    private ColumnMetaData buildScopeTableMeta() {
        ColumnMetaData col21 = new ColumnMetaData();
        col21.setColIndex(21);
        col21.setColName("SCOPE_TABLE");
        col21.setColType(10);
        return col21;
    }

    private ColumnMetaData buildSourceDataTypeMeta() {
        ColumnMetaData col22 = new ColumnMetaData();
        col22.setColIndex(22);
        col22.setColName("SOURCE_DATA_TYPE");
        col22.setColType(3);
        return col22;
    }

    private ColumnMetaData buildIsAutoIncrementMeta() {
        ColumnMetaData col23 = new ColumnMetaData();
        col23.setColIndex(23);
        col23.setColName("IS_AUTOINCREMENT");
        col23.setColType(10);
        return col23;
    }

    private ColumnMetaData buildIsGeneratedColumnMeta() {
        ColumnMetaData col24 = new ColumnMetaData();
        col24.setColIndex(24);
        col24.setColName("IS_GENERATEDCOLUMN");
        col24.setColType(10);
        return col24;
    }

    private List<ColumnMetaData> buildGetColumnsColumnMetaDataList() {
        ArrayList<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
        columnMetaDataList.add(this.buildTableCatalogMeta(1));
        columnMetaDataList.add(this.buildTableSchemaMeta(2));
        columnMetaDataList.add(this.buildTableNameMeta(3));
        columnMetaDataList.add(this.buildColumnNameMeta(4));
        columnMetaDataList.add(this.buildDataTypeMeta(5));
        columnMetaDataList.add(this.buildTypeNameMeta(6));
        columnMetaDataList.add(this.buildColumnSizeMeta());
        columnMetaDataList.add(this.buildBufferLengthMeta());
        columnMetaDataList.add(this.buildDecimalDigitsMeta());
        columnMetaDataList.add(this.buildNumPrecRadixMeta());
        columnMetaDataList.add(this.buildNullableMeta());
        columnMetaDataList.add(this.buildRemarksMeta(12));
        columnMetaDataList.add(this.buildColumnDefMeta());
        columnMetaDataList.add(this.buildSqlDataTypeMeta());
        columnMetaDataList.add(this.buildSqlDatetimeSubMeta());
        columnMetaDataList.add(this.buildCharOctetLengthMeta());
        columnMetaDataList.add(this.buildOrdinalPositionMeta());
        columnMetaDataList.add(this.buildIsNullableMeta());
        columnMetaDataList.add(this.buildScopeCatalogMeta());
        columnMetaDataList.add(this.buildScopeSchemaMeta());
        columnMetaDataList.add(this.buildScopeTableMeta());
        columnMetaDataList.add(this.buildSourceDataTypeMeta());
        columnMetaDataList.add(this.buildIsAutoIncrementMeta());
        columnMetaDataList.add(this.buildIsGeneratedColumnMeta());
        return columnMetaDataList;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public abstract ResultSet getPrimaryKeys(String var1, String var2, String var3) throws SQLException;

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public abstract Connection getConnection() throws SQLException;

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public abstract ResultSet getSuperTables(String var1, String var2, String var3) throws SQLException;

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.getEmptyResultSet();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    private ResultSet getEmptyResultSet() {
        return new EmptyResultSet();
    }

    protected ResultSet getCatalogs(Connection conn) throws SQLException {
        WSConnection wsConnection;
        DatabaseMetaDataResultSet resultSet = new DatabaseMetaDataResultSet();
        ArrayList<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
        columnMetaDataList.add(this.buildTableCatalogMeta(1));
        resultSet.setColumnMetaDataList(columnMetaDataList);
        String dbHelperStr = "";
        if (conn instanceof WSConnection && (wsConnection = (WSConnection)conn).getParam().getConnectMode() == 1) {
            dbHelperStr = "user";
        }
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("show " + dbHelperStr + " databases");){
            ArrayList<TSDBResultSetRowData> rowDataList = new ArrayList<TSDBResultSetRowData>();
            while (rs.next()) {
                TSDBResultSetRowData rowData = new TSDBResultSetRowData(1);
                rowData.setStringValue(1, rs.getString("name"));
                rowDataList.add(rowData);
            }
            resultSet.setRowDataList(rowDataList);
        }
        return resultSet;
    }

    protected ResultSet getPrimaryKeys(String catalog, String schema, String table, Connection conn) throws SQLException {
        if (catalog == null || catalog.isEmpty()) {
            return null;
        }
        if (!this.isAvailableCatalog(conn, catalog)) {
            return new EmptyResultSet();
        }
        DatabaseMetaDataResultSet resultSet = new DatabaseMetaDataResultSet();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(this.generateDescribeSql(catalog, table));){
            resultSet.setColumnMetaDataList(this.buildGetPrimaryKeysMetadataList());
            ArrayList<TSDBResultSetRowData> rowDataList = new ArrayList<TSDBResultSetRowData>();
            rs.next();
            TSDBResultSetRowData rowData = new TSDBResultSetRowData(6);
            rowData.setStringValue(1, catalog);
            rowData.setStringValue(2, null);
            rowData.setStringValue(3, table);
            String primaryKey = rs.getString("field");
            rowData.setStringValue(4, primaryKey);
            rowData.setShortValue(5, (short)1);
            rowData.setStringValue(6, primaryKey);
            rowDataList.add(rowData);
            resultSet.setRowDataList(rowDataList);
        }
        return resultSet;
    }

    private List<ColumnMetaData> buildGetPrimaryKeysMetadataList() {
        ArrayList<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
        columnMetaDataList.add(this.buildTableCatalogMeta(1));
        columnMetaDataList.add(this.buildTableSchemaMeta(2));
        columnMetaDataList.add(this.buildTableNameMeta(3));
        columnMetaDataList.add(this.buildColumnNameMeta(4));
        columnMetaDataList.add(this.buildKeySeqMeta(5));
        columnMetaDataList.add(this.buildPrimaryKeyNameMeta(6));
        return columnMetaDataList;
    }

    private ColumnMetaData buildKeySeqMeta(int colIndex) {
        ColumnMetaData col5 = new ColumnMetaData();
        col5.setColIndex(colIndex);
        col5.setColName("KEY_SEQ");
        col5.setColType(3);
        return col5;
    }

    private ColumnMetaData buildPrimaryKeyNameMeta(int colIndex) {
        ColumnMetaData col6 = new ColumnMetaData();
        col6.setColIndex(colIndex);
        col6.setColName("PK_NAME");
        col6.setColType(10);
        return col6;
    }

    private boolean isAvailableCatalog(Connection connection, String catalog) throws SQLException {
        try (Statement stmt = connection.createStatement();
             ResultSet databases = stmt.executeQuery("select name, `precision` as `precision` from information_schema.ins_databases");){
            while (true) {
                if (databases.next()) {
                    String dbname = databases.getString("name");
                    if (!dbname.equalsIgnoreCase(catalog)) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        return false;
    }

    protected ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern, Connection conn) throws SQLException {
        if (catalog == null || catalog.isEmpty()) {
            return null;
        }
        if (!this.isAvailableCatalog(conn, catalog)) {
            return new EmptyResultSet();
        }
        DatabaseMetaDataResultSet resultSet = new DatabaseMetaDataResultSet();
        try (Statement stmt = conn.createStatement();){
            resultSet.setColumnMetaDataList(this.buildGetSuperTablesColumnMetaDataList());
            try (ResultSet rs = stmt.executeQuery("select * from information_schema.ins_tables where db_name='" + catalog + "' and table_name like '" + tableNamePattern + "'");){
                ArrayList<TSDBResultSetRowData> rowDataList = new ArrayList<TSDBResultSetRowData>();
                while (rs.next()) {
                    TSDBResultSetRowData rowData = new TSDBResultSetRowData(4);
                    rowData.setStringValue(1, catalog);
                    rowData.setStringValue(2, null);
                    rowData.setStringValue(3, rs.getString("table_name"));
                    rowData.setStringValue(4, rs.getString("stable_name"));
                    rowDataList.add(rowData);
                }
                resultSet.setRowDataList(rowDataList);
            }
        }
        return resultSet;
    }

    private List<ColumnMetaData> buildGetSuperTablesColumnMetaDataList() {
        ArrayList<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
        columnMetaDataList.add(this.buildTableCatalogMeta(1));
        columnMetaDataList.add(this.buildTableSchemaMeta(2));
        columnMetaDataList.add(this.buildTableNameMeta(3));
        columnMetaDataList.add(this.buildSuperTableNameMeta(4));
        return columnMetaDataList;
    }

    private ColumnMetaData buildSuperTableNameMeta(int colIndex) {
        ColumnMetaData col4 = new ColumnMetaData();
        col4.setColIndex(colIndex);
        col4.setColName("SUPERTABLE_NAME");
        col4.setColType(10);
        return col4;
    }

    private String generateDescribeSql(String dbName, String tableName) throws SQLException {
        return "describe " + dbName + "." + this.getIdentifierQuoteString() + tableName + this.getIdentifierQuoteString();
    }

    static {
        tableTypeSet = Stream.of("TABLE", "STABLE", "VIEW").collect(Collectors.toSet());
        Properties props = System.getProperties();
        try {
            props.load(AbstractDatabaseMetaData.loadProperties());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PRODUCT_NAME = props.getProperty("PRODUCT_NAME");
        PRODUCT_VERSION = props.getProperty("PRODUCT_VERSION");
        DRIVER_VERSION = props.getProperty("DRIVER_VERSION");
        DRIVER_MAJAR_VERSION = Integer.parseInt(DRIVER_VERSION.split("\\.")[0]);
        DRIVER_MINOR_VERSION = Integer.parseInt(DRIVER_VERSION.split("\\.")[1]);
    }
}

