/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.entity;

import com.taosdata.jdbc.ws.entity.CommonResp;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.FetchBlockNewResp;
import com.taosdata.jdbc.ws.entity.FetchResp;
import com.taosdata.jdbc.ws.entity.QueryResp;
import com.taosdata.jdbc.ws.entity.Response;
import com.taosdata.jdbc.ws.stmt.entity.ExecResp;
import com.taosdata.jdbc.ws.stmt.entity.GetColFieldsResp;
import com.taosdata.jdbc.ws.stmt.entity.StmtResp;
import com.taosdata.jdbc.ws.tmq.entity.FetchRawBlockResp;
import java.util.HashMap;
import java.util.Map;

public enum Action {
    CONN("conn", ConnectResp.class),
    QUERY("query", QueryResp.class),
    BINARY_QUERY("binary_query", QueryResp.class),
    FETCH("fetch", FetchResp.class),
    FETCH_BLOCK("fetch_raw_block", FetchRawBlockResp.class),
    FETCH_BLOCK_NEW("fetch_block_new", FetchBlockNewResp.class),
    FREE_RESULT("free_result", Response.class),
    INIT("init", StmtResp.class),
    PREPARE("prepare", StmtResp.class),
    SET_TABLE_NAME("set_table_name", StmtResp.class),
    SET_TAGS("set_tags", StmtResp.class),
    BIND("bind", StmtResp.class),
    ADD_BATCH("add_batch", StmtResp.class),
    EXEC("exec", ExecResp.class),
    GET_COL_FIELDS("get_col_fields", GetColFieldsResp.class),
    CLOSE("close", StmtResp.class),
    INSERT("insert", CommonResp.class);

    private final String action;
    private final Class<? extends Response> clazz;
    private static final Map<String, Action> actions;

    private Action(String action, Class<? extends Response> clazz) {
        this.action = action;
        this.clazz = clazz;
    }

    public String getAction() {
        return this.action;
    }

    public Class<? extends Response> getResponseClazz() {
        return this.clazz;
    }

    public static Action of(String action) {
        if (null == action || action.equals("")) {
            return null;
        }
        return actions.get(action);
    }

    static {
        actions = new HashMap<String, Action>();
        for (Action value : Action.values()) {
            actions.put(value.action, value);
        }
    }
}

