/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.utils.DateTimeUtils;
import com.taosdata.jdbc.utils.DecimalUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class BlockData {
    private List<List<Object>> data;
    private int returnCode;
    private boolean isCompleted;
    private int numOfRows;
    private ByteBuffer buffer;
    private List<RestfulResultSet.Field> fields;
    private final Semaphore semaphore;
    private int precision;

    public BlockData(List<List<Object>> data, int returnCode, int numOfRows, ByteBuffer buffer, List<RestfulResultSet.Field> fields, int precision) {
        this.data = data;
        this.returnCode = returnCode;
        this.numOfRows = numOfRows;
        this.buffer = buffer;
        this.fields = fields;
        this.semaphore = new Semaphore(0);
        this.isCompleted = false;
        this.precision = precision;
    }

    public static BlockData getEmptyBlockData(List<RestfulResultSet.Field> fields, int precision) {
        return new BlockData(null, 0, 0, null, fields, precision);
    }

    public void handleData() {
        try {
            int columns = this.fields.size();
            ArrayList<List<Object>> list = new ArrayList<List<Object>>();
            if (this.buffer != null) {
                this.buffer.getInt();
                int pHeader = this.buffer.position() + 28 + columns * 5;
                this.buffer.position(this.buffer.position() + 8);
                this.numOfRows = this.buffer.getInt();
                this.buffer.position(pHeader);
                int bitMapOffset = this.BitmapLen(this.numOfRows);
                ArrayList<Integer> lengths = new ArrayList<Integer>(columns);
                for (int i = 0; i < columns; ++i) {
                    lengths.add(this.buffer.getInt());
                }
                pHeader = this.buffer.position();
                int length = 0;
                for (int i = 0; i < columns; ++i) {
                    ArrayList<Object> col = new ArrayList<Object>(this.numOfRows);
                    int type = this.fields.get(i).getTaosType();
                    int scale = this.fields.get(i).getScale();
                    switch (type) {
                        case 1: 
                        case 2: 
                        case 11: {
                            length = bitMapOffset;
                            byte[] tmp = new byte[bitMapOffset];
                            this.buffer.get(tmp);
                            for (int j = 0; j < this.numOfRows; ++j) {
                                byte b = this.buffer.get();
                                if (this.isNull(tmp, j)) {
                                    col.add(null);
                                    continue;
                                }
                                col.add(b);
                            }
                            break;
                        }
                        case 3: 
                        case 12: {
                            length = bitMapOffset;
                            byte[] tmp = new byte[bitMapOffset];
                            this.buffer.get(tmp);
                            for (int j = 0; j < this.numOfRows; ++j) {
                                short s = this.buffer.getShort();
                                if (this.isNull(tmp, j)) {
                                    col.add(null);
                                    continue;
                                }
                                col.add(s);
                            }
                            break;
                        }
                        case 4: 
                        case 13: {
                            length = bitMapOffset;
                            byte[] tmp = new byte[bitMapOffset];
                            this.buffer.get(tmp);
                            for (int j = 0; j < this.numOfRows; ++j) {
                                int in = this.buffer.getInt();
                                if (this.isNull(tmp, j)) {
                                    col.add(null);
                                    continue;
                                }
                                col.add(in);
                            }
                            break;
                        }
                        case 5: 
                        case 14: {
                            length = bitMapOffset;
                            byte[] tmp = new byte[bitMapOffset];
                            this.buffer.get(tmp);
                            for (int j = 0; j < this.numOfRows; ++j) {
                                long l = this.buffer.getLong();
                                if (this.isNull(tmp, j)) {
                                    col.add(null);
                                    continue;
                                }
                                col.add(l);
                            }
                            break;
                        }
                        case 9: {
                            length = bitMapOffset;
                            byte[] tmp = new byte[bitMapOffset];
                            this.buffer.get(tmp);
                            for (int j = 0; j < this.numOfRows; ++j) {
                                long l = this.buffer.getLong();
                                if (this.isNull(tmp, j)) {
                                    col.add(null);
                                    continue;
                                }
                                Instant instant = DateTimeUtils.parseTimestampColumnData(l, this.precision);
                                col.add(instant);
                            }
                            break;
                        }
                        case 6: {
                            length = bitMapOffset;
                            byte[] tmp = new byte[bitMapOffset];
                            this.buffer.get(tmp);
                            for (int j = 0; j < this.numOfRows; ++j) {
                                float f = this.buffer.getFloat();
                                if (this.isNull(tmp, j)) {
                                    col.add(null);
                                    continue;
                                }
                                col.add(Float.valueOf(f));
                            }
                            break;
                        }
                        case 7: {
                            length = bitMapOffset;
                            byte[] tmp = new byte[bitMapOffset];
                            this.buffer.get(tmp);
                            for (int j = 0; j < this.numOfRows; ++j) {
                                double d = this.buffer.getDouble();
                                if (this.isNull(tmp, j)) {
                                    col.add(null);
                                    continue;
                                }
                                col.add(d);
                            }
                            break;
                        }
                        case 8: 
                        case 15: 
                        case 16: 
                        case 20: {
                            Object[] tmp;
                            int m;
                            length = this.numOfRows * 4;
                            ArrayList<Integer> offset = new ArrayList<Integer>(this.numOfRows);
                            for (int m2 = 0; m2 < this.numOfRows; ++m2) {
                                offset.add(this.buffer.getInt());
                            }
                            int start = this.buffer.position();
                            for (m = 0; m < this.numOfRows; ++m) {
                                if (-1 == (Integer)offset.get(m)) {
                                    col.add(null);
                                    continue;
                                }
                                this.buffer.position(start + (Integer)offset.get(m));
                                int len = this.buffer.getShort() & 0xFFFF;
                                tmp = new byte[len];
                                this.buffer.get((byte[])tmp);
                                col.add(tmp);
                            }
                            break;
                        }
                        case 10: {
                            Object[] tmp;
                            int m;
                            length = this.numOfRows * 4;
                            ArrayList<Integer> offset = new ArrayList<Integer>(this.numOfRows);
                            for (int m3 = 0; m3 < this.numOfRows; ++m3) {
                                offset.add(this.buffer.getInt());
                            }
                            int start = this.buffer.position();
                            for (m = 0; m < this.numOfRows; ++m) {
                                if (-1 == (Integer)offset.get(m)) {
                                    col.add(null);
                                    continue;
                                }
                                this.buffer.position(start + (Integer)offset.get(m));
                                int len = (this.buffer.getShort() & 0xFFFF) / 4;
                                tmp = new int[len];
                                for (int n = 0; n < len; ++n) {
                                    tmp[n] = this.buffer.getInt();
                                }
                                col.add(tmp);
                            }
                            break;
                        }
                        case 17: 
                        case 21: {
                            int dataLen = type == 17 ? 16 : 8;
                            length = bitMapOffset;
                            byte[] tmp = new byte[bitMapOffset];
                            this.buffer.get(tmp);
                            for (int j = 0; j < this.numOfRows; ++j) {
                                byte[] tb = new byte[dataLen];
                                this.buffer.get(tb);
                                if (this.isNull(tmp, j)) {
                                    col.add(null);
                                    continue;
                                }
                                BigDecimal t = DecimalUtil.getBigDecimal(tb, scale);
                                col.add(t);
                            }
                            break;
                        }
                        default: {
                            col.add(null);
                        }
                    }
                    this.buffer.position(pHeader += length + (Integer)lengths.get(i));
                    list.add(col);
                }
            }
            this.data = list;
            this.semaphore.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int BitmapLen(int n) {
        return n + 7 >> 3;
    }

    private boolean isNull(byte[] c, int n) {
        int position = n >>> 3;
        int index = n & 7;
        return (c[position] & 1 << 7 - index) == 1 << 7 - index;
    }

    public void doneWithNoData() {
        this.semaphore.release();
    }

    public void waitTillOK() throws SQLException {
        try {
            if (!this.semaphore.tryAcquire(50L, TimeUnit.SECONDS)) {
                throw TSDBError.createSQLException(9040, "FETCH DATA TIME OUT");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public List<List<Object>> getData() {
        return this.data;
    }

    public void setData(List<List<Object>> data) {
        this.data = data;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public int getNumOfRows() {
        return this.numOfRows;
    }

    public void setNumOfRows(int numOfRows) {
        this.numOfRows = numOfRows;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public List<RestfulResultSet.Field> getFields() {
        return this.fields;
    }

    public void setFields(List<RestfulResultSet.Field> fields) {
        this.fields = fields;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean completed) {
        this.isCompleted = completed;
    }
}

