/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.common;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.common.ColumnInfo;
import com.taosdata.jdbc.common.DataLengthCfg;
import com.taosdata.jdbc.common.TableInfo;
import com.taosdata.jdbc.utils.DateTimeUtils;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SerializeBlock {
    private SerializeBlock() {
    }

    private static int bitMapLen(int n) {
        return n + 7 >> 3;
    }

    private static int bitPos(int n) {
        return n & 7;
    }

    private static int charOffset(int n) {
        return n >> 3;
    }

    private static byte bmSetNull(byte c, int n) {
        return (byte)(c + (1 << 7 - SerializeBlock.bitPos(n)));
    }

    private static void handleBoolean(ByteArrayOutputStream buf, Object o) {
        boolean v = (Boolean)o;
        if (v) {
            buf.write(1);
        } else {
            buf.write(0);
        }
    }

    private static void SerializeInt(byte[] buf, int offset, int v) {
        buf[offset] = (byte)(v & 0xFF);
        buf[offset + 1] = (byte)(v >> 8 & 0xFF);
        buf[offset + 2] = (byte)(v >> 16 & 0xFF);
        buf[offset + 3] = (byte)(v >> 24 & 0xFF);
    }

    private static void SerializeLong(byte[] buf, int offset, long v) {
        buf[offset] = (byte)(v & 0xFFL);
        buf[offset + 1] = (byte)(v >> 8 & 0xFFL);
        buf[offset + 2] = (byte)(v >> 16 & 0xFFL);
        buf[offset + 3] = (byte)(v >> 24 & 0xFFL);
        buf[offset + 4] = (byte)(v >> 32 & 0xFFL);
        buf[offset + 5] = (byte)(v >> 40 & 0xFFL);
        buf[offset + 6] = (byte)(v >> 48 & 0xFFL);
        buf[offset + 7] = (byte)(v >> 56 & 0xFFL);
    }

    private static void SerializeShort(byte[] buf, int offset, short v) {
        buf[offset] = (byte)(v & 0xFF);
        buf[offset + 1] = (byte)(v >> 8 & 0xFF);
    }

    public static void serializeByteArray(byte[] buf, int offset, byte[] data) {
        System.arraycopy(data, 0, buf, offset, data.length);
    }

    private static int serializeColumn(ColumnInfo columnInfo, byte[] buf, int offset, int precision) throws SQLException {
        Integer dataLen = DataLengthCfg.getDataLength(columnInfo.getType());
        SerializeBlock.SerializeInt(buf, offset, columnInfo.getSerializeSize());
        SerializeBlock.SerializeInt(buf, offset += 4, columnInfo.getType());
        SerializeBlock.SerializeInt(buf, offset += 4, columnInfo.getDataList().size());
        offset += 4;
        for (Object o : columnInfo.getDataList()) {
            if (o == null) {
                buf[offset++] = 1;
                continue;
            }
            buf[offset++] = 0;
        }
        if (dataLen != null) {
            buf[offset++] = 0;
            SerializeBlock.SerializeNormalDataType(columnInfo.getType(), buf, offset, columnInfo.getDataList(), precision);
            return offset;
        }
        buf[offset++] = 1;
        int bufferLength = 0;
        block5: for (Object o : columnInfo.getDataList()) {
            if (o == null) {
                SerializeBlock.SerializeInt(buf, offset, 0);
                offset += 4;
                continue;
            }
            switch (columnInfo.getType()) {
                case 8: 
                case 15: 
                case 16: 
                case 20: {
                    Object v = (byte[])o;
                    SerializeBlock.SerializeInt(buf, offset, ((Object)v).length);
                    offset += 4;
                    bufferLength += ((Object)v).length;
                    continue block5;
                }
                case 10: {
                    Object v = (String)o;
                    int len = ((String)v).getBytes().length;
                    SerializeBlock.SerializeInt(buf, offset, len);
                    offset += 4;
                    bufferLength += len;
                    continue block5;
                }
            }
            throw TSDBError.createSQLException(8963, "unsupported data type : " + columnInfo.getType());
        }
        SerializeBlock.SerializeInt(buf, offset, bufferLength);
        SerializeBlock.SerializeArrayDataType(columnInfo.getType(), buf, offset += 4, columnInfo.getDataList());
        return offset;
    }

    private static void SerializeNormalDataType(int dataType, byte[] buf, int offset, List<Object> objectList, int precision) throws SQLException {
        switch (dataType) {
            case 1: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size());
                offset += 4;
                for (Object o : objectList) {
                    if (o == null) {
                        buf[offset++] = 0;
                        continue;
                    }
                    boolean v = (Boolean)o;
                    buf[offset++] = v ? (byte)1 : 0;
                }
                break;
            }
            case 2: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size());
                offset += 4;
                for (Object o : objectList) {
                    if (o == null) {
                        buf[offset++] = 0;
                        continue;
                    }
                    byte v = (Byte)o;
                    buf[offset++] = v;
                }
                break;
            }
            case 11: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size());
                offset += 4;
                for (Object o : objectList) {
                    if (o == null) {
                        buf[offset++] = 0;
                        continue;
                    }
                    short v = (Short)o;
                    if (v < 0 || v > 255) {
                        throw TSDBError.createSQLException(8963, "utinyint value is out of range");
                    }
                    buf[offset++] = (byte)(v & 0xFF);
                }
                break;
            }
            case 3: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size() * 2);
                offset += 4;
                for (Object o : objectList) {
                    if (o != null) {
                        SerializeBlock.SerializeShort(buf, offset, (Short)o);
                    } else {
                        SerializeBlock.SerializeShort(buf, offset, (short)0);
                    }
                    offset += 2;
                }
                break;
            }
            case 12: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size() * 2);
                offset += 4;
                for (Object o : objectList) {
                    if (o != null) {
                        int v = (Integer)o;
                        if (v < 0 || v > 65535) {
                            throw TSDBError.createSQLException(8963, "usmallint value is out of range");
                        }
                        SerializeBlock.SerializeShort(buf, offset, (short)(v & 0xFFFF));
                    } else {
                        SerializeBlock.SerializeShort(buf, offset, (short)0);
                    }
                    offset += 2;
                }
                break;
            }
            case 4: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size() * 4);
                offset += 4;
                for (Object o : objectList) {
                    if (o != null) {
                        SerializeBlock.SerializeInt(buf, offset, (Integer)o);
                    } else {
                        SerializeBlock.SerializeInt(buf, offset, 0);
                    }
                    offset += 4;
                }
                break;
            }
            case 13: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size() * 4);
                offset += 4;
                for (Object o : objectList) {
                    if (o != null) {
                        long v = (Long)o;
                        if (v < 0L || v > 0xFFFFFFFFL) {
                            throw TSDBError.createSQLException(8963, "uint value is out of range");
                        }
                        SerializeBlock.SerializeInt(buf, offset, (int)(v & 0xFFFFFFFFL));
                    } else {
                        SerializeBlock.SerializeInt(buf, offset, 0);
                    }
                    offset += 4;
                }
                break;
            }
            case 5: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size() * 8);
                offset += 4;
                for (Object o : objectList) {
                    if (o != null) {
                        SerializeBlock.SerializeLong(buf, offset, (Long)o);
                    } else {
                        SerializeBlock.SerializeLong(buf, offset, 0L);
                    }
                    offset += 8;
                }
                break;
            }
            case 14: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size() * 8);
                offset += 4;
                for (Object o : objectList) {
                    if (o != null) {
                        BigInteger v = (BigInteger)o;
                        if (v.compareTo(BigInteger.ZERO) < 0 || v.compareTo(new BigInteger("18446744073709551615")) > 0) {
                            throw TSDBError.createSQLException(8963, "ubigint value is out of range");
                        }
                        SerializeBlock.SerializeLong(buf, offset, v.longValue());
                    } else {
                        SerializeBlock.SerializeLong(buf, offset, 0L);
                    }
                    offset += 8;
                }
                break;
            }
            case 6: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size() * 4);
                offset += 4;
                for (Object o : objectList) {
                    float v = 0.0f;
                    if (o != null) {
                        v = ((Float)o).floatValue();
                    }
                    int f = Float.floatToIntBits(v);
                    SerializeBlock.SerializeInt(buf, offset, f);
                    offset += 4;
                }
                break;
            }
            case 7: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size() * 8);
                offset += 4;
                for (Object o : objectList) {
                    double v = 0.0;
                    if (o != null) {
                        v = (Double)o;
                    }
                    long l = Double.doubleToLongBits(v);
                    SerializeBlock.SerializeLong(buf, offset, l);
                    offset += 8;
                }
                break;
            }
            case 9: {
                SerializeBlock.SerializeInt(buf, offset, objectList.size() * 8);
                offset += 4;
                for (Object o : objectList) {
                    if (o != null) {
                        long v;
                        if (o instanceof Instant) {
                            Instant instant = (Instant)o;
                            v = DateTimeUtils.toLong(instant, precision);
                            SerializeBlock.SerializeLong(buf, offset, v);
                            offset += 8;
                            continue;
                        }
                        if (o instanceof OffsetDateTime) {
                            OffsetDateTime offsetDateTime = (OffsetDateTime)o;
                            v = DateTimeUtils.toLong(offsetDateTime.toInstant(), precision);
                            SerializeBlock.SerializeLong(buf, offset, v);
                            offset += 8;
                            continue;
                        }
                        if (o instanceof ZonedDateTime) {
                            ZonedDateTime zonedDateTime = (ZonedDateTime)o;
                            v = DateTimeUtils.toLong(zonedDateTime.toInstant(), precision);
                            SerializeBlock.SerializeLong(buf, offset, v);
                            offset += 8;
                            continue;
                        }
                        if (o instanceof Long) {
                            SerializeBlock.SerializeLong(buf, offset, (Long)o);
                            offset += 8;
                            continue;
                        }
                        throw TSDBError.createSQLException(8963, "unsupported timestamp data type : " + o.getClass().getName());
                    }
                    SerializeBlock.SerializeLong(buf, offset, 0L);
                    offset += 8;
                }
                break;
            }
            default: {
                throw TSDBError.createSQLException(8963, "unsupported data type : " + dataType);
            }
        }
    }

    private static void SerializeArrayDataType(int dataType, byte[] buf, int offset, List<Object> objectList) throws SQLException {
        switch (dataType) {
            case 8: 
            case 15: 
            case 16: 
            case 20: {
                for (Object o : objectList) {
                    if (o == null) continue;
                    byte[] v = (byte[])o;
                    SerializeBlock.serializeByteArray(buf, offset, v);
                    offset += v.length;
                }
                break;
            }
            case 10: {
                for (Object o : objectList) {
                    if (o == null) continue;
                    String v = (String)o;
                    byte[] bytes = v.getBytes();
                    SerializeBlock.serializeByteArray(buf, offset, bytes);
                    offset += bytes.length;
                }
                break;
            }
            default: {
                throw TSDBError.createSQLException(8963, "unsupported data type : " + dataType);
            }
        }
    }

    public static int getTagTotalLength(TableInfo tableInfo, int toBebindTagCount) throws SQLException {
        int totalLength = 0;
        if (toBebindTagCount > 0) {
            if (tableInfo.getTagInfo().size() != toBebindTagCount) {
                throw TSDBError.createSQLException(8963, "table tag size is not match");
            }
            for (ColumnInfo tag : tableInfo.getTagInfo()) {
                if (tag.getDataList().isEmpty()) {
                    throw TSDBError.createSQLException(8963, "tag value is null, tbname: " + tableInfo.getTableName().toString());
                }
                int columnSize = SerializeBlock.getColumnSize(tag);
                tag.setSerializeSize(columnSize);
                totalLength += columnSize;
            }
        }
        return totalLength;
    }

    public static int getColTotalLength(TableInfo tableInfo, int toBebindColCount) throws SQLException {
        int totalLength = 0;
        if (toBebindColCount > 0) {
            if (tableInfo.getDataList().size() != toBebindColCount) {
                throw TSDBError.createSQLException(8963, "table column size is not match");
            }
            for (ColumnInfo columnInfo : tableInfo.getDataList()) {
                int columnSize = SerializeBlock.getColumnSize(columnInfo);
                columnInfo.setSerializeSize(columnSize);
                totalLength += columnSize;
            }
        }
        return totalLength;
    }

    public static int getColumnSize(ColumnInfo column) throws SQLException {
        Integer dataLen = DataLengthCfg.getDataLength(column.getType());
        if (dataLen != null) {
            return 17 + (dataLen + 1) * column.getDataList().size();
        }
        switch (column.getType()) {
            case 8: 
            case 15: 
            case 16: 
            case 20: {
                int totalLength = 0;
                for (Object o : column.getDataList()) {
                    if (o == null) continue;
                    byte[] v = (byte[])o;
                    totalLength += v.length;
                }
                return 17 + 5 * column.getDataList().size() + totalLength;
            }
            case 10: {
                int totalLength = 0;
                for (Object o : column.getDataList()) {
                    if (o == null) continue;
                    String v = (String)o;
                    totalLength += v.getBytes().length;
                }
                return 17 + 5 * column.getDataList().size() + totalLength;
            }
        }
        throw TSDBError.createSQLException(8963, "unsupported data type : " + column.getType());
    }

    public static byte[] getStmt2BindBlock(long reqId, long stmtId, HashMap<ByteBuffer, TableInfo> tableInfoMap, int toBeBindTableNameIndex, int toBebindTagCount, int toBebindColCount, int precision) throws SQLException {
        int totalTableNameSize = 0;
        ArrayList<Short> tableNameSizeList = new ArrayList<Short>();
        if (toBeBindTableNameIndex >= 0) {
            for (TableInfo tableInfo : tableInfoMap.values()) {
                if (tableInfo.getTableName().capacity() == 0) {
                    throw TSDBError.createSQLException(8963, "table name is empty");
                }
                int tableNameSize = tableInfo.getTableName().capacity() + 1;
                totalTableNameSize += tableNameSize;
                tableNameSizeList.add((short)tableNameSize);
            }
        }
        int totalTagSize = 0;
        ArrayList<Integer> tagSizeList = new ArrayList<Integer>();
        if (toBebindTagCount > 0) {
            for (TableInfo tableInfo : tableInfoMap.values()) {
                int tagSize = SerializeBlock.getTagTotalLength(tableInfo, toBebindTagCount);
                totalTagSize += tagSize;
                tagSizeList.add(tagSize);
            }
        }
        int totalColSize = 0;
        ArrayList<Integer> colSizeList = new ArrayList<Integer>();
        if (toBebindColCount > 0) {
            for (TableInfo tableInfo : tableInfoMap.values()) {
                int colSize = SerializeBlock.getColTotalLength(tableInfo, toBebindColCount);
                totalColSize += colSize;
                colSizeList.add(colSize);
            }
        }
        int totalSize = totalTableNameSize + totalTagSize + totalColSize;
        int toBebindTableNameCount = toBeBindTableNameIndex >= 0 ? 1 : 0;
        byte[] buf = new byte[58 + (totalSize += tableInfoMap.size() * (toBebindTableNameCount * 2 + (toBebindTagCount > 0 ? 1 : 0) * 4 + (toBebindColCount > 0 ? 1 : 0) * 4))];
        int offset = 0;
        SerializeBlock.SerializeLong(buf, offset, reqId);
        SerializeBlock.SerializeLong(buf, offset += 8, stmtId);
        SerializeBlock.SerializeLong(buf, offset += 8, 9L);
        SerializeBlock.SerializeShort(buf, offset += 8, (short)1);
        SerializeBlock.SerializeInt(buf, offset += 2, -1);
        SerializeBlock.SerializeInt(buf, offset += 4, totalSize + 28);
        SerializeBlock.SerializeInt(buf, offset += 4, tableInfoMap.size());
        SerializeBlock.SerializeInt(buf, offset += 4, toBebindTagCount);
        SerializeBlock.SerializeInt(buf, offset += 4, toBebindColCount);
        offset += 4;
        if (toBebindTableNameCount > 0) {
            SerializeBlock.SerializeInt(buf, offset, 28);
            offset += 4;
        } else {
            SerializeBlock.SerializeInt(buf, offset, 0);
            offset += 4;
        }
        if (toBebindTagCount > 0) {
            if (toBebindTableNameCount > 0) {
                SerializeBlock.SerializeInt(buf, offset, 28 + totalTableNameSize + 2 * tableInfoMap.size());
                offset += 4;
            } else {
                SerializeBlock.SerializeInt(buf, offset, 28);
                offset += 4;
            }
        } else {
            SerializeBlock.SerializeInt(buf, offset, 0);
            offset += 4;
        }
        if (toBebindColCount > 0) {
            int skipSize = 0;
            if (toBebindTableNameCount > 0) {
                skipSize += totalTableNameSize + 2 * tableInfoMap.size();
            }
            if (toBebindTagCount > 0) {
                skipSize += totalTagSize + 4 * tableInfoMap.size();
            }
            SerializeBlock.SerializeInt(buf, offset, 28 + skipSize);
            offset += 4;
        } else {
            SerializeBlock.SerializeInt(buf, offset, 0);
            offset += 4;
        }
        if (toBebindTableNameCount > 0) {
            for (Short tableNameLen : tableNameSizeList) {
                if (tableNameLen == 0) {
                    throw TSDBError.createSQLException(8963, "table name is empty");
                }
                SerializeBlock.SerializeShort(buf, offset, tableNameLen);
                offset += 2;
            }
            for (TableInfo tableInfo : tableInfoMap.values()) {
                if (tableInfo.getTableName().capacity() == 0) {
                    throw TSDBError.createSQLException(8963, "table name is empty");
                }
                SerializeBlock.serializeByteArray(buf, offset, tableInfo.getTableName().array());
                offset += tableInfo.getTableName().capacity();
                buf[offset++] = 0;
            }
        }
        if (toBebindTagCount > 0) {
            for (Integer tagsize : tagSizeList) {
                SerializeBlock.SerializeInt(buf, offset, tagsize);
                offset += 4;
            }
            for (TableInfo tableInfo : tableInfoMap.values()) {
                for (ColumnInfo tag : tableInfo.getTagInfo()) {
                    if (tag.getDataList().isEmpty()) {
                        throw TSDBError.createSQLException(8963, "tag value is null, tbname: " + tableInfo.getTableName().toString());
                    }
                    SerializeBlock.serializeColumn(tag, buf, offset, precision);
                    offset += tag.getSerializeSize();
                }
            }
        }
        if (toBebindColCount > 0) {
            for (Integer colSize : colSizeList) {
                SerializeBlock.SerializeInt(buf, offset, colSize);
                offset += 4;
            }
            for (TableInfo tableInfo : tableInfoMap.values()) {
                for (ColumnInfo col : tableInfo.getDataList()) {
                    SerializeBlock.serializeColumn(col, buf, offset, precision);
                    offset += col.getSerializeSize();
                }
            }
        }
        return buf;
    }

    public static byte[] shortToBytes(int v) {
        byte[] result = new byte[]{(byte)(v & 0xFF), (byte)(v >> 8 & 0xFF)};
        return result;
    }

    public static byte[] intToBytes(int v) {
        byte[] result = new byte[]{(byte)(v & 0xFF), (byte)(v >> 8 & 0xFF), (byte)(v >> 16 & 0xFF), (byte)(v >> 24 & 0xFF)};
        return result;
    }

    public static byte[] longToBytes(long v) {
        byte[] result = new byte[]{(byte)(v & 0xFFL), (byte)(v >> 8 & 0xFFL), (byte)(v >> 16 & 0xFFL), (byte)(v >> 24 & 0xFFL), (byte)(v >> 32 & 0xFFL), (byte)(v >> 40 & 0xFFL), (byte)(v >> 48 & 0xFFL), (byte)(v >> 56 & 0xFFL)};
        return result;
    }
}

