/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.utils.DateTimeUtils;
import com.taosdata.jdbc.utils.UnsignedDataUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;

public class DataTypeConverUtil {
    public static boolean getBoolean(int taosType, Object value) throws SQLDataException {
        switch (taosType) {
            case 2: {
                return (Byte)value == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 3: 
            case 11: {
                return (Short)value == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 4: 
            case 12: {
                return (Integer)value == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 5: 
            case 13: {
                return (Long)value == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            case 9: {
                return ((Instant)value).toEpochMilli() == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            case 14: {
                return value.equals(BigInteger.ZERO) ? Boolean.FALSE : Boolean.TRUE;
            }
            case 6: {
                return ((Float)value).floatValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE;
            }
            case 7: {
                return (Double)value == 0.0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 10: {
                if ("TRUE".compareToIgnoreCase((String)value) == 0) {
                    return Boolean.TRUE;
                }
                if ("FALSE".compareToIgnoreCase((String)value) == 0) {
                    return Boolean.FALSE;
                }
                throw new SQLDataException();
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                if ("TRUE".compareToIgnoreCase(tmp) == 0) {
                    return Boolean.TRUE;
                }
                if ("FALSE".compareToIgnoreCase(tmp) == 0) {
                    return Boolean.FALSE;
                }
                throw new SQLDataException();
            }
        }
        return Boolean.FALSE;
    }

    private static void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        throw TSDBError.createSQLException(8980, "'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the jdbcType " + TSDBConstants.jdbcType2TaosTypeName(jdbcType));
    }

    public static byte getByte(int taosType, Object value, int columnIndex) throws SQLException {
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? (byte)1 : 0;
            }
            case 3: 
            case 11: {
                short tmp = (Short)value;
                if (tmp < -128 || tmp > 127) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 4: 
            case 12: {
                int tmp = (Integer)value;
                if (tmp < -128 || tmp > 127) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 5: 
            case 13: {
                long tmp = (Long)value;
                if (tmp < -128L || tmp > 127L) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 14: {
                BigInteger tmp = (BigInteger)value;
                if (tmp.compareTo(BigInteger.valueOf(-128L)) < 0 || tmp.compareTo(BigInteger.valueOf(127L)) > 0) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, -6);
                }
                return tmp.byteValue();
            }
            case 6: {
                float tmp = ((Float)value).floatValue();
                if (tmp < -128.0f || tmp > 127.0f) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 7: {
                double tmp = (Double)value;
                if (tmp < -128.0 || tmp > 127.0) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, -6);
                }
                return (byte)tmp;
            }
            case 10: {
                return Byte.parseByte((String)value);
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Byte.parseByte(tmp);
            }
        }
        return 0;
    }

    public static short getShort(int taosType, Object value, int columnIndex) throws SQLException {
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? (short)1 : 0;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 11: {
                return (Short)value;
            }
            case 4: 
            case 12: {
                int tmp = (Integer)value;
                if (tmp < Short.MIN_VALUE || tmp > Short.MAX_VALUE) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, 5);
                }
                return (short)tmp;
            }
            case 5: 
            case 13: {
                long tmp = (Long)value;
                if (tmp < -32768L || tmp > 32767L) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, 5);
                }
                return (short)tmp;
            }
            case 14: {
                BigInteger tmp = (BigInteger)value;
                if (tmp.compareTo(BigInteger.valueOf(-32768L)) < 0 || tmp.compareTo(BigInteger.valueOf(32767L)) > 0) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, 5);
                }
                return tmp.shortValue();
            }
            case 6: {
                float tmp = ((Float)value).floatValue();
                if (tmp < -32768.0f || tmp > 32767.0f) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, 5);
                }
                return (short)tmp;
            }
            case 7: {
                double tmp = (Double)value;
                if (tmp < -32768.0 || tmp > 32767.0) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, 5);
                }
                return (short)tmp;
            }
            case 10: {
                return Short.parseShort((String)value);
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Short.parseShort(tmp);
            }
        }
        return 0;
    }

    public static int getInt(int taosType, Object value, int columnIndex) throws SQLException {
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? 1 : 0;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)value).shortValue();
            }
            case 4: 
            case 12: {
                return (Integer)value;
            }
            case 5: 
            case 13: {
                long tmp = (Long)value;
                if (tmp < Integer.MIN_VALUE || tmp > Integer.MAX_VALUE) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, 4);
                }
                return (int)tmp;
            }
            case 14: {
                BigInteger tmp = (BigInteger)value;
                if (tmp.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || tmp.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, 4);
                }
                return tmp.intValue();
            }
            case 6: {
                float tmp = ((Float)value).floatValue();
                if (tmp < -2.1474836E9f || tmp > 2.1474836E9f) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, 4);
                }
                return (int)tmp;
            }
            case 7: {
                double tmp = (Double)value;
                if (tmp < -2.147483648E9 || tmp > 2.147483647E9) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, 4);
                }
                return (int)tmp;
            }
            case 10: {
                return Integer.parseInt((String)value);
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Integer.parseInt(tmp);
            }
        }
        return 0;
    }

    public static long getLong(int taosType, Object value, int columnIndex, int timestampPrecision) throws SQLException {
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            switch (timestampPrecision) {
                default: {
                    return ts.getTime();
                }
                case 1: {
                    return ts.getTime() * 1000L + (long)(ts.getNanos() / 1000 % 1000);
                }
                case 2: 
            }
            return ts.getTime() * 1000000L + (long)(ts.getNanos() % 1000000);
        }
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? 1L : 0L;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)value).shortValue();
            }
            case 4: 
            case 12: {
                return ((Integer)value).intValue();
            }
            case 5: 
            case 13: {
                return (Long)value;
            }
            case 14: {
                BigInteger tmp = (BigInteger)value;
                if (tmp.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0 || tmp.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, -5);
                }
                return tmp.longValue();
            }
            case 9: {
                Instant ts = (Instant)value;
                return DateTimeUtils.toLong(ts, timestampPrecision);
            }
            case 6: {
                float tmp = ((Float)value).floatValue();
                if (tmp < -9.223372E18f || tmp > 9.223372E18f) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, -5);
                }
                return (long)tmp;
            }
            case 7: {
                double tmp = (Double)value;
                if (tmp < -9.223372036854776E18 || tmp > 9.223372036854776E18) {
                    DataTypeConverUtil.throwRangeException(value.toString(), columnIndex, -5);
                }
                return (long)tmp;
            }
            case 10: {
                return Long.parseLong((String)value);
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Long.parseLong(tmp);
            }
        }
        return 0L;
    }

    public static float getFloat(int taosType, Object value, int columnIndex) throws SQLException {
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? 1.0f : 0.0f;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)value).shortValue();
            }
            case 4: 
            case 12: {
                return ((Integer)value).intValue();
            }
            case 5: 
            case 13: {
                return ((Long)value).longValue();
            }
            case 14: {
                BigInteger tmp = (BigInteger)value;
                return tmp.floatValue();
            }
            case 7: {
                Double tmp = (Double)value;
                return tmp.floatValue();
            }
            case 10: {
                return Float.parseFloat(value.toString());
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Float.parseFloat(tmp);
            }
        }
        return 0.0f;
    }

    public static double getDouble(int taosType, Object value, int columnIndex, int timestampPrecision) throws SQLException {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
            case 2: {
                return ((Byte)value).byteValue();
            }
            case 3: 
            case 11: {
                return ((Short)value).shortValue();
            }
            case 4: 
            case 12: {
                return ((Integer)value).intValue();
            }
            case 5: 
            case 13: {
                return ((Long)value).longValue();
            }
            case 14: {
                BigInteger tmp = (BigInteger)value;
                return tmp.doubleValue();
            }
            case 9: {
                Instant ts = (Instant)value;
                return DateTimeUtils.toLong(ts, timestampPrecision).longValue();
            }
            case 10: {
                return Double.parseDouble(value.toString());
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return Double.parseDouble(tmp);
            }
        }
        return 0.0;
    }

    public static byte[] getBytes(Object value) throws SQLException {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        if (value instanceof Long) {
            return Longs.toByteArray((long)((Long)value));
        }
        if (value instanceof Integer) {
            return Ints.toByteArray((int)((Integer)value));
        }
        if (value instanceof Short) {
            return Shorts.toByteArray((short)((Short)value));
        }
        if (value instanceof Byte) {
            return new byte[]{(Byte)value};
        }
        if (value instanceof Instant) {
            return Timestamp.from((Instant)value).toString().getBytes();
        }
        return value.toString().getBytes();
    }

    public static String getString(Object value) throws SQLException {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Instant) {
            return Timestamp.from((Instant)value).toString();
        }
        if (value instanceof byte[]) {
            String charset = TaosGlobalConfig.getCharset();
            try {
                return new String((byte[])value, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return value.toString();
    }

    public static Date getDate(Object value, ZoneId zoneId) {
        if (value instanceof Instant) {
            return DateTimeUtils.getDate((Instant)value, zoneId);
        }
        if (value instanceof byte[]) {
            String tmp;
            String charset = TaosGlobalConfig.getCharset();
            try {
                tmp = new String((byte[])value, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
            return DateTimeUtils.parseDate(tmp, zoneId);
        }
        return DateTimeUtils.parseDate(value.toString(), zoneId);
    }

    public static Time getTime(Object value, ZoneId zoneId) {
        if (value instanceof Instant) {
            return DateTimeUtils.getTime((Instant)value, zoneId);
        }
        String tmp = "";
        if (value instanceof byte[]) {
            String charset = TaosGlobalConfig.getCharset();
            try {
                tmp = new String((byte[])value, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            tmp = value.toString();
        }
        Time time = null;
        try {
            time = DateTimeUtils.parseTime(tmp, zoneId);
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return time;
    }

    public static BigDecimal getBigDecimal(int taosType, Object value) {
        switch (taosType) {
            case 1: {
                return (Boolean)value != false ? new BigDecimal(1) : new BigDecimal(0);
            }
            case 2: {
                return new BigDecimal(((Byte)value).byteValue());
            }
            case 3: 
            case 11: {
                return new BigDecimal(((Short)value).shortValue());
            }
            case 4: 
            case 12: {
                return new BigDecimal((Integer)value);
            }
            case 5: 
            case 13: {
                return new BigDecimal((Long)value);
            }
            case 14: {
                return new BigDecimal((BigInteger)value);
            }
            case 6: {
                return BigDecimal.valueOf(((Float)value).floatValue());
            }
            case 7: {
                return BigDecimal.valueOf((Double)value);
            }
            case 9: {
                return new BigDecimal(((Instant)value).toEpochMilli());
            }
            case 10: {
                return new BigDecimal(value.toString());
            }
            case 8: 
            case 15: 
            case 16: {
                String tmp;
                String charset = TaosGlobalConfig.getCharset();
                try {
                    tmp = new String((byte[])value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e.getMessage());
                }
                return new BigDecimal(tmp);
            }
        }
        return new BigDecimal(0);
    }

    public static Object parseValue(int type, Object source) {
        switch (type) {
            case 1: {
                byte val = (Byte)source;
                return val == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 11: {
                byte val = (Byte)source;
                return UnsignedDataUtils.parseUTinyInt(val);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: {
                return source;
            }
            case 12: {
                short val = (Short)source;
                return UnsignedDataUtils.parseUSmallInt(val);
            }
            case 13: {
                int val = (Integer)source;
                return UnsignedDataUtils.parseUInteger(val);
            }
            case 14: {
                long val = (Long)source;
                return new BigInteger(1, new byte[]{(byte)(val >>> 56), (byte)(val >>> 48), (byte)(val >>> 40), (byte)(val >>> 32), (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val});
            }
            case 10: {
                int[] tmp = (int[])source;
                return new String(tmp, 0, tmp.length);
            }
        }
        return null;
    }
}

