/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.tmq;

import com.taosdata.jdbc.ws.entity.Response;
import com.taosdata.jdbc.ws.tmq.entity.AssignmentResp;
import com.taosdata.jdbc.ws.tmq.entity.CommitOffsetResp;
import com.taosdata.jdbc.ws.tmq.entity.CommitResp;
import com.taosdata.jdbc.ws.tmq.entity.CommittedResp;
import com.taosdata.jdbc.ws.tmq.entity.FetchJsonMetaResp;
import com.taosdata.jdbc.ws.tmq.entity.FetchRawBlockResp;
import com.taosdata.jdbc.ws.tmq.entity.ListTopicsResp;
import com.taosdata.jdbc.ws.tmq.entity.PollResp;
import com.taosdata.jdbc.ws.tmq.entity.PositionResp;
import com.taosdata.jdbc.ws.tmq.entity.SeekResp;
import com.taosdata.jdbc.ws.tmq.entity.SubscribeResp;
import com.taosdata.jdbc.ws.tmq.entity.UnsubscribeResp;
import java.util.HashMap;
import java.util.Map;

public enum ConsumerAction {
    SUBSCRIBE("subscribe", SubscribeResp.class),
    POLL("poll", PollResp.class),
    FETCH_RAW_DATA("fetch_raw_data", FetchRawBlockResp.class),
    COMMIT("commit", CommitResp.class),
    ASSIGNMENT("assignment", AssignmentResp.class),
    SEEK("seek", SeekResp.class),
    UNSUBSCRIBE("unsubscribe", UnsubscribeResp.class),
    COMMIT_OFFSET("commit_offset", CommitOffsetResp.class),
    COMMITTED("committed", CommittedResp.class),
    POSITION("position", PositionResp.class),
    LIST_TOPICS("list_topics", ListTopicsResp.class),
    FETCH_JSON_META("fetch_json_meta", FetchJsonMetaResp.class);

    private final String action;
    private final Class<? extends Response> clazz;
    private static final Map<String, ConsumerAction> actions;

    private ConsumerAction(String action, Class<? extends Response> clazz) {
        this.action = action;
        this.clazz = clazz;
    }

    public String getAction() {
        return this.action;
    }

    public Class<? extends Response> getResponseClazz() {
        return this.clazz;
    }

    public static ConsumerAction of(String action) {
        if (null == action || action.equals("")) {
            return null;
        }
        return actions.get(action);
    }

    static {
        actions = new HashMap<String, ConsumerAction>();
        for (ConsumerAction value : ConsumerAction.values()) {
            actions.put(value.action, value);
        }
    }
}

