/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.tmq.entity;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.DataType;
import com.taosdata.jdbc.enums.TmqMessageType;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.rs.RestfulResultSetMetaData;
import com.taosdata.jdbc.tmq.ConsumerRecord;
import com.taosdata.jdbc.tmq.ConsumerRecords;
import com.taosdata.jdbc.tmq.TMQEnhMap;
import com.taosdata.jdbc.tmq.TopicPartition;
import com.taosdata.jdbc.utils.DataTypeConverUtil;
import com.taosdata.jdbc.utils.DateTimeUtils;
import com.taosdata.jdbc.utils.DecimalUtil;
import com.taosdata.jdbc.ws.entity.Response;
import com.taosdata.jdbc.ws.tmq.ConsumerAction;
import com.taosdata.jdbc.ws.tmq.entity.PollResp;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FetchRawBlockResp
extends Response {
    private ByteBuffer buffer;
    private long time;
    private int code;
    private String message;
    private short version;
    private long messageID;
    private short metaType;
    private int rawBlockLength;
    private RestfulResultSetMetaData metaData;
    private final List<RestfulResultSet.Field> fields = new ArrayList<RestfulResultSet.Field>();
    private List<String> columnNames = new ArrayList<String>();
    private List<List<Object>> resultData;
    private byte precision;
    private int rows = 0;
    private String tableName = "";

    public FetchRawBlockResp(ByteBuffer buffer) {
        this.setAction(ConsumerAction.FETCH_RAW_DATA.getAction());
        this.buffer = buffer;
    }

    public void init() {
        this.buffer.getLong();
        this.version = this.buffer.getShort();
        this.time = this.buffer.getLong();
        this.setReqId(this.buffer.getLong());
        this.code = this.buffer.getInt();
        int messageLen = this.buffer.getInt();
        byte[] msgBytes = new byte[messageLen];
        this.buffer.get(msgBytes);
        this.message = new String(msgBytes, StandardCharsets.UTF_8);
        this.messageID = this.buffer.getLong();
        this.metaType = this.buffer.getShort();
        this.rawBlockLength = this.buffer.getInt();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public long getTime() {
        return this.time;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public short getVersion() {
        return this.version;
    }

    private void skipHead() throws SQLException {
        byte version = this.buffer.get();
        if (version >= 100) {
            int skip = this.buffer.getInt();
            this.buffer.position(this.buffer.position() + skip);
        } else {
            int skip = this.getTypeSkip(version);
            this.buffer.position(this.buffer.position() + skip);
            version = this.buffer.get();
            skip = this.getTypeSkip(version);
            this.buffer.position(this.buffer.position() + skip);
        }
    }

    private int getTypeSkip(byte type) throws SQLException {
        switch (type) {
            case 1: {
                return 8;
            }
            case 2: 
            case 3: {
                return 16;
            }
        }
        throw TSDBError.createSQLException(9040, "FetchBlockRawResp getTypeSkip error, type: " + type);
    }

    public void parseBlockInfos() throws SQLException {
        this.skipHead();
        int blockNum = this.buffer.getInt();
        int cols = 0;
        boolean withTableName = this.buffer.get() != 0;
        this.buffer.get();
        for (int i = 0; i < blockNum; ++i) {
            int blockTotalLen = this.parseVariableByteInteger();
            this.buffer.position(this.buffer.position() + 17);
            this.precision = this.buffer.get();
            if (i == 0) {
                int j;
                int backupBlockPos = this.buffer.position();
                this.buffer.position(this.buffer.position() + blockTotalLen - 18);
                cols = this.parseZigzagVariableByteInteger();
                this.resultData = new ArrayList<List<Object>>(cols);
                for (j = 0; j < cols; ++j) {
                    this.resultData.add(new ArrayList());
                }
                this.parseZigzagVariableByteInteger();
                for (j = 0; j < cols; ++j) {
                    RestfulResultSet.Field field = this.parseSchema();
                    this.fields.add(field);
                    this.columnNames.add(field.getName());
                }
                if (withTableName) {
                    this.tableName = this.parseName();
                }
                this.buffer.position(backupBlockPos);
            }
            this.fetchBlockData();
            this.buffer.get();
            this.parseZigzagVariableByteInteger();
            this.parseZigzagVariableByteInteger();
            for (int j = 0; j < cols; ++j) {
                this.skipSchema(withTableName);
            }
            if (!withTableName) continue;
            int tableNameLen = this.parseVariableByteInteger();
            this.buffer.position(this.buffer.position() + tableNameLen);
        }
        if (!this.resultData.isEmpty()) {
            this.rows = this.resultData.get(0).size();
        }
    }

    public ConsumerRecords<TMQEnhMap> getEhnMapList(PollResp pollResp, ZoneId zoneId) throws SQLException {
        this.skipHead();
        int blockNum = this.buffer.getInt();
        int cols = 0;
        ConsumerRecords<TMQEnhMap> records = new ConsumerRecords<TMQEnhMap>();
        boolean withTableName = this.buffer.get() != 0;
        this.buffer.get();
        for (int i = 0; i < blockNum; ++i) {
            int j;
            int blockTotalLen = this.parseVariableByteInteger();
            this.buffer.position(this.buffer.position() + 17);
            this.precision = this.buffer.get();
            this.fields.clear();
            this.columnNames.clear();
            int backupBlockPos = this.buffer.position();
            this.buffer.position(this.buffer.position() + blockTotalLen - 18);
            cols = this.parseZigzagVariableByteInteger();
            this.resultData = new ArrayList<List<Object>>(cols);
            for (j = 0; j < cols; ++j) {
                this.resultData.add(new ArrayList());
            }
            this.parseZigzagVariableByteInteger();
            for (j = 0; j < cols; ++j) {
                RestfulResultSet.Field field = this.parseSchema();
                this.fields.add(field);
                this.columnNames.add(field.getName());
            }
            if (withTableName) {
                this.tableName = this.parseName();
            }
            this.buffer.position(backupBlockPos);
            this.fetchBlockData();
            this.buffer.get();
            this.parseZigzagVariableByteInteger();
            this.parseZigzagVariableByteInteger();
            for (j = 0; j < cols; ++j) {
                this.skipSchema(withTableName);
            }
            if (withTableName) {
                int tableNameLen = this.parseVariableByteInteger();
                this.buffer.position(this.buffer.position() + tableNameLen);
            }
            int lineNum = this.resultData.get(0).size();
            for (int j2 = 0; j2 < lineNum; ++j2) {
                HashMap<String, Object> lineDataMap = new HashMap<String, Object>();
                for (int k = 0; k < cols; ++k) {
                    Object o;
                    if (this.fields.get(k).getTaosType() == 9) {
                        o = (Long)DataTypeConverUtil.parseValue(9, this.resultData.get(k).get(j2));
                        Instant instant = DateTimeUtils.parseTimestampColumnData((Long)o, this.precision);
                        Timestamp t = DateTimeUtils.getTimestamp(instant, zoneId);
                        lineDataMap.put(this.columnNames.get(k), t);
                        continue;
                    }
                    o = DataTypeConverUtil.parseValue(this.fields.get(k).getTaosType(), this.resultData.get(k).get(j2));
                    lineDataMap.put(this.columnNames.get(k), o);
                }
                TMQEnhMap map = new TMQEnhMap(this.tableName, lineDataMap);
                ConsumerRecord<TMQEnhMap> r = new ConsumerRecord.Builder().topic(pollResp.getTopic()).dbName(pollResp.getDatabase()).vGroupId(pollResp.getVgroupId()).offset(pollResp.getOffset()).messageType(TmqMessageType.TMQ_RES_DATA).meta(null).value(map).build();
                TopicPartition tp = new TopicPartition(pollResp.getTopic(), pollResp.getVgroupId());
                records.put(tp, r);
            }
            this.resultData.clear();
        }
        return records;
    }

    private int parseVariableByteInteger() {
        int multiplier = 1;
        int value = 0;
        while (true) {
            byte encodedByte = this.buffer.get();
            value += (encodedByte & 0x7F) * multiplier;
            if ((encodedByte & 0x80) == 0) break;
            multiplier *= 128;
        }
        return value;
    }

    private int zigzagDecode(int n) {
        return n >> 1 ^ -(n & 1);
    }

    private int parseZigzagVariableByteInteger() {
        return this.zigzagDecode(this.parseVariableByteInteger());
    }

    private String parseName() {
        int nameLen = this.parseVariableByteInteger();
        byte[] name = new byte[nameLen - 1];
        this.buffer.get(name);
        this.buffer.position(this.buffer.position() + 1);
        return new String(name, StandardCharsets.UTF_8);
    }

    private RestfulResultSet.Field parseSchema() throws SQLException {
        byte taosType = this.buffer.get();
        int jdbcType = DataType.convertTaosType2DataType(taosType).getJdbcTypeValue();
        this.buffer.get();
        int bytes = this.parseZigzagVariableByteInteger();
        this.parseZigzagVariableByteInteger();
        String name = this.parseName();
        return new RestfulResultSet.Field(name, jdbcType, bytes, "", taosType, 0);
    }

    private void skipSchema(boolean withTableName) {
        this.buffer.position(this.buffer.position() + 2);
        this.parseZigzagVariableByteInteger();
        this.parseZigzagVariableByteInteger();
        int nameLen = this.parseVariableByteInteger();
        this.buffer.position(this.buffer.position() + nameLen);
    }

    private int getScaleFromRowBlock(ByteBuffer buffer, int pHeader, int colIndex) {
        int backupPos = buffer.position();
        buffer.position(pHeader);
        buffer.position(buffer.position() + colIndex * 5 + 1);
        int scale = buffer.getInt();
        buffer.position(backupPos);
        return scale & 0xFF;
    }

    private void fetchBlockData() throws SQLException {
        this.buffer.position(this.buffer.position() + 8);
        int numOfRows = this.buffer.getInt();
        int bitMapOffset = this.bitmapLen(numOfRows);
        int beforeColLenPos = this.buffer.position() + 16;
        int pHeader = this.buffer.position() + 16 + this.fields.size() * 5;
        this.buffer.position(pHeader);
        ArrayList<Integer> lengths = new ArrayList<Integer>(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            lengths.add(this.buffer.getInt());
        }
        pHeader = this.buffer.position();
        int length = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            List<Object> col = this.resultData.get(i);
            int type = this.fields.get(i).getTaosType();
            int scale = 0;
            if (type == 17 || type == 21) {
                scale = this.getScaleFromRowBlock(this.buffer, beforeColLenPos, i);
            }
            switch (type) {
                case 1: 
                case 2: 
                case 11: {
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (int j = 0; j < numOfRows; ++j) {
                        byte b = this.buffer.get();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(b);
                    }
                    break;
                }
                case 3: 
                case 12: {
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (int j = 0; j < numOfRows; ++j) {
                        short s = this.buffer.getShort();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(s);
                    }
                    break;
                }
                case 4: 
                case 13: {
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (int j = 0; j < numOfRows; ++j) {
                        int in = this.buffer.getInt();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(in);
                    }
                    break;
                }
                case 5: 
                case 9: 
                case 14: {
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (int j = 0; j < numOfRows; ++j) {
                        long l = this.buffer.getLong();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(l);
                    }
                    break;
                }
                case 6: {
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (int j = 0; j < numOfRows; ++j) {
                        float f = this.buffer.getFloat();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(Float.valueOf(f));
                    }
                    break;
                }
                case 7: {
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (int j = 0; j < numOfRows; ++j) {
                        double d = this.buffer.getDouble();
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        col.add(d);
                    }
                    break;
                }
                case 8: 
                case 15: 
                case 16: 
                case 20: {
                    Object[] tmp;
                    int m;
                    length = numOfRows * 4;
                    ArrayList<Integer> offset = new ArrayList<Integer>(numOfRows);
                    for (int m2 = 0; m2 < numOfRows; ++m2) {
                        offset.add(this.buffer.getInt());
                    }
                    int start = this.buffer.position();
                    for (m = 0; m < numOfRows; ++m) {
                        if (-1 == (Integer)offset.get(m)) {
                            col.add(null);
                            continue;
                        }
                        this.buffer.position(start + (Integer)offset.get(m));
                        int len = this.buffer.getShort() & 0xFFFF;
                        tmp = new byte[len];
                        this.buffer.get((byte[])tmp);
                        col.add(tmp);
                    }
                    break;
                }
                case 10: {
                    Object[] tmp;
                    int m;
                    length = numOfRows * 4;
                    ArrayList<Integer> offset = new ArrayList<Integer>(numOfRows);
                    for (int m3 = 0; m3 < numOfRows; ++m3) {
                        offset.add(this.buffer.getInt());
                    }
                    int start = this.buffer.position();
                    for (m = 0; m < numOfRows; ++m) {
                        if (-1 == (Integer)offset.get(m)) {
                            col.add(null);
                            continue;
                        }
                        this.buffer.position(start + (Integer)offset.get(m));
                        int len = (this.buffer.getShort() & 0xFFFF) / 4;
                        tmp = new int[len];
                        for (int n = 0; n < len; ++n) {
                            tmp[n] = this.buffer.getInt();
                        }
                        col.add(tmp);
                    }
                    break;
                }
                case 17: 
                case 21: {
                    int dataLen = type == 17 ? 16 : 8;
                    length = bitMapOffset;
                    byte[] tmp = new byte[bitMapOffset];
                    this.buffer.get(tmp);
                    for (int j = 0; j < numOfRows; ++j) {
                        byte[] tb = new byte[dataLen];
                        this.buffer.get(tb);
                        if (this.isNull(tmp, j)) {
                            col.add(null);
                            continue;
                        }
                        BigDecimal t = DecimalUtil.getBigDecimal(tb, scale);
                        col.add(t);
                    }
                    break;
                }
                default: {
                    col.add(null);
                }
            }
            this.buffer.position(pHeader += length + (Integer)lengths.get(i));
        }
    }

    private int bitmapLen(int n) {
        return n + 7 >> 3;
    }

    private boolean isNull(byte[] c, int n) {
        int position = n >>> 3;
        int index = n & 7;
        return (c[position] & 1 << 7 - index) == 1 << 7 - index;
    }

    public RestfulResultSetMetaData getMetaData() {
        return this.metaData;
    }

    public List<RestfulResultSet.Field> getFields() {
        return this.fields;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<List<Object>> getResultData() {
        return this.resultData;
    }

    public byte getPrecision() {
        return this.precision;
    }

    public int getRows() {
        return this.rows;
    }

    public String getTableName() {
        return this.tableName;
    }
}

