/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.tmq.meta;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.taosdata.jdbc.ws.tmq.meta.Meta;
import com.taosdata.jdbc.ws.tmq.meta.MetaAlterTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaCreateChildTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaCreateNormalTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaCreateSuperTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaDropSuperTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaDropTable;
import com.taosdata.jdbc.ws.tmq.meta.MetaType;
import com.taosdata.jdbc.ws.tmq.meta.TableType;
import java.io.IOException;

public class MetaDeserializer
extends StdDeserializer<Meta> {
    public MetaDeserializer() {
        this(null);
    }

    protected MetaDeserializer(Class<?> vc) {
        super(vc);
    }

    public Meta deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, IllegalArgumentException {
        ObjectCodec mapper = p.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(p);
        String type = node.get("type").asText();
        String tableType = null;
        if (null != node.get("tableType")) {
            tableType = node.get("tableType").asText();
        }
        return this.getMetaBasedOnTableType(mapper, node, type, tableType);
    }

    private Meta getMetaBasedOnTableType(ObjectCodec mapper, JsonNode node, String type, String tableType) throws JsonProcessingException {
        if (MetaType.CREATE.toString().equalsIgnoreCase(type)) {
            if (TableType.SUPER.toString().equalsIgnoreCase(tableType)) {
                return (Meta)mapper.treeToValue((TreeNode)node, MetaCreateSuperTable.class);
            }
            if (TableType.NORMAL.toString().equalsIgnoreCase(tableType)) {
                return (Meta)mapper.treeToValue((TreeNode)node, MetaCreateNormalTable.class);
            }
            if (TableType.CHILD.toString().equalsIgnoreCase(tableType)) {
                return (Meta)mapper.treeToValue((TreeNode)node, MetaCreateChildTable.class);
            }
        }
        if (MetaType.DROP.toString().equalsIgnoreCase(type)) {
            if (TableType.SUPER.toString().equalsIgnoreCase(tableType)) {
                return (Meta)mapper.treeToValue((TreeNode)node, MetaDropSuperTable.class);
            }
            return (Meta)mapper.treeToValue((TreeNode)node, MetaDropTable.class);
        }
        if (MetaType.ALTER.toString().equalsIgnoreCase(type)) {
            return (Meta)mapper.treeToValue((TreeNode)node, MetaAlterTable.class);
        }
        throw new IllegalArgumentException("Unsupported combination of 'type' and 'tableType' values: type=" + type + ", tableType=" + tableType);
    }
}

