/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.common;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.utils.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;

public class AutoExpandingBuffer {
    private CompositeByteBuf composite;
    private final PooledByteBufAllocator allocator = PooledByteBufAllocator.DEFAULT;
    private final int bufferSize;
    private ByteBuf currentBuffer;
    private boolean stopWrite = false;

    public AutoExpandingBuffer(int initialBufferSize, int maxComponents) {
        this.bufferSize = initialBufferSize;
        this.composite = this.allocator.compositeBuffer(maxComponents);
        this.currentBuffer = this.allocator.buffer(this.bufferSize);
    }

    public void writeBytes(byte[] src) throws SQLException {
        int bytesToWrite;
        if (this.stopWrite) {
            throw TSDBError.createSQLException(8963, "Cannot write to buffer after stopWrite has been called");
        }
        for (int bytesWritten = 0; bytesWritten < src.length; bytesWritten += bytesToWrite) {
            int writableBytes = this.currentBuffer.writableBytes();
            bytesToWrite = Math.min(writableBytes, src.length - bytesWritten);
            this.currentBuffer.writeBytes(src, bytesWritten, bytesToWrite);
            if (this.currentBuffer.writableBytes() != 0) continue;
            if (this.composite.numComponents() >= this.composite.maxNumComponents()) {
                throw TSDBError.createSQLException(8963, "Data too long, exceeded maximum components");
            }
            this.composite.addComponent(true, this.currentBuffer);
            this.currentBuffer = this.allocator.buffer(this.bufferSize);
        }
    }

    public int writeString(String src) throws SQLException {
        if (this.stopWrite) {
            throw TSDBError.createSQLException(8963, "Cannot write string after stopWrite has been called");
        }
        int totalLen = ByteBufUtil.utf8Bytes((CharSequence)src);
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes >= totalLen) {
            this.currentBuffer.writeCharSequence((CharSequence)src, StandardCharsets.UTF_8);
            return totalLen;
        }
        int bytesWritten = 0;
        byte[] srcBytes = src.getBytes(StandardCharsets.UTF_8);
        while (bytesWritten < totalLen) {
            writableBytes = this.currentBuffer.writableBytes();
            if (writableBytes >= totalLen - bytesWritten) {
                this.currentBuffer.writeBytes(srcBytes, bytesWritten, totalLen - bytesWritten);
                bytesWritten = totalLen;
            } else {
                this.currentBuffer.writeBytes(srcBytes, bytesWritten, writableBytes);
                bytesWritten += writableBytes;
            }
            if (this.currentBuffer.writableBytes() != 0) continue;
            if (this.composite.numComponents() >= this.composite.maxNumComponents()) {
                throw TSDBError.createSQLException(8963, "Data too long, exceeded maximum components");
            }
            this.composite.addComponent(true, this.currentBuffer);
            this.currentBuffer = this.allocator.buffer(this.bufferSize);
        }
        return totalLen;
    }

    public void writeInt(int src) throws SQLException {
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > 4) {
            this.currentBuffer.writeIntLE(src);
            return;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)4);
        heapBuf.writeIntLE(src);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
    }

    public void writeShort(short src) throws SQLException {
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > 2) {
            this.currentBuffer.writeShortLE((int)src);
            return;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)2);
        heapBuf.writeShortLE((int)src);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
    }

    private void serializeLong(ByteBuf buffer, int totalLen, long src, boolean isNull, byte type) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE((int)type);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(0);
        buffer.writeIntLE(8);
        buffer.writeLongLE(isNull ? 0L : src);
    }

    public int serializeLong(long src, boolean isNull, byte type) throws SQLException {
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 26)) {
            this.serializeLong(this.currentBuffer, totalLen, src, isNull, type);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeLong(heapBuf, totalLen, src, isNull, type);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    private void serializeTimeStamp(ByteBuf buffer, int totalLen, long src, boolean isNull) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE(9);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(0);
        buffer.writeIntLE(8);
        buffer.writeLongLE(isNull ? 0L : src);
    }

    public int serializeTimeStamp(long src, boolean isNull) throws SQLException {
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 26)) {
            this.serializeTimeStamp(this.currentBuffer, totalLen, src, isNull);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeTimeStamp(heapBuf, totalLen, src, isNull);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    private void serializeDouble(ByteBuf buffer, int totalLen, double src, boolean isNull) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE(7);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(0);
        buffer.writeIntLE(8);
        buffer.writeDoubleLE(isNull ? 0.0 : src);
    }

    public int serializeDouble(double src, boolean isNull) throws SQLException {
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 26)) {
            this.serializeDouble(this.currentBuffer, totalLen, src, isNull);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeDouble(heapBuf, totalLen, src, isNull);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    private void serializeBool(ByteBuf buffer, int totalLen, boolean src, boolean isNull) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE(1);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(0);
        buffer.writeIntLE(1);
        buffer.writeByte(!isNull && src ? 1 : 0);
    }

    public int serializeBool(boolean src, boolean isNull) throws SQLException {
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 19)) {
            this.serializeBool(this.currentBuffer, totalLen, src, isNull);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeBool(heapBuf, totalLen, src, isNull);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    private void serializeByte(ByteBuf buffer, int totalLen, byte src, boolean isNull, byte type) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE((int)type);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(0);
        buffer.writeIntLE(1);
        buffer.writeByte((int)(isNull ? (byte)0 : src));
    }

    public int serializeByte(byte src, boolean isNull, byte type) throws SQLException {
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 19)) {
            this.serializeByte(this.currentBuffer, totalLen, src, isNull, type);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeByte(heapBuf, totalLen, src, isNull, type);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    private void serializeShort(ByteBuf buffer, int totalLen, short src, boolean isNull, byte type) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE((int)type);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(0);
        buffer.writeIntLE(2);
        buffer.writeShortLE((int)(isNull ? (short)0 : src));
    }

    public int serializeShort(short src, boolean isNull, byte type) throws SQLException {
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 20)) {
            this.serializeShort(this.currentBuffer, totalLen, src, isNull, type);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeShort(heapBuf, totalLen, src, isNull, type);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    private void serializeInt(ByteBuf buffer, int totalLen, int src, boolean isNull, byte type) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE((int)type);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(0);
        buffer.writeIntLE(4);
        buffer.writeIntLE(isNull ? 0 : src);
    }

    public int serializeInt(int src, boolean isNull, byte type) throws SQLException {
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 22)) {
            this.serializeInt(this.currentBuffer, totalLen, src, isNull, type);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeInt(heapBuf, totalLen, src, isNull, type);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    private void serializeFloat(ByteBuf buffer, int totalLen, float src, boolean isNull) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE(6);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(0);
        buffer.writeIntLE(4);
        buffer.writeFloatLE(isNull ? 0.0f : src);
    }

    public int serializeFloat(float src, boolean isNull) throws SQLException {
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 22)) {
            this.serializeFloat(this.currentBuffer, totalLen, src, isNull);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeFloat(heapBuf, totalLen, src, isNull);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    private void serializeBytes(ByteBuf buffer, int totalLen, byte[] src, boolean isNull, int type) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE(type);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(1);
        buffer.writeIntLE(isNull ? 0 : src.length);
        buffer.writeIntLE(isNull ? 0 : src.length);
        if (!isNull) {
            buffer.writeBytes(src);
        }
    }

    public int serializeBytes(byte[] src, boolean isNull, int type) throws SQLException {
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 22 + src.length)) {
            this.serializeBytes(this.currentBuffer, totalLen, src, isNull, type);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeBytes(heapBuf, totalLen, src, isNull, type);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    private void serializeString(ByteBuf buffer, int totalLen, int strlen, String src, boolean isNull, int type) {
        buffer.writeIntLE(totalLen);
        buffer.writeIntLE(type);
        buffer.writeIntLE(1);
        buffer.writeByte(isNull ? 1 : 0);
        buffer.writeByte(1);
        buffer.writeIntLE(isNull ? 0 : strlen);
        buffer.writeIntLE(isNull ? 0 : strlen);
        if (!isNull) {
            ByteBufUtil.reserveAndWriteUtf8((ByteBuf)buffer, (CharSequence)src, (int)strlen);
        }
    }

    public int serializeString(String src, boolean isNull, int type) throws SQLException {
        int requiredBytes;
        int totalLen;
        int writableBytes = this.currentBuffer.writableBytes();
        if (writableBytes > (totalLen = 22 + (requiredBytes = src != null ? ByteBufUtil.utf8Bytes((CharSequence)src) : 0))) {
            this.serializeString(this.currentBuffer, totalLen, requiredBytes, src, isNull, type);
            return totalLen;
        }
        ByteBuf heapBuf = Unpooled.buffer((int)totalLen);
        this.serializeString(heapBuf, totalLen, requiredBytes, src, isNull, type);
        this.writeBytes(heapBuf.array());
        heapBuf.release();
        return totalLen;
    }

    public CompositeByteBuf getBuffer() {
        return this.composite;
    }

    public void release() {
        this.stopWrite();
        if (this.composite != null && this.composite.refCnt() > 0) {
            Utils.releaseByteBuf((ByteBuf)this.composite);
        }
        this.composite = null;
    }

    public void stopWrite() {
        if (!this.stopWrite) {
            this.composite.addComponent(true, this.currentBuffer);
            this.stopWrite = true;
        }
    }
}

