/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.common;

import com.taosdata.jdbc.TSDBError;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class TDBlob
implements Blob {
    private byte[] data;
    private boolean freed = false;
    private boolean readOnly = false;

    public TDBlob(byte[] data, boolean isReadOnly) {
        this.data = data;
        this.readOnly = isReadOnly;
    }

    @Override
    public long length() throws SQLException {
        this.checkIfFreed();
        return this.data.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkIfFreed();
        if (pos == 1L && length >= this.data.length) {
            return this.data;
        }
        if (pos < 1L || pos > (long)this.data.length) {
            throw TSDBError.createSQLException(8963, "Position out of range");
        }
        int startIdx = (int)(pos - 1L);
        int endIdx = Math.min(startIdx + length, this.data.length);
        byte[] result = new byte[endIdx - startIdx];
        System.arraycopy(this.data, startIdx, result, 0, result.length);
        return result;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkIfFreed();
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.checkIfFreed();
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        int shift;
        int i;
        this.checkIfFreed();
        if (start < 1L || start > (long)this.data.length) {
            return -1L;
        }
        int fromIndex = (int)(start - 1L);
        if (pattern.length == 0) {
            return (long)fromIndex + 1L;
        }
        int[] badCharShift = new int[256];
        for (i = 0; i < 256; ++i) {
            badCharShift[i] = -1;
        }
        for (i = 0; i < pattern.length; ++i) {
            badCharShift[pattern[i]] = i;
        }
        for (i = fromIndex; i <= this.data.length - pattern.length; i += Math.max(1, shift)) {
            int j;
            for (j = pattern.length - 1; j >= 0 && this.data[i + j] == pattern[j]; --j) {
            }
            if (j < 0) {
                return i + 1;
            }
            shift = badCharShift[this.data[i + j] & 0xFF];
        }
        return -1L;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (this.readOnly) {
            throw TSDBError.createSQLException(9040, "Read-only Blob implementation");
        }
        if (pos != 1L) {
            throw TSDBError.createSQLException(8963, "Only setting bytes from the beginning is supported");
        }
        this.data = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.data, 0, bytes.length);
        return bytes.length;
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.readOnly) {
            throw TSDBError.createSQLException(9040, "Read-only Blob implementation");
        }
        if (pos != 1L) {
            throw TSDBError.createSQLException(8963, "Only setting bytes from the beginning is supported");
        }
        if (offset + len > bytes.length) {
            throw TSDBError.createSQLException(8963, "Invalid len, bigger than bytes.length");
        }
        this.data = new byte[len];
        System.arraycopy(bytes, offset, this.data, 0, len);
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw TSDBError.createSQLException(8962, "Truncate operation is not supported on this Blob");
    }

    @Override
    public void free() throws SQLException {
        if (!this.freed) {
            this.freed = true;
            this.data = null;
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkIfFreed();
        if (pos < 1L || pos > (long)this.data.length) {
            throw TSDBError.createSQLException(8963, "Position out of range");
        }
        int startIdx = (int)(pos - 1L);
        int endIdx = (int)Math.min((long)startIdx + length, (long)this.data.length);
        return new ByteArrayInputStream(this.data, startIdx, endIdx - startIdx);
    }

    private void checkIfFreed() throws SQLException {
        if (this.freed) {
            throw TSDBError.createSQLException(8994, "Blob resources have been freed");
        }
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkIfFreed();
        if (this.readOnly) {
            throw TSDBError.createSQLException(9040, "Read-only Blob implementation");
        }
        if (pos != 1L) {
            throw TSDBError.createSQLException(8963, "Only setting binary stream from the beginning is supported");
        }
        return new TDOutputStream(524288);
    }

    static /* synthetic */ byte[] access$002(TDBlob x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }

    private class TDOutputStream
    extends ByteArrayOutputStream {
        public TDOutputStream(int size) {
            super(size);
        }

        @Override
        public void close() throws IOException {
            super.close();
            TDBlob.access$002(TDBlob.this, super.toByteArray());
        }
    }
}

