/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.common.TDBlob;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BlobUtil {
    private BlobUtil() {
    }

    public static byte[] getBytes(Blob blob) throws SQLException {
        return blob.getBytes(1L, (int)blob.length());
    }

    public static byte[] getFromInputStream(InputStream inputStream, long length) throws SQLException {
        if (inputStream == null || length < 0L) {
            throw TSDBError.createSQLException(8963, "InputStream/length invalid");
        }
        try {
            byte[] bytes = new byte[(int)length];
            int readLen = inputStream.read(bytes);
            if ((long)readLen != length) {
                throw TSDBError.createSQLException(8963, "InputStream length mismatch: expected " + length + ", got " + readLen);
            }
            return bytes;
        }
        catch (IOException e) {
            throw TSDBError.createSQLException(8963, "Failed to read InputStream: " + e.getMessage());
        }
    }

    public static byte[] getFromInputStream(InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            throw TSDBError.createSQLException(8963, "InputStream is null");
        }
        TDBlob blob = new TDBlob(new byte[0], false);
        try (InputStream in = inputStream;
             OutputStream out = blob.setBinaryStream(1L);){
            int bytesRead;
            byte[] buffer = new byte[102400];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw TSDBError.createSQLException(8963, "io error: " + e.getMessage());
        }
        return blob.getBytes(1L, (int)blob.length());
    }

    public static List<byte[]> getListBytes(List<Blob> blobList) throws SQLException {
        ArrayList<byte[]> collect = new ArrayList<byte[]>();
        for (Blob blob : blobList) {
            if (blob == null) {
                collect.add(null);
                continue;
            }
            try {
                collect.add(blob.getBytes(1L, (int)blob.length()));
            }
            catch (SQLException e) {
                throw TSDBError.createSQLException(8963, "Error processing Blob getBytes: " + e.getMessage());
            }
        }
        return collect;
    }
}

