/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.taosdata.jdbc.TSDBError;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class CompletableFutureTimeout {
    private CompletableFutureTimeout() {
    }

    public static <T> CompletableFuture<T> orTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit, String msg) {
        CompletableFuture timeoutFuture = CompletableFutureTimeout.timeoutAfter(timeout, unit, msg);
        future.whenCompleteAsync((result, throwable) -> {
            if (future.isDone() && !timeoutFuture.isDone()) {
                timeoutFuture.cancel(false);
            }
        });
        return future.applyToEither((CompletionStage)timeoutFuture, Function.identity());
    }

    private static <T> CompletableFuture<T> timeoutAfter(long timeout, TimeUnit unit, String msg) {
        CompletableFuture result = new CompletableFuture();
        ScheduledFuture<Boolean> scheduledFuture = Delayer.delayer.schedule(() -> result.completeExceptionally(TSDBError.createTimeoutException(8990, String.format("failed to complete the task:%s within the specified time : %d,%s", new Object[]{msg, timeout, unit}))), timeout, unit);
        result.handle((res, ex) -> {
            scheduledFuture.cancel(false);
            return null;
        });
        return result;
    }

    static final class Delayer {
        static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

        private Delayer() {
        }

        static ScheduledFuture<?> delay(Runnable command, long delay, TimeUnit unit) {
            return delayer.schedule(command, delay, unit);
        }

        static {
            delayer.setRemoveOnCancelPolicy(true);
        }

        static final class DaemonThreadFactory
        implements ThreadFactory {
            DaemonThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("DelayScheduler-");
                return t;
            }
        }
    }
}

