/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.taptap.sdk.TapTapSharePreference;
import com.taptap.sdk.Validate;
import com.taptap.sdk.tracker.TapTapLoginTrackerHelper;
import com.tds.common.annotation.Keep;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class AccessToken
implements Parcelable {
    public static final Parcelable.Creator<AccessToken> CREATOR = new Parcelable.Creator<AccessToken>(){

        public AccessToken createFromParcel(Parcel source) {
            return new AccessToken(source);
        }

        public AccessToken[] newArray(int size) {
            return new AccessToken[size];
        }
    };
    private static final String SP_KEY = "token_data";
    private static volatile AccessToken cacheToken;
    public String kid;
    public String access_token;
    public String token_type;
    public String mac_key;
    public String mac_algorithm;
    public Set<String> scopeSet;
    private String json = null;

    String getJson() {
        return this.json;
    }

    public AccessToken() {
    }

    public AccessToken(String kid, String access_token, String token_type, String mac_key, String mac_algorithm, String json) {
        this.json = json;
        this.kid = kid;
        this.access_token = access_token;
        this.token_type = token_type;
        this.mac_key = mac_key;
        this.mac_algorithm = mac_algorithm;
        try {
            JSONObject object = new JSONObject(json);
            this.scopeSet = AccessToken.convertScopeStringToSet(object.optString("scope"));
        }
        catch (Exception ignore) {
            this.scopeSet = new HashSet<String>();
        }
    }

    public AccessToken(String kid, String access_token, String token_type, String mac_key, String mac_algorithm, String scopeString, String json) {
        this.json = json;
        this.kid = kid;
        this.access_token = access_token;
        this.token_type = token_type;
        this.mac_key = mac_key;
        this.mac_algorithm = mac_algorithm;
        this.scopeSet = AccessToken.convertScopeStringToSet(scopeString);
    }

    public AccessToken(String json) throws JSONException {
        this.json = json;
        JSONObject object = new JSONObject(json);
        this.kid = object.optString("kid");
        this.access_token = object.optString("access_token");
        this.token_type = object.optString("token_type");
        this.mac_key = object.optString("mac_key");
        this.mac_algorithm = object.optString("mac_algorithm");
        this.scopeSet = AccessToken.convertScopeStringToSet(object.optString("scope"));
    }

    protected AccessToken(Parcel in) {
        this.kid = in.readString();
        this.access_token = in.readString();
        this.token_type = in.readString();
        this.mac_key = in.readString();
        this.mac_algorithm = in.readString();
        this.scopeSet = AccessToken.convertScopeStringToSet(in.readString());
    }

    @Deprecated
    public static AccessToken build(String kid, String access_token, String token_type, String mac_key, String mac_algorithm) {
        AccessToken token = new AccessToken();
        token.kid = kid;
        token.access_token = access_token;
        token.token_type = token_type;
        token.mac_key = mac_key;
        token.mac_algorithm = mac_algorithm;
        return token;
    }

    public static AccessToken build(String json) throws JSONException {
        AccessToken token = new AccessToken();
        JSONObject object = new JSONObject(json);
        token.kid = object.optString("kid");
        token.access_token = object.optString("access_token");
        token.token_type = object.optString("token_type");
        token.mac_key = object.optString("mac_key");
        token.mac_algorithm = object.optString("mac_algorithm");
        token.scopeSet = AccessToken.convertScopeStringToSet(object.optString("scope"));
        return token;
    }

    public String toJsonString() {
        String jsonString = "";
        JSONObject object = new JSONObject();
        try {
            object.put("kid", (Object)this.kid);
            object.put("access_token", (Object)this.access_token);
            object.put("token_type", (Object)this.token_type);
            object.put("mac_key", (Object)this.mac_key);
            object.put("mac_algorithm", (Object)this.mac_algorithm);
            object.put("scope", (Object)AccessToken.convertSetToString(this.scopeSet));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        jsonString = object.toString();
        return jsonString;
    }

    public static Set<String> convertScopeStringToSet(String scopesString) {
        HashSet<String> temp = new HashSet<String>();
        if (!TextUtils.isEmpty((CharSequence)scopesString)) {
            try {
                String[] scopesArray = scopesString.split("\\s+");
                temp = new HashSet<String>(Arrays.asList(scopesArray));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return temp;
    }

    public static String convertSetToString(Set<String> scope) {
        StringBuilder scopeString = new StringBuilder();
        if (scope != null && !scope.isEmpty()) {
            for (String s : scope) {
                scopeString.append(s).append(" ");
            }
        }
        return scopeString.toString().trim();
    }

    public static synchronized AccessToken getCurrentAccessToken() {
        Validate.sdkHasInitialized();
        if (null != cacheToken) {
            return cacheToken;
        }
        String cache = TapTapSharePreference.getInstance().getSp().getString(SP_KEY, null);
        try {
            if (!TextUtils.isEmpty((CharSequence)cache)) {
                cacheToken = new AccessToken(cache);
            }
            return cacheToken;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void setCurrentToken(AccessToken token) {
        cacheToken = token;
        if (null == token) {
            AccessToken.clear();
        } else {
            TapTapLoginTrackerHelper.authorizationToken();
            cacheToken.save();
        }
    }

    void save() {
        Validate.sdkHasInitialized();
        if (!TextUtils.isEmpty((CharSequence)this.json)) {
            TapTapSharePreference.getInstance().getSp().edit().putString(SP_KEY, this.json).apply();
        }
    }

    static void clear() {
        Validate.sdkHasInitialized();
        TapTapSharePreference.getInstance().getSp().edit().putString(SP_KEY, "").apply();
        cacheToken = null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.kid);
        dest.writeString(this.access_token);
        dest.writeString(this.token_type);
        dest.writeString(this.mac_key);
        dest.writeString(this.mac_algorithm);
        dest.writeString(AccessToken.convertSetToString(this.scopeSet));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\"kid\"=").append(this.kid).append(" ");
        builder.append("\"access_token\"=").append(this.access_token).append(" ");
        builder.append("\"token_type\"=").append(this.token_type).append(" ");
        builder.append("\"mac_key\"=").append(this.mac_key).append(" ");
        builder.append("\"mac_algorithm\"=").append(this.mac_algorithm).append(" ");
        builder.append("\"scope\"=").append(AccessToken.convertSetToString(this.scopeSet)).append(" ");
        return builder.toString();
    }
}

