/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import com.tds.common.annotation.Keep;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class AccountGlobalError
extends Throwable {
    public static final String LOGIN_ERROR_ACCESS_DENIED = "access_denied";
    public static final String LOGIN_ERROR_INVALID_GRANT = "invalid_grant";
    public static final String LOGIN_ERROR_PERMISSION_RESULT = "permission_result";
    private int code;
    private String msg;
    private String error;
    private String errorDescription;

    public AccountGlobalError() {
        this.code = -1;
        this.msg = "";
        this.error = "";
        this.errorDescription = "";
    }

    public AccountGlobalError(int code, Throwable throwable) {
        this.code = code;
        this.msg = throwable.getMessage();
        this.error = throwable.getMessage();
        this.errorDescription = throwable.getLocalizedMessage();
    }

    public AccountGlobalError(String error, Throwable throwable) {
        this.code = -1;
        this.msg = throwable.getMessage();
        this.error = error;
        this.errorDescription = throwable.getLocalizedMessage();
    }

    public AccountGlobalError(String jsonStr) {
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            this.transformFromJsonObject(jsonObject);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public AccountGlobalError(JSONObject jsonObject) {
        this.transformFromJsonObject(jsonObject);
    }

    public void transformFromJsonObject(JSONObject jsonObject) {
        this.code = jsonObject.optInt("code");
        this.msg = jsonObject.optString("msg");
        this.error = jsonObject.optString("error");
        this.errorDescription = jsonObject.optString("error_description");
    }

    public String toJsonString() {
        String jsonString = "";
        JSONObject object = new JSONObject();
        try {
            object.put("code", this.code);
            object.put("msg", (Object)this.msg);
            object.put("error", (Object)this.error);
            object.put("error_description", (Object)this.errorDescription);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        jsonString = object.toString();
        return jsonString;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String getMessage() {
        return this.msg;
    }

    public void setMessage(String msg) {
        this.msg = msg;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public static class Builder {
        private int code = -1;
        private String msg = "";
        private String error = "";
        private String errorDescription = "";

        public Builder withCode(int code) {
            this.code = code;
            return this;
        }

        public Builder withMessage(String msg) {
            this.msg = msg;
            return this;
        }

        public Builder withError(String error) {
            this.error = error;
            return this;
        }

        public Builder withErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public AccountGlobalError build() {
            AccountGlobalError globalError = new AccountGlobalError();
            globalError.code = this.code;
            globalError.msg = this.msg;
            globalError.errorDescription = this.errorDescription;
            globalError.error = this.error;
            return globalError;
        }
    }
}

