/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.app.Activity;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.AccountGlobalError;
import com.taptap.sdk.RegionType;
import com.taptap.sdk.TapLoginHelper;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.net.Api;
import com.tds.common.annotation.Keep;
import com.tds.common.isc.IscMethod;
import com.tds.common.isc.IscService;
import com.tds.common.net.TDSNetInterceptor;
import com.tds.common.reactor.Observable;
import com.tds.common.reactor.Subscriber;
import com.tds.common.reactor.rxandroid.schedulers.AndroidSchedulers;

@IscService(value="TapLogin")
@Keep
public class IscTapLoginService {
    public loginInteracpter loginInteracpter;

    @IscMethod(value="login")
    public static Observable<Intent> login(final Activity activity, final String sdkName, final String ... permission2) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Intent>(){

            public void call(final Subscriber<? super Intent> subscriber) {
                if (TextUtils.isEmpty((CharSequence)sdkName)) {
                    Log.e((String)"IscTapLoginService", (String)"sdkName must not empty");
                    return;
                }
                TapLoginHelper.addLoginResultCallbackByTag(sdkName, new TapLoginHelper.TapLoginResultCallback(){

                    @Override
                    public void onLoginSuccess(AccessToken token) {
                        if (!subscriber.isUnsubscribed()) {
                            Intent intent = new Intent();
                            intent.putExtra("token", token == null ? null : token.toJsonString());
                            subscriber.onNext((Object)intent);
                            subscriber.onCompleted();
                            TapLoginHelper.removeLoginResultCallbackByTag(sdkName);
                        }
                    }

                    @Override
                    public void onLoginCancel() {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onError(new Throwable("Login cancel"));
                            subscriber.onCompleted();
                            TapLoginHelper.removeLoginResultCallbackByTag(sdkName);
                        }
                    }

                    @Override
                    public void onLoginError(AccountGlobalError throwable) {
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onError((Throwable)throwable);
                            subscriber.onCompleted();
                            TapLoginHelper.removeLoginResultCallbackByTag(sdkName);
                        }
                    }
                });
                TapLoginHelper.startTapLoginByTag(activity, sdkName, true, permission2);
            }
        }).subscribeOn(AndroidSchedulers.mainThread());
    }

    @IscMethod(value="currentAccessToken")
    public static String getCurrentAccessToken() {
        if (TapLoginHelper.getCurrentAccessToken() != null) {
            return TapLoginHelper.getCurrentAccessToken().toJsonString();
        }
        return null;
    }

    @IscMethod(value="currentProfile")
    public static String getCurrentProfile() {
        if (TapLoginHelper.getCurrentProfile() != null) {
            return TapLoginHelper.getCurrentProfile().toJsonString();
        }
        return null;
    }

    @IscMethod(value="getTestQualification")
    public static Observable<Boolean> getTestQualificationAsync() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

            public void call(final Subscriber<? super Boolean> subscriber) {
                TapLoginHelper.getTestQualification(new Api.ApiCallback<Boolean>(){

                    @Override
                    public void onSuccess(Boolean data) {
                        subscriber.onNext((Object)data);
                        subscriber.onCompleted();
                    }

                    @Override
                    public void onError(Throwable error) {
                        subscriber.onError(error);
                    }
                });
            }
        });
    }

    @IscMethod(value="setCurrentAccessToken")
    public static void setCurrentAccessToken(String tokenJson) {
        if (!TextUtils.isEmpty((CharSequence)tokenJson)) {
            try {
                AccessToken token = new AccessToken(tokenJson);
                AccessToken.setCurrentToken(token);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @IscMethod(value="handleLoginError")
    public static void handleLoginError(String jsonString) {
        IscTapLoginService.checkLoginError(jsonString, "access_denied");
    }

    public static void addSDKLoginCallback(String sdkName, TapLoginHelper.TapLoginResultCallback callback) {
        TapLoginHelper.addLoginResultCallbackByTag(sdkName, callback);
    }

    public static void removeSDKLoginCallback(String sdkName) {
        TapLoginHelper.removeLoginResultCallbackByTag(sdkName);
    }

    public static void startSDKLogin(Activity activity, String sdkName, String ... permission2) {
        TapLoginHelper.startTapLoginByTag(activity, sdkName, true, permission2);
    }

    public static void checkLoginError(String jsonString, String ... errorList) {
        if (TapLoginHelper.getCurrentAccessToken() == null) {
            return;
        }
        TDSNetInterceptor.checkAuthError((String)jsonString, (TDSNetInterceptor.CheckAuthCallback)new TDSNetInterceptor.CheckAuthCallback(){

            public void onAuthError(String dataJson) {
                TapLoginHelper.logout();
                if (TapLoginHelper.getLoginCallback() != null) {
                    TapLoginHelper.getLoginCallback().onLoginError(new AccountGlobalError(dataJson));
                }
            }
        }, (String[])errorList);
    }

    public static void changeConfig(String clientId, RegionType region, AccessToken token) {
        TapLoginInnerConfig.setClientId(clientId);
        TapLoginInnerConfig.setRegionType(region);
        if (token != null) {
            AccessToken.setCurrentToken(token);
        }
    }

    public static interface loginInteracpter {
        public void userChanged(String var1);
    }
}

