/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.CallBackManager;
import com.taptap.sdk.CallbackManagerImpl;
import com.taptap.sdk.Log;
import com.taptap.sdk.LoginRequest;
import com.taptap.sdk.LoginResponse;
import com.taptap.sdk.Profile;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.TapLoginWithCode;
import com.taptap.sdk.TapTapLoginCallback;
import com.taptap.sdk.Validate;
import com.taptap.sdk.net.Api;
import com.taptap.sdk.ui.TapTapActivity;
import org.json.JSONException;

public class LoginManager {
    public static final String KEY_RESPONSE = "com.taptap.sdk.response";
    public static final String RES_KEY_CANCEL = "com.taptap.sdk.response.cancel";
    public static final String RES_KEY_ERROR = "com.taptap.sdk.response.error";
    public static final String RES_KEY_TOKEN = "com.taptap.sdk.response.token";
    public static final String RES_KEY_CODE = "com.taptap.sdk.response.code";
    public static final String RES_KEY_CODE_VERIFIER = "com.taptap.sdk.response.codeVerifier";
    public static final String RES_KEY_LOGIN_VERSION = "com.taptap.sdk.response.login_version";
    public static final String RES_KEY_TOKEN_PARCELABLE = "com.taptap.sdk.response.token.parcel";
    public static final String RES_KEY_STATE = "com.taptap.sdk.response.state";
    public static final String RES_KEY_PERMISSIONS = "com.taptap.sdk.response.permissions";
    public static final String RES_KEY_SERVER_URI = "com.taptap.sdk.response.server_uri";
    private boolean preApproved = false;
    private static LoginManager instance;
    private LoginRequest mLastLoginRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoginManager getInstance() {
        if (null != instance) return instance;
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            if (null != instance) return instance;
            instance = new LoginManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LoginManager() {
    }

    public void registerCallback(CallBackManager callbackManager, final TapTapLoginCallback<LoginResponse> callback) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new IllegalStateException("callbackManager must be instance of  CallbackManagerImpl");
        }
        ((CallbackManagerImpl)callbackManager).registerCallback(new CallbackManagerImpl.Callback(){

            @Override
            public boolean onActivityResult(int responseCode, Intent data) {
                return LoginManager.this.onActivityResult(responseCode, data, callback);
            }
        }, 10);
    }

    public void logInWithReadPermissions(Activity activity, LoginRequest request, String source, String ... permissions) {
        Validate.sdkHasInitialized();
        request.setPreApproved(this.preApproved);
        this.mLastLoginRequest = request;
        request.setVersionCode("3.28.3");
        request.setInfo(LoginRequest.generateInfo(activity, source, this.preApproved));
        Intent intent = new Intent();
        intent.setClass((Context)activity, TapTapActivity.class);
        intent.putExtra("request", (Parcelable)request);
        activity.startActivityForResult(intent, request.getRequestCode());
    }

    public void logout() {
        Validate.sdkHasInitialized();
        if (AccessToken.getCurrentAccessToken() != null) {
            AccessToken.clear();
        }
        if (null != Profile.getCurrentProfile()) {
            Profile.getCurrentProfile().clear();
        }
    }

    public void setPreApproved(boolean preApproved) {
        this.preApproved = preApproved;
    }

    private boolean onActivityResult(int resultCode, Intent data, final TapTapLoginCallback<LoginResponse> callback) {
        if (resultCode == -1) {
            final boolean isLogin = data == null || data.getBooleanExtra("loginRequest", true);
            LoginResponse result = null;
            try {
                result = LoginResponse.getResultFromIntent(data);
            }
            catch (JSONException e) {
                callback.onError(e);
            }
            try {
                if (result == null) {
                    callback.onError(new NullPointerException("result is null"));
                    return false;
                }
                if (result.cancel) {
                    callback.onCancel();
                    return false;
                }
                if (result.state == null || !result.state.equals(this.mLastLoginRequest.getState())) {
                    callback.onError(new IllegalStateException("state not equal"));
                    return false;
                }
                if (!TextUtils.isEmpty((CharSequence)result.errorMessage)) {
                    if (TextUtils.equals((CharSequence)result.errorMessage, (CharSequence)"access_denied")) {
                        callback.onCancel();
                    } else {
                        callback.onError(new IllegalArgumentException(result.errorMessage));
                    }
                } else if (result.token == null && result.code == null) {
                    callback.onError(new IllegalAccessException("token is null"));
                } else if ("1".equals(result.loginVersion)) {
                    TapLoginWithCode.loginWithCode(result.code, TapLoginInnerConfig.codeVerifier, result.state, result.getName(), new TapLoginWithCode.LoginResultCallBack(){

                        @Override
                        public void onLoginResult(LoginResponse response) {
                            if (!TextUtils.isEmpty((CharSequence)response.errorMessage)) {
                                if (TextUtils.equals((CharSequence)response.errorMessage, (CharSequence)"access_denied")) {
                                    callback.onCancel();
                                } else {
                                    callback.onError(new IllegalArgumentException(response.errorMessage));
                                }
                            } else if (isLogin) {
                                LoginManager.this.loginWithToken(response, callback);
                            } else {
                                callback.onSuccess(response);
                            }
                        }
                    });
                } else if (isLogin) {
                    this.loginWithToken(result, callback);
                } else {
                    callback.onSuccess(result);
                }
                return true;
            }
            catch (Exception e) {
                callback.onError(e);
                return false;
            }
        }
        if (resultCode == 0) {
            callback.onCancel();
        }
        return true;
    }

    private void loginWithToken(LoginResponse result, final TapTapLoginCallback<LoginResponse> callback) {
        AccessToken.setCurrentToken(result.token);
        final LoginResponse loginResponse = result;
        Profile.fetchProfileForCurrentAccessToken(new Api.ApiCallback<Profile>(){

            @Override
            public void onSuccess(Profile data) {
                if (AccessToken.getCurrentAccessToken() == null) {
                    callback.onCancel();
                } else {
                    callback.onSuccess(loginResponse);
                }
            }

            @Override
            public void onError(Throwable error) {
                Log.DEBUG_LOG("fetch profile fail error = " + (error == null ? "unknown" : error.getMessage()));
                AccessToken.clear();
                callback.onError(error);
            }
        });
    }
}

