/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.app.Activity;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.taptap.sdk.TapTapSdk;
import com.tds.common.annotation.Keep;
import com.tds.common.utils.GUIDHelper;
import java.util.UUID;

@Keep
public class LoginRequest
implements Parcelable {
    private String state;
    private String[] permissions;
    private int requestCode = -1;
    private String versionCode;
    private String info;
    private String loginVersion = "0";
    private String responseType = "code";
    private String redirectUri;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String phoneVerifyToken;
    private String preferredLoginType;
    private boolean preApproved = false;
    public static final Parcelable.Creator<LoginRequest> CREATOR = new Parcelable.Creator<LoginRequest>(){

        public LoginRequest createFromParcel(Parcel source) {
            return new LoginRequest(source);
        }

        public LoginRequest[] newArray(int size) {
            return new LoginRequest[size];
        }
    };

    public String getState() {
        return this.state;
    }

    public String getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(String versionCode) {
        this.versionCode = versionCode;
    }

    public int getRequestCode() {
        if (this.requestCode == -1) {
            this.requestCode = 10;
        }
        return this.requestCode;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getLoginVersion() {
        return this.loginVersion;
    }

    public void setLoginVersion(String loginVersion) {
        this.loginVersion = loginVersion;
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String ... permissions) {
        this.permissions = permissions;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getPhoneVerifyToken() {
        return this.phoneVerifyToken;
    }

    public void setPhoneVerifyToken(String phoneVerifyToken) {
        this.phoneVerifyToken = phoneVerifyToken;
    }

    public String getPreferredLoginType() {
        return this.preferredLoginType;
    }

    public void setPreferredLoginType(String preferredLoginType) {
        this.preferredLoginType = preferredLoginType;
    }

    public boolean isPreApproved() {
        return this.preApproved;
    }

    public void setPreApproved(boolean preApproved) {
        this.preApproved = preApproved;
    }

    public LoginRequest(String ... permissions) {
        this.permissions = permissions;
        this.state = UUID.randomUUID().toString();
    }

    public LoginRequest(String state, String ... permissions) {
        this.permissions = permissions;
        this.state = state;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.state);
        dest.writeStringArray(this.permissions);
        dest.writeInt(this.requestCode);
        dest.writeString(this.versionCode);
        dest.writeString(this.info);
        dest.writeString(this.loginVersion);
        dest.writeString(this.responseType);
        dest.writeString(this.redirectUri);
        dest.writeString(this.codeChallenge);
        dest.writeString(this.codeChallengeMethod);
        dest.writeString(this.phoneVerifyToken);
        dest.writeString(this.preferredLoginType);
        dest.writeInt(this.preApproved ? 1 : 0);
    }

    protected LoginRequest(Parcel in) {
        this.state = in.readString();
        this.permissions = in.createStringArray();
        this.requestCode = in.readInt();
        this.versionCode = in.readString();
        this.info = in.readString();
        this.loginVersion = in.readString();
        this.responseType = in.readString();
        this.redirectUri = in.readString();
        this.codeChallenge = in.readString();
        this.codeChallengeMethod = in.readString();
        this.phoneVerifyToken = in.readString();
        this.preferredLoginType = in.readString();
        this.preApproved = in.readInt() == 1;
    }

    public static String generateInfo(Activity activity, String source, boolean preApproved) {
        String orientation = "horizontal";
        try {
            if (activity.getResources().getConfiguration().orientation == 1) {
                orientation = "vertical";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (TextUtils.equals((CharSequence)source, (CharSequence)"GAME")) {
            return "client_id=" + TapTapSdk.getClientId() + "&uuid=" + GUIDHelper.INSTANCE.getUID() + "&name=TapLoginAndroid&orientation=" + orientation + "&version=" + "3.28.3" + "&preapproved=" + (preApproved ? 1 : 0);
        }
        return "biz_source=" + source + "&client_id=" + TapTapSdk.getClientId() + "&uuid=" + GUIDHelper.INSTANCE.getUID() + "&name=TapLoginAndroid&orientation=" + orientation + "&version=" + "3.28.3" + "&preapproved=" + (preApproved ? 1 : 0);
    }

    public static String generateSDKInfo(Activity activity, boolean preApproved) {
        String orientation = "horizontal";
        try {
            if (activity.getResources().getConfiguration().orientation == 1) {
                orientation = "vertical";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "client_id=" + TapTapSdk.getClientId() + "&uuid=" + GUIDHelper.INSTANCE.getUID() + "&name=TapSDK&orientation=" + orientation + "&version=" + "3.28.3" + "&version_code=" + 32803001 + "&preapproved=" + (preApproved ? 1 : 0);
    }
}

