/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.taptap.sdk.AccessToken;
import com.tds.common.annotation.Keep;
import java.util.Arrays;
import org.json.JSONException;

@Keep
public class LoginResponse {
    public String[] permissions;
    public String state;
    public String errorMessage;
    public AccessToken token;
    public boolean cancel;
    public String code;
    public String loginVersion;
    private String name;

    public LoginResponse(String[] permissions, String state, String errorMessage, AccessToken token, boolean cancel) {
        this.permissions = permissions;
        this.state = state;
        this.errorMessage = errorMessage;
        this.token = token;
        this.cancel = cancel;
    }

    public LoginResponse(String[] permissions, String state, String errorMessage, AccessToken token, boolean cancel, String name) {
        this(permissions, state, errorMessage, token, cancel);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Intent toIntent(String serverUri) {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        intent.putExtra("com.taptap.sdk.response", bundle);
        bundle.putBoolean("com.taptap.sdk.response.cancel", this.cancel);
        bundle.putString("com.taptap.sdk.response.token", this.token == null ? null : this.token.getJson());
        bundle.putParcelable("com.taptap.sdk.response.token.parcel", (Parcelable)this.token);
        bundle.putString("com.taptap.sdk.response.error", this.errorMessage);
        bundle.putString("com.taptap.sdk.response.state", this.state);
        bundle.putString("com.taptap.sdk.response.code", this.code);
        if (this.loginVersion != null) {
            bundle.putString("com.taptap.sdk.response.login_version", this.loginVersion);
        }
        if (!TextUtils.isEmpty((CharSequence)serverUri)) {
            bundle.putString("com.taptap.sdk.response.server_uri", serverUri);
        }
        bundle.putStringArray("com.taptap.sdk.response.permissions", this.permissions);
        return intent;
    }

    private LoginResponse() {
    }

    public static LoginResponse getResultFromIntent(Intent intent) throws JSONException {
        LoginResponse result = new LoginResponse();
        Bundle data = intent.getBundleExtra("com.taptap.sdk.response");
        result.cancel = data.getBoolean("com.taptap.sdk.response.cancel", false);
        String tokenJson = data.getString("com.taptap.sdk.response.token");
        result.token = !TextUtils.isEmpty((CharSequence)tokenJson) ? new AccessToken(tokenJson) : (AccessToken)data.getParcelable("com.taptap.sdk.response.token.parcel");
        result.errorMessage = data.getString("com.taptap.sdk.response.error");
        result.state = data.getString("com.taptap.sdk.response.state");
        result.permissions = data.getStringArray("com.taptap.sdk.response.permissions");
        result.code = data.getString("com.taptap.sdk.response.code");
        result.loginVersion = data.getString("com.taptap.sdk.response.login_version", "0");
        String uri = data.getString("com.taptap.sdk.response.server_uri");
        result.name = LoginResponse.getNameFromServerUri(uri);
        return result;
    }

    private static String getNameFromServerUri(String serverUri) {
        if (!TextUtils.isEmpty((CharSequence)serverUri)) {
            try {
                Uri rawUri = Uri.parse((String)serverUri);
                if (rawUri != null) {
                    return rawUri.getQueryParameter("name");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (null != this.permissions) {
            builder.append("\"permissions\"=").append(Arrays.toString(this.permissions)).append(" ");
        }
        builder.append("\"state\"=").append(this.state).append(" ");
        builder.append("\"errorMessage\"=").append(this.errorMessage).append(" ");
        builder.append("\"token\"=").append(this.token).append(" ");
        builder.append("\"cancel\"=").append(this.cancel).append(" ");
        builder.append("\"code\"=").append(this.code).append(" ");
        builder.append("\"name\"=").append(this.name).append(" ");
        return builder.toString();
    }
}

