/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.Log;
import com.taptap.sdk.LoginManager;
import com.taptap.sdk.TapTapSdk;
import com.taptap.sdk.TapTapSharePreference;
import com.taptap.sdk.exceptions.ServerError;
import com.taptap.sdk.net.Api;
import com.taptap.sdk.tracker.TapTapLoginTrackerHelper;
import com.tds.common.annotation.Keep;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class Profile
implements Parcelable {
    protected static volatile Profile profile;
    private static final String KEY_PROFILE = "profile";
    private String name;
    private String avatar;
    private String openid;
    private String unionid;
    private String email;
    private boolean emailVerified;
    protected int isCertified = -1;
    public static final Parcelable.Creator<Profile> CREATOR;

    private Profile() {
    }

    public static synchronized Profile getCurrentProfile() {
        if (null != profile) {
            return profile;
        }
        String string2 = TapTapSharePreference.getInstance().getSp().getString(KEY_PROFILE, "");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                profile = Profile.fromJson(new JSONObject(string2));
                return profile;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected static void save(JSONObject result) {
        TapTapSharePreference.getInstance().getSp().edit().putString(KEY_PROFILE, result.toString()).apply();
    }

    public static Profile fromJson(JSONObject object) {
        Profile profile = new Profile();
        profile.avatar = object.optString("avatar");
        profile.name = object.optString("name");
        profile.openid = object.optString("openid");
        profile.unionid = object.optString("unionid");
        profile.email = object.optString("email");
        profile.emailVerified = object.optBoolean("email_verified", false);
        if (object.has("is_certified")) {
            profile.isCertified = object.optBoolean("is_certified") ? 1 : 0;
        }
        return profile;
    }

    public String toJsonString() {
        String jsonString = "";
        JSONObject object = new JSONObject();
        try {
            object.put("name", (Object)this.name);
            object.put("avatar", (Object)this.avatar);
            object.put("openid", (Object)this.openid);
            object.put("unionid", (Object)this.unionid);
            object.put("email", (Object)this.email);
            object.put("email_verified", this.emailVerified);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        jsonString = object.toString();
        return jsonString;
    }

    public static void fetchProfileForCurrentAccessToken(final Api.ApiCallback<Profile> callback) {
        if (AccessToken.getCurrentAccessToken() != null) {
            TapTapLoginTrackerHelper.authorizationProfile();
            String url = "";
            url = AccessToken.getCurrentAccessToken().scopeSet != null && AccessToken.getCurrentAccessToken().scopeSet.contains("public_profile") ? TapTapSdk.regionType().profileUrl() : TapTapSdk.regionType().basicInfoUrl();
            Api.get(String.format(url, TapTapSdk.getClientId()), null, new Api.ApiCallback<JSONObject>(){

                @Override
                public void onSuccess(JSONObject jsonObject) {
                    if (null != jsonObject && jsonObject.optBoolean("success")) {
                        Profile profile;
                        JSONObject result = jsonObject.optJSONObject("data");
                        Profile.profile = profile = Profile.fromJson(result);
                        Profile.save(result);
                        if (null != callback) {
                            callback.onSuccess(profile);
                        }
                    }
                }

                @Override
                public void onError(Throwable error) {
                    if (error instanceof ServerError && !TextUtils.isEmpty((CharSequence)error.getMessage()) && error.getMessage().contains("access_denied")) {
                        LoginManager.getInstance().logout();
                    }
                    if (null != callback) {
                        callback.onError(error);
                    }
                }
            });
        } else {
            if (callback != null) {
                callback.onError(new RuntimeException("Login first"));
            }
            Log.DEBUG_LOG("Need login first!!");
        }
    }

    public void clear() {
        TapTapSharePreference.getInstance().getSp().edit().putString(KEY_PROFILE, "").apply();
        profile = null;
    }

    public String toString() {
        return "\"name\":" + this.name + " \"avatar\":" + this.avatar + " \"openid\":" + this.openid + " \"unionid\":" + this.unionid + " \"email\":" + this.email + " \"email_verified\":" + this.emailVerified;
    }

    public String getName() {
        return this.name;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getOpenid() {
        return this.openid;
    }

    public String getUnionid() {
        return this.unionid;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.avatar);
        dest.writeString(this.openid);
        dest.writeString(this.unionid);
        dest.writeInt(this.isCertified);
        dest.writeString(this.email);
        dest.writeInt(this.emailVerified ? 1 : 0);
    }

    protected Profile(Parcel in) {
        this.name = in.readString();
        this.avatar = in.readString();
        this.openid = in.readString();
        this.unionid = in.readString();
        this.isCertified = in.readInt();
        this.email = in.readString();
        this.emailVerified = in.readInt() != 0;
    }

    static {
        CREATOR = new Parcelable.Creator<Profile>(){

            public Profile createFromParcel(Parcel source) {
                return new Profile(source);
            }

            public Profile[] newArray(int size) {
                return new Profile[size];
            }
        };
    }
}

