/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.AccountGlobalError;
import com.taptap.sdk.LoginManager;
import com.taptap.sdk.LoginResponse;
import com.taptap.sdk.LoginSdkConfig;
import com.taptap.sdk.Profile;
import com.taptap.sdk.R;
import com.taptap.sdk.RegionType;
import com.taptap.sdk.TapLoginHelperActivity;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.TapTapSdk;
import com.taptap.sdk.TestQualificationModel;
import com.taptap.sdk.net.Api;
import com.tds.common.TapCommon;
import com.tds.common.account.LoginStatusManager;
import com.tds.common.account.TdsAccount;
import com.tds.common.annotation.Keep;
import com.tds.common.entities.TapConfig;
import com.tds.common.utils.GUIDHelper;
import com.tds.common.utils.UIUtils;
import com.tds.common.widgets.toast.TapToast;
import com.tds.common.widgets.toast.TapToastManager;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Keep
public class TapLoginHelper {
    public static final String SCOPE_BASIC_INFO = "basic_info";
    public static final String SCOPE_PUBLIC_PROFILE = "public_profile";
    public static final String SCOPE_EMAIL = "email";
    public static final String SCOPE_USER_FRIENDS = "user_friends";
    private HashMap<String, TapLoginResultCallback> loginResultCallbackList;
    public static final String TAG_GAME = "GAME";
    private TestQualificationModel testQualificationModel = new TestQualificationModel();
    private WeakReference<Activity> currentLoginActivity;
    private static List<String> appendPermissions;

    private TapLoginHelper() {
        this.loginResultCallbackList = new HashMap();
    }

    static TapLoginHelper getInstance() {
        return Holder.INSTANCE;
    }

    public static void init(Context context, String clientID) {
        TapTapSdk.sdkInitialize(context, clientID);
        TapLoginHelper.initTapCommon(context, clientID);
    }

    public static void init(Context context, String clientID, LoginSdkConfig config) {
        TapTapSdk.sdkInitialize(context, clientID, config);
        TapLoginHelper.initTapCommon(context, clientID);
    }

    private static void initTapCommon(Context context, String clientID) {
        if (context == null || TextUtils.isEmpty((CharSequence)clientID)) {
            return;
        }
        if (TapCommon.getTapConfig() == null) {
            TapConfig tapConfig = new TapConfig.Builder().withAppContext(context.getApplicationContext()).withClientId(clientID).build();
            TapCommon.init((TapConfig)tapConfig);
        }
        if (!GUIDHelper.INSTANCE.initialized()) {
            GUIDHelper.INSTANCE.init(context);
        }
        if (TapLoginHelper.getCurrentProfile() != null) {
            TapLoginHelper.notifyLoginStatusListener(true);
        }
    }

    public static void changeTapLoginConfig(LoginSdkConfig config) {
        TapTapSdk.changeTapLoginConfig(config);
    }

    public static void startTapLogin(Activity activity, String ... permissions) {
        TapLoginHelper.startTapLoginByTag(activity, TAG_GAME, true, permissions);
    }

    public static void startAuthorize(Activity activity, String ... permissions) {
        TapLoginHelper.startTapLoginByTag(activity, TAG_GAME, false, permissions);
    }

    public static void logout() {
        LoginManager.getInstance().logout();
        TapToast.getInstance().setIconUrl(null);
        TapLoginHelper.notifyLoginStatusListener(false);
    }

    public static void appendPermission(String permission2) {
        if (TextUtils.isEmpty((CharSequence)permission2)) {
            return;
        }
        if (appendPermissions == null) {
            appendPermissions = new ArrayList<String>();
        }
        if (!appendPermissions.contains(permission2)) {
            appendPermissions.add(permission2);
        }
    }

    private static void notifyLoginStatusListener(boolean isLogin) {
        if (!isLogin) {
            LoginStatusManager.notifyLogout((TdsAccount.AccountType)TdsAccount.AccountType.TAP);
        } else if (TapLoginHelper.getCurrentProfile() != null) {
            LoginStatusManager.notifyLoginSuccess((TdsAccount.AccountType)TdsAccount.AccountType.TAP, (String)TapLoginHelper.getCurrentProfile().getOpenid());
        } else {
            TapLoginHelper.fetchProfileForCurrentAccessToken(new Api.ApiCallback<Profile>(){

                @Override
                public void onSuccess(Profile data) {
                    LoginStatusManager.notifyLoginSuccess((TdsAccount.AccountType)TdsAccount.AccountType.TAP, (String)data.getOpenid());
                }

                @Override
                public void onError(Throwable error) {
                }
            });
        }
    }

    public static AccessToken getCurrentAccessToken() {
        return AccessToken.getCurrentAccessToken();
    }

    public static Profile getCurrentProfile() {
        return Profile.getCurrentProfile();
    }

    public static void fetchProfileForCurrentAccessToken(Api.ApiCallback<Profile> callback) {
        Profile.fetchProfileForCurrentAccessToken(callback);
    }

    public static void getTestQualification(Api.ApiCallback<Boolean> callback) {
        TapLoginHelper.getInstance().testQualificationModel.getTestQualificationAsync(callback);
    }

    public static void registerLoginCallback(TapLoginResultCallback loginResultCallback) {
        TapLoginHelper.addLoginResultCallbackByTag(TAG_GAME, loginResultCallback);
    }

    public static TapLoginResultCallback getLoginCallback() {
        return TapLoginHelper.getLoginResultCallbackByTag(TAG_GAME);
    }

    public static void unregisterLoginCallback() {
        TapLoginHelper.removeLoginResultCallbackByTag(TAG_GAME);
    }

    static void startTapLoginByTag(Activity activity, String sdkName, boolean isLoginRequest, String ... permissions) {
        if (TapLoginHelper.getInstance().loginResultCallbackList == null || TapLoginHelper.getInstance().loginResultCallbackList.size() == 0) {
            Log.e((String)"TapLoginHelper", (String)"loginResultCallbackList has no valid item");
        }
        ArrayList<String> permissionList = new ArrayList<String>(Arrays.asList(permissions));
        if (isLoginRequest) {
            boolean containPublicProfile = permissionList.contains(SCOPE_PUBLIC_PROFILE);
            boolean containBasicInfo = permissionList.contains(SCOPE_BASIC_INFO);
            if (containBasicInfo && containPublicProfile) {
                permissionList.remove(SCOPE_BASIC_INFO);
            } else if (!containBasicInfo && !containPublicProfile) {
                permissionList.add(SCOPE_PUBLIC_PROFILE);
            }
        }
        if (isLoginRequest && appendPermissions != null && appendPermissions.size() > 0) {
            if (TapLoginInnerConfig.getRegionType() != RegionType.CN) {
                appendPermissions.remove("compliance");
            }
            for (String permission2 : appendPermissions) {
                if (permissionList.contains(permission2)) continue;
                permissionList.add(permission2);
            }
        }
        String[] permissionArray = new String[permissionList.size()];
        for (int i = 0; i < permissionList.size(); ++i) {
            permissionArray[i] = (String)permissionList.get(i);
        }
        Intent loginIntent = new Intent((Context)activity, TapLoginHelperActivity.class);
        loginIntent.putExtra("permission", permissionArray);
        loginIntent.putExtra("source", sdkName);
        loginIntent.putExtra("loginRequest", isLoginRequest);
        activity.startActivity(loginIntent);
        if (isLoginRequest) {
            TapLoginHelper.getInstance().currentLoginActivity = new WeakReference<Activity>(activity);
        }
    }

    static void addLoginResultCallbackByTag(String tag, TapLoginResultCallback loginResultCallback) {
        if (TapLoginHelper.getInstance().loginResultCallbackList == null) {
            TapLoginHelper.getInstance().loginResultCallbackList = new HashMap();
        }
        TapLoginHelper.getInstance().loginResultCallbackList.put(tag, loginResultCallback);
        TapLoginHelper.deleteNullCallback(TapLoginHelper.getInstance().loginResultCallbackList);
    }

    static TapLoginResultCallback getLoginResultCallbackByTag(String tag) {
        if (TapLoginHelper.getInstance().loginResultCallbackList != null) {
            return TapLoginHelper.getInstance().loginResultCallbackList.get(tag);
        }
        return null;
    }

    static void removeLoginResultCallbackByTag(String tag) {
        if (TapLoginHelper.getInstance().loginResultCallbackList == null) {
            TapLoginHelper.getInstance().loginResultCallbackList = new HashMap();
        }
        TapLoginHelper.getInstance().loginResultCallbackList.remove(tag);
        TapLoginHelper.deleteNullCallback(TapLoginHelper.getInstance().loginResultCallbackList);
    }

    void onLoginSuccess(LoginResponse response) {
        TapLoginHelper.notifyLoginStatusListener(true);
        if (this.loginResultCallbackList != null && this.loginResultCallbackList.size() > 0) {
            TapLoginHelper.deleteNullCallback(this.loginResultCallbackList);
            for (TapLoginResultCallback callback : this.loginResultCallbackList.values()) {
                if (callback == null) continue;
                callback.onLoginSuccess(response.token);
            }
        }
        if (this.currentLoginActivity != null && this.currentLoginActivity.get() != null) {
            String nickname;
            Activity tipActivity = (Activity)this.currentLoginActivity.get();
            if (response != null && !TextUtils.isEmpty((CharSequence)(nickname = response.getName()))) {
                String loginTip = String.format(UIUtils.getLocalizedString((Context)tipActivity, (int)R.string.login_account_logged_tip), nickname);
                TapToastManager.instance().showWithTapIcon(tipActivity, loginTip);
            }
        }
        this.currentLoginActivity = null;
    }

    void onLoginCancel() {
        this.currentLoginActivity = null;
        if (this.loginResultCallbackList != null && this.loginResultCallbackList.size() > 0) {
            TapLoginHelper.deleteNullCallback(this.loginResultCallbackList);
            for (TapLoginResultCallback callback : this.loginResultCallbackList.values()) {
                if (callback == null) continue;
                callback.onLoginCancel();
            }
        }
    }

    void onLoginError(Throwable throwable) {
        this.currentLoginActivity = null;
        if (this.loginResultCallbackList != null && this.loginResultCallbackList.size() > 0) {
            TapLoginHelper.deleteNullCallback(this.loginResultCallbackList);
            for (TapLoginResultCallback callback : this.loginResultCallbackList.values()) {
                if (callback == null) continue;
                callback.onLoginError(new AccountGlobalError("permission_result", throwable));
            }
        }
    }

    static void deleteNullCallback(HashMap<String, TapLoginResultCallback> weakList) {
        if (weakList != null) {
            Iterator<Map.Entry<String, TapLoginResultCallback>> iterator = TapLoginHelper.getInstance().loginResultCallbackList.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, TapLoginResultCallback> entry = iterator.next();
                if (entry.getValue() != null) continue;
                iterator.remove();
            }
        }
    }

    @Keep
    public static interface TapLoginResultCallback {
        public void onLoginSuccess(AccessToken var1);

        public void onLoginCancel();

        public void onLoginError(AccountGlobalError var1);
    }

    private static class Holder {
        private static final TapLoginHelper INSTANCE = new TapLoginHelper();

        private Holder() {
        }
    }
}

