/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.taptap.sdk.CallBackManager;
import com.taptap.sdk.LoginManager;
import com.taptap.sdk.LoginRequest;
import com.taptap.sdk.LoginResponse;
import com.taptap.sdk.TapLoginHelper;
import com.taptap.sdk.TapTapLoginCallback;
import com.taptap.sdk.Utils;
import java.util.UUID;
import tds.androidx.core.view.WindowCompat;
import tds.androidx.core.view.WindowInsetsCompat;
import tds.androidx.core.view.WindowInsetsControllerCompat;

public class TapLoginHelperActivity
extends Activity {
    public static final String INTENT_KEY_PERMISSION = "permission";
    public static final String INTENT_KEY_SOURCE = "source";
    public static final String INTENT_KEY_LOGIN_REQUEST = "loginRequest";
    private static final String LOGIN_REQUEST_STATE_KEY = "login_request_state";
    private boolean isLoginRequest = true;
    private String lastLoginRequestState;
    CallBackManager callBackManager;
    private Handler sendMessageHandler;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!Utils.isLoginSDKInitialized()) {
            this.finish();
            return;
        }
        Log.d((String)"TapLoginResult", (String)"TapLoginHelper create");
        if (savedInstanceState != null) {
            this.lastLoginRequestState = savedInstanceState.getString(LOGIN_REQUEST_STATE_KEY);
        }
        this.callBackManager = CallBackManager.Factory.create();
        LoginManager.getInstance().registerCallback(this.callBackManager, new TapTapLoginCallback<LoginResponse>(){

            @Override
            public void onSuccess(LoginResponse loginResult) {
                TapLoginHelper.getInstance().onLoginSuccess(loginResult);
                TapLoginHelperActivity.this.finish();
            }

            @Override
            public void onCancel() {
                TapLoginHelper.getInstance().onLoginCancel();
                TapLoginHelperActivity.this.finish();
            }

            @Override
            public void onError(Throwable throwable) {
                TapLoginHelper.getInstance().onLoginError(throwable);
                TapLoginHelperActivity.this.finish();
            }
        });
        final String[] permissions = this.getIntent().getStringArrayExtra(INTENT_KEY_PERMISSION);
        final String source = this.getIntent().getStringExtra(INTENT_KEY_SOURCE);
        this.isLoginRequest = this.getIntent().getBooleanExtra(INTENT_KEY_LOGIN_REQUEST, true);
        boolean isRecreate = false;
        if (TextUtils.isEmpty((CharSequence)this.lastLoginRequestState)) {
            this.lastLoginRequestState = UUID.randomUUID().toString();
        } else {
            isRecreate = true;
        }
        if (isRecreate) {
            Log.d((String)"TapLoginResult", (String)"TapLoginHelp recreate");
            this.sendMessageHandler = new Handler();
            this.sendMessageHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)"TapLoginResult", (String)"TapLoginHelp recreate start launch");
                    LoginRequest request = new LoginRequest(TapLoginHelperActivity.this.lastLoginRequestState, permissions);
                    LoginManager.getInstance().logInWithReadPermissions(TapLoginHelperActivity.this, request, source, permissions);
                }
            }, 300L);
        } else {
            LoginRequest request = new LoginRequest(this.lastLoginRequestState, permissions);
            LoginManager.getInstance().logInWithReadPermissions(this, request, source, permissions);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (!TextUtils.isEmpty((CharSequence)this.lastLoginRequestState)) {
            outState.putString(LOGIN_REQUEST_STATE_KEY, this.lastLoginRequestState);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.d((String)"TapLoginResult", (String)("onActivityResult resultCode = " + resultCode));
        if (data != null) {
            data.putExtra(INTENT_KEY_LOGIN_REQUEST, this.isLoginRequest);
        }
        this.callBackManager.onActivityResult(requestCode, resultCode, data);
    }

    protected void onStart() {
        super.onStart();
        this.setupWindowStyle();
    }

    protected void setupWindowStyle() {
        WindowInsetsControllerCompat windowInsetsControllerCompat;
        WindowManager.LayoutParams attributes;
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 28 && (attributes = window.getAttributes()) != null) {
            attributes.layoutInDisplayCutoutMode = 1;
            window.setAttributes(attributes);
        }
        window.setStatusBarColor(0);
        WindowCompat.setDecorFitsSystemWindows((Window)window, (boolean)false);
        View decorView = window.getDecorView();
        if (decorView != null && (windowInsetsControllerCompat = WindowCompat.getInsetsController((Window)window, (View)decorView)) != null) {
            windowInsetsControllerCompat.hide(WindowInsetsCompat.Type.navigationBars());
            windowInsetsControllerCompat.setAppearanceLightStatusBars(true);
            windowInsetsControllerCompat.setSystemBarsBehavior(1);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.sendMessageHandler != null) {
            this.sendMessageHandler.removeCallbacksAndMessages(null);
            this.sendMessageHandler = null;
        }
    }
}

