/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.os.Build;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.LoginResponse;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.net.Api;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class TapLoginWithCode {
    public static void loginWithCode(String code, String codeVerifier, final String state, final String name, final LoginResultCallBack loginResultCallBack) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", TapLoginInnerConfig.getClientId());
        params.put("grant_type", "authorization_code");
        params.put("secret_type", "hmac-sha-1");
        params.put("code", code);
        params.put("redirect_uri", "tapoauth://authorize");
        params.put("code_verifier", codeVerifier);
        params.put("version", "3.28.3");
        params.put("platform", "android");
        JSONObject info = new JSONObject();
        try {
            info.put("device_id", (Object)(Build.MANUFACTURER + " " + Build.MODEL));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("info", info.toString());
        Api.post(TapLoginInnerConfig.getRegionType().tokenUrl(), params, new Api.ApiCallback<JSONObject>(){

            @Override
            public void onSuccess(JSONObject data) {
                boolean isSuccess = data.optBoolean("success");
                JSONObject dataObj = data.optJSONObject("data");
                if (isSuccess) {
                    String kid = dataObj.optString("kid");
                    String access_token = dataObj.optString("access_token");
                    String token_type = dataObj.optString("token_type");
                    String mac_key = dataObj.optString("mac_key");
                    String mac_algorithm = dataObj.optString("mac_algorithm");
                    AccessToken token = new AccessToken(kid, access_token, token_type, mac_key, mac_algorithm, dataObj.optString("scope"), dataObj.toString());
                    LoginResponse response = new LoginResponse(null, state, null, token, false, name);
                    if (null != loginResultCallBack) {
                        loginResultCallBack.onLoginResult(response);
                    }
                } else {
                    String errorDesc = dataObj.optString("error_description");
                    LoginResponse response = new LoginResponse(null, state, errorDesc, null, false, name);
                    if (null != loginResultCallBack) {
                        loginResultCallBack.onLoginResult(response);
                    }
                }
            }

            @Override
            public void onError(Throwable error) {
                LoginResponse response = new LoginResponse(null, state, error.getMessage(), null, false);
                if (null != loginResultCallBack) {
                    loginResultCallBack.onLoginResult(response);
                }
            }
        });
    }

    public static interface LoginResultCallBack {
        public void onLoginResult(LoginResponse var1);
    }
}

