/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.content.Context;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.IscTapLoginService;
import com.taptap.sdk.LoginSdkConfig;
import com.taptap.sdk.Profile;
import com.taptap.sdk.RegionType;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.TapTapSharePreference;
import com.taptap.sdk.TokenValidChecker;
import com.taptap.sdk.Validate;
import com.tds.common.isc.IscServiceManager;

public class TapTapSdk {
    public static final String SCOPE_PUIBLIC_PROFILE = "public_profile";
    public static volatile boolean isInited = false;
    public static final int LOGIN_SESSION_CODE = 10;

    public static synchronized void sdkInitialize(Context applicationContext, String client_id) {
        TapTapSdk.sdkInitialize(applicationContext, client_id, TapTapSdk.checkLoginSdkConfig(null));
    }

    public static synchronized void sdkInitialize(Context applicationContext, String client_id, LoginSdkConfig config) {
        config = TapTapSdk.checkLoginSdkConfig(config);
        Validate.notNull(applicationContext, "application context");
        Validate.hasInternetPermissions(applicationContext, false);
        Validate.hasTapTapActivity(applicationContext, true);
        if (!isInited) {
            isInited = true;
            TapTapSharePreference.init(applicationContext);
            TapLoginInnerConfig.setClientId(client_id);
            TapLoginInnerConfig.setRegionType(config.regionType);
            AccessToken token = AccessToken.getCurrentAccessToken();
            Profile profile = Profile.getCurrentProfile();
            if (token != null) {
                TokenValidChecker.check(token.access_token, client_id);
                if (profile == null) {
                    Profile.fetchProfileForCurrentAccessToken(null);
                }
            }
        }
        TapLoginInnerConfig.roundCorner = config.roundCorner;
        TapLoginInnerConfig.isPortrait = config.isPortrait;
        IscServiceManager.register(IscTapLoginService.class);
    }

    public static void changeTapLoginConfig(LoginSdkConfig config) {
        TapLoginInnerConfig.roundCorner = config.roundCorner;
        TapLoginInnerConfig.isPortrait = config.isPortrait;
    }

    public static synchronized String getClientId() {
        return TapLoginInnerConfig.getClientId();
    }

    public static synchronized RegionType regionType() {
        return TapLoginInnerConfig.getRegionType();
    }

    public static String getSDKVersion() {
        return "3.28.3";
    }

    private static synchronized LoginSdkConfig checkLoginSdkConfig(LoginSdkConfig config) {
        if (config == null) {
            config = new LoginSdkConfig();
            config.roundCorner = true;
            config.isPortrait = true;
            config.regionType = RegionType.CN;
            return config;
        }
        return config;
    }
}

