/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.text.TextUtils;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.Log;
import com.taptap.sdk.LoginManager;
import com.taptap.sdk.TapTapSdk;
import com.taptap.sdk.exceptions.ServerError;
import com.taptap.sdk.net.Api;
import org.json.JSONException;
import org.json.JSONObject;

public class TestQualificationModel {
    public void getTestQualificationAsync(final Api.ApiCallback<Boolean> callback) {
        if (AccessToken.getCurrentAccessToken() == null) {
            callback.onError(new RuntimeException("Login first"));
            Log.DEBUG_LOG("Need login first!!");
            return;
        }
        Api.get(String.format(TapTapSdk.regionType().testQualificationUrl(), TapTapSdk.getClientId()), null, new Api.ApiCallback<JSONObject>(){

            @Override
            public void onSuccess(JSONObject jsonObject) {
                JSONObject result;
                if (null != jsonObject && jsonObject.optBoolean("success") && (result = jsonObject.optJSONObject("data")) != null && result.has("in_test")) {
                    callback.onSuccess(result.optBoolean("in_test"));
                    return;
                }
                callback.onSuccess(false);
            }

            @Override
            public void onError(Throwable error) {
                String errorMessage = "get testQualification error";
                if (error instanceof ServerError) {
                    if (!TextUtils.isEmpty((CharSequence)error.getMessage()) && error.getMessage() != null && error.getMessage().contains("access_denied")) {
                        LoginManager.getInstance().logout();
                    }
                    try {
                        JSONObject jsonObject;
                        JSONObject errorData;
                        String jsonStr = error.getMessage();
                        int errorCode = 80000;
                        if (!TextUtils.isEmpty((CharSequence)jsonStr) && (errorData = (jsonObject = new JSONObject(jsonStr)).optJSONObject("data")) != null) {
                            errorMessage = errorData.optString("msg");
                            errorCode = errorData.optInt("code");
                        }
                        callback.onError(new ServerError(errorMessage, errorCode));
                        return;
                    }
                    catch (JSONException e) {
                        errorMessage = e.getMessage();
                    }
                }
                callback.onError(new Throwable(errorMessage));
            }
        });
    }
}

