/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.IscTapLoginService;
import com.taptap.sdk.TapTapSdk;
import com.taptap.sdk.exceptions.ServerError;
import com.taptap.sdk.net.Api;
import com.tds.common.utils.GUIDHelper;
import java.util.HashMap;
import org.json.JSONObject;

class TokenValidChecker {
    TokenValidChecker() {
    }

    static void check(String oldToken, String clientId) {
        if (TextUtils.isEmpty((CharSequence)oldToken) || TextUtils.isEmpty((CharSequence)clientId)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("grant_type", "refresh_token");
        params.put("token", oldToken);
        params.put("token_type_hint", "access_token");
        String infoStr = "";
        try {
            JSONObject infoJSON = new JSONObject();
            infoJSON.put("device_id", (Object)(Build.MANUFACTURER + " " + Build.MODEL));
            infoJSON.put("uuid", (Object)GUIDHelper.INSTANCE.getUID());
            infoStr = infoJSON.toString();
        }
        catch (Exception e) {
            Log.e((String)"TokenValidChecker", (String)("TokenValidChecker check method:  " + e));
        }
        if (!TextUtils.isEmpty((CharSequence)infoStr)) {
            params.put("info", infoStr);
        }
        Api.post(TapTapSdk.regionType().tokenUrl(), params, new Api.ApiCallback<JSONObject>(){

            @Override
            public void onSuccess(JSONObject data) {
                JSONObject dataObj = data.optJSONObject("data");
                if (dataObj != null) {
                    try {
                        AccessToken token = new AccessToken(dataObj.toString());
                        AccessToken.setCurrentToken(token);
                    }
                    catch (Exception e) {
                        Log.e((String)"TokenValidChecker", (String)("TokenValidChecker onSuccess callback method:  " + e));
                    }
                }
            }

            @Override
            public void onError(Throwable error) {
                if (error instanceof ServerError) {
                    String errorResponse = error.getMessage();
                    IscTapLoginService.checkLoginError(errorResponse, "invalid_grant");
                }
            }
        });
    }
}

