/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.taptap.sdk.TapTapSdk;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class Utils {
    private static Executor mPools;
    private static Handler mHandler;

    public static boolean isLoginSDKInitialized() {
        return TapTapSdk.isInited;
    }

    private static synchronized Executor getPool() {
        if (null == mPools) {
            mPools = Executors.newFixedThreadPool(2);
        }
        return mPools;
    }

    public static boolean runOnAsync(Runnable runnable) {
        Utils.getPool().execute(runnable);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean runOnUIThread(Runnable runnable) {
        if (null == mHandler) {
            Class<Utils> clazz = Utils.class;
            // MONITORENTER : com.taptap.sdk.Utils.class
            if (null == mHandler) {
                mHandler = new Handler(Looper.getMainLooper());
            }
            // MONITOREXIT : clazz
        }
        mHandler.post(runnable);
        return true;
    }

    public static int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }
}

