/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import com.taptap.sdk.Log;
import com.taptap.sdk.TapTapSdk;
import com.taptap.sdk.ui.TapTapActivity;

public class Validate {
    public static void notNull(Object o, String argument) {
        if (null == o) {
            Log.DEBUG_LOG("Argument '" + argument + "' can not be null");
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public static void hasTapTapActivity(Context context, boolean shouldThrow) {
        Validate.notNull(context, "context");
        PackageManager pm = context.getPackageManager();
        ActivityInfo activityInfo = null;
        if (pm != null) {
            ComponentName componentName = new ComponentName(context, TapTapActivity.class);
            try {
                activityInfo = pm.getActivityInfo(componentName, 1);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (activityInfo == null) {
            if (shouldThrow) {
                throw new IllegalStateException("TapTapActivity is not declared in the AndroidManifest.xml, please add com.taptap.sdk.ui.TapTapActivity to your AndroidManifest.xml file. ");
            }
            Log.DEBUG_LOG("TapTapActivity is not declared in the AndroidManifest.xml, please add com.taptap.sdk.ui.TapTapActivity to your AndroidManifest.xml file. ");
        }
    }

    public static void hasInternetPermissions(Context context, boolean shouldThrow) {
        Validate.notNull(context, "context");
        if (context.checkCallingOrSelfPermission("android.permission.INTERNET") == -1) {
            if (shouldThrow) {
                throw new IllegalStateException("No internet permissions granted for the app, please add <uses-permission android:name=\"android.permission.INTERNET\" /> to your AndroidManifest.xml.");
            }
            Log.DEBUG_LOG("No internet permissions granted for the app, please add <uses-permission android:name=\"android.permission.INTERNET\" /> to your AndroidManifest.xml.");
        }
    }

    public static void sdkHasInitialized() {
        if (!TapTapSdk.isInited) {
            Log.DEBUG_LOG("sdk has not initialized. please call TapTapSdk.sdkInitialize first");
        }
    }
}

