/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.friends;

import com.taptap.sdk.friends.TapFriendInfo;
import com.tds.common.annotation.Keep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class TapFriendResult {
    private final List<TapFriendInfo> data;
    private String cursor = null;

    public TapFriendResult(List<TapFriendInfo> friendList, String cursor) {
        this.data = friendList;
        this.cursor = cursor;
    }

    public List<TapFriendInfo> getData() {
        return this.data;
    }

    public String getCursor() {
        return this.cursor;
    }

    public static TapFriendResult parseData(JSONObject response) throws JSONException {
        if (response == null) {
            return null;
        }
        String nextCursor = null;
        JSONObject data = response.getJSONObject("data");
        JSONArray array = data.getJSONArray("list");
        boolean isTruncated = data.getBoolean("is_truncated");
        if (isTruncated) {
            nextCursor = data.getString("next_continuation_token");
        }
        if (array.length() == 0) {
            return new TapFriendResult(Collections.emptyList(), nextCursor);
        }
        ArrayList<TapFriendInfo> tapFriendInfos = new ArrayList<TapFriendInfo>();
        int length = array.length();
        for (int i = 0; i < length; ++i) {
            JSONObject object = array.getJSONObject(i);
            String openId = object.getString("openid");
            String nickname = object.getString("nickname");
            String avatar = object.getString("avatar");
            tapFriendInfos.add(new TapFriendInfo(openId, nickname, avatar));
        }
        return new TapFriendResult(tapFriendInfos, nextCursor);
    }

    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        try {
            object.put("cursor", (Object)this.cursor);
            if (this.data != null) {
                JSONArray jsonArray = new JSONArray();
                for (TapFriendInfo tapFriendInfo : this.data) {
                    if (tapFriendInfo == null) continue;
                    jsonArray.put((Object)tapFriendInfo.toJson());
                }
                object.put("data", (Object)jsonArray);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }

    public String toString() {
        return "TapFriendResult{data=" + this.data + ", cursor='" + this.cursor + '\'' + '}';
    }
}

