/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.friends;

import com.taptap.sdk.AccessToken;
import com.taptap.sdk.Log;
import com.taptap.sdk.RegionType;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.friends.TapFriendResult;
import com.taptap.sdk.friends.TapFriendsCallback;
import com.taptap.sdk.net.Api;
import com.tds.common.annotation.Keep;
import java.util.HashMap;
import org.json.JSONObject;

@Keep
public class TapFriends {
    private static final String URL_CN = "https://open.tapapis.cn/friends/v1/list";
    private static final String URL_IO = "https://open.tapapis.com/friends/v1/list";

    public static void queryMutualList(String cursor, int size, final TapFriendsCallback<TapFriendResult> callback) {
        if (AccessToken.getCurrentAccessToken() == null) {
            if (callback != null) {
                callback.onFail(new RuntimeException(" query friend list before login"));
            }
            return;
        }
        if (size < 0 || size > 500) {
            size = 50;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("max_size", size + "");
        params.put("continuation_token", cursor);
        params.put("client_id", TapLoginInnerConfig.getClientId());
        String url = TapLoginInnerConfig.getRegionType() == RegionType.CN ? URL_CN : URL_IO;
        Api.getWithHeader(url, null, params, new Api.ApiCallback<JSONObject>(){

            @Override
            public void onSuccess(JSONObject data) {
                block3: {
                    try {
                        TapFriendResult tapFriendResult = TapFriendResult.parseData(data);
                        if (callback != null) {
                            callback.onSuccess(tapFriendResult);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block3;
                        callback.onFail(e);
                    }
                }
            }

            @Override
            public void onError(Throwable error) {
                Log.DEBUG_LOG("friend query mutual list fail = " + error.getMessage());
                if (callback != null) {
                    callback.onFail(error);
                }
            }
        });
    }
}

