/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.internal.user;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.Profile;
import com.tds.common.utils.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CurrentUserProvider
extends ContentProvider {
    static final String AUTH_DATA_PARAM = "auth_data";
    public static Uri CONTENT_URI;
    static String PROVIDER_NAME;
    static String URL;
    static final int uriCode = 1;
    static final String DATABASE_NAME = "TmpUserDB";
    static final String TABLE_NAME = "CurrentUser";
    static final int DATABASE_VERSION = 1;
    private SQLiteDatabase db;
    static final UriMatcher uriMatcher;
    static final String CREATE_DB_TABLE = " CREATE TABLE CurrentUser (auth_data TEXT NOT NULL);";

    public boolean onCreate() {
        Context context = this.getContext();
        DatabaseHelper dbHelper = new DatabaseHelper(context);
        this.db = dbHelper.getWritableDatabase();
        PROVIDER_NAME = context.getPackageName() + ".tap_user.provider";
        URL = "content://" + PROVIDER_NAME + "/current_user";
        CONTENT_URI = Uri.parse((String)URL);
        uriMatcher.addURI(context.getPackageName() + ".tap_user.provider", "/current_user", 1);
        return this.db != null;
    }

    private Map<String, Object> jsonStrToMap(String jsonStr) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            Map tmpMap = JsonUtil.toMap((JSONObject)jsonObject);
            for (Map.Entry entry : tmpMap.entrySet()) {
                result.put((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
            qb.setTables(TABLE_NAME);
            if (uriMatcher.match(uri) != 1) {
                throw new IllegalArgumentException("Unknown URI " + uri);
            }
            qb.setProjectionMap(new HashMap());
            this.db.delete(TABLE_NAME, "", null);
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            if (accessToken != null) {
                Profile currentProfile;
                String accessTokenJsonStr = accessToken.toJsonString();
                Map<Object, Object> accessTokenMap = new HashMap();
                if (accessTokenJsonStr != null && accessTokenJsonStr.length() > 0) {
                    accessTokenMap = this.jsonStrToMap(accessTokenJsonStr);
                }
                if ((currentProfile = Profile.getCurrentProfile()) != null) {
                    String currentProfileJsonStr = currentProfile.toJsonString();
                    Map<Object, Object> userProfileMap = new HashMap();
                    if (currentProfileJsonStr != null && currentProfileJsonStr.length() > 0) {
                        userProfileMap = this.jsonStrToMap(currentProfileJsonStr);
                    }
                    HashMap authDataMap = new HashMap(accessTokenMap);
                    authDataMap.putAll(userProfileMap);
                    if (authDataMap.size() > 0) {
                        String authDataJsonStr = "";
                        try {
                            authDataJsonStr = JsonUtil.toJsonStr(authDataMap);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        if (authDataJsonStr.length() > 0) {
                            ContentValues contentValues = new ContentValues();
                            contentValues.put(AUTH_DATA_PARAM, authDataJsonStr);
                            long rowID = this.db.insert(TABLE_NAME, "", contentValues);
                            if (rowID > 0L) {
                                Uri _uri = ContentUris.withAppendedId((Uri)CONTENT_URI, (long)rowID);
                                this.getContext().getContentResolver().notifyChange(_uri, null);
                            }
                        }
                    }
                }
            }
            Cursor c = qb.query(this.db, projection, selection, selectionArgs, null, null, sortOrder);
            c.setNotificationUri(this.getContext().getContentResolver(), uri);
            return c;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getType(Uri uri) {
        if (uriMatcher.match(uri) == 1) {
            return "vnd.android.cursor.dir/current_user";
        }
        throw new IllegalArgumentException("Unsupported URI: " + uri);
    }

    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("insert is not supported" + uri);
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("update is not supported" + uri);
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("delete is not supported" + uri);
    }

    static {
        uriMatcher = new UriMatcher(-1);
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context) {
            super(context, CurrentUserProvider.DATABASE_NAME, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL(CurrentUserProvider.CREATE_DB_TABLE);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS CurrentUser");
            this.onCreate(db);
        }
    }
}

