/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.net;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import com.taptap.sdk.AccessToken;
import com.taptap.sdk.Utils;
import com.taptap.sdk.exceptions.ServerError;
import com.taptap.sdk.net.TimeVerifier;
import com.tds.common.annotation.Keep;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.json.JSONObject;

public class Api {
    private static final int MAX_RETRY_COUNT = 1;
    private static int retryCount;

    private static final String getUA() {
        return "TapTapAndroidSDK/3.28.3 " + System.getProperty("http.agent");
    }

    private static boolean isTimeError(JSONObject error) {
        JSONObject data = error.optJSONObject("data");
        return data != null && TextUtils.equals((CharSequence)data.optString("error"), (CharSequence)"invalid_time");
    }

    private static void doGet(String url, AccessToken token, ApiCallback<JSONObject> callback) throws IOException, JSONException {
        URL httpURL = new URL(url);
        HttpURLConnection urlConnection = (HttpURLConnection)httpURL.openConnection();
        urlConnection.setRequestMethod("GET");
        urlConnection.addRequestProperty("User-Agent", Api.getUA());
        urlConnection.addRequestProperty("Authorization", Api.getAuthorization(url, "GET", token.kid, token.mac_key));
        urlConnection.setConnectTimeout(10000);
        urlConnection.setReadTimeout(10000);
        int responseCode = urlConnection.getResponseCode();
        StringBuilder builder = new StringBuilder();
        if (responseCode >= 200 && responseCode < 400) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            JSONObject result = new JSONObject(builder.toString());
            Api.notifyResult(callback, result);
        } else {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            JSONObject error = new JSONObject(builder.toString());
            if (Api.isTimeError(error) && retryCount < 1) {
                ++retryCount;
                Api.checkTime(error.optLong("now"));
                Api.doGet(url, token, callback);
            } else {
                retryCount = 0;
                Api.notifyError(callback, new ServerError(builder.toString(), responseCode));
            }
        }
    }

    public static void get(final String url, HashMap<String, String> params, final ApiCallback<JSONObject> callback) {
        final AccessToken token = AccessToken.getCurrentAccessToken();
        if (null == token) {
            return;
        }
        Utils.runOnAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String finalUrl = url;
                BufferedReader reader = null;
                try {
                    Api.doGet(finalUrl, token, callback);
                }
                catch (Exception e) {
                    Utils.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(e);
                        }
                    });
                }
                finally {
                    if (null != reader) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public static void post(final String url, final HashMap<String, String> params, final ApiCallback<JSONObject> callback) {
        Utils.runOnAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String finalUrl = url;
                BufferedReader reader = null;
                OutputStream outputStream = null;
                try {
                    String line;
                    URL httpurl = new URL(finalUrl);
                    HttpURLConnection urlConnection = (HttpURLConnection)httpurl.openConnection();
                    urlConnection.setDoOutput(true);
                    urlConnection.setRequestMethod("POST");
                    urlConnection.addRequestProperty("User-Agent", Api.getUA());
                    urlConnection.setConnectTimeout(10000);
                    urlConnection.setReadTimeout(10000);
                    urlConnection.setUseCaches(false);
                    outputStream = urlConnection.getOutputStream();
                    if (null != params && params.size() > 0) {
                        StringBuilder builder = new StringBuilder();
                        Set entries = params.entrySet();
                        Iterator iterator = entries.iterator();
                        int index = 0;
                        while (iterator.hasNext()) {
                            Map.Entry next = iterator.next();
                            builder.append((String)next.getKey() + "=" + Uri.encode((String)((String)next.getValue())));
                            if (index == params.size()) continue;
                            builder.append("&");
                        }
                        outputStream.write(builder.toString().getBytes("UTF-8"));
                        outputStream.flush();
                    }
                    int responseCode = urlConnection.getResponseCode();
                    StringBuilder builder = new StringBuilder();
                    if (responseCode >= 200 && responseCode < 400) {
                        reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                        while ((line = reader.readLine()) != null) {
                            builder.append(line).append("\n");
                        }
                        JSONObject result = new JSONObject(builder.toString());
                        Api.notifyResult(callback, result);
                    } else {
                        reader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                        while ((line = reader.readLine()) != null) {
                            builder.append(line).append("\n");
                        }
                        Api.notifyError(callback, new ServerError(builder.toString(), responseCode));
                    }
                }
                catch (Exception e) {
                    Utils.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(e);
                        }
                    });
                }
                finally {
                    if (null != reader) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (null != outputStream) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public static void getWithHeader(final String url, final Map<String, String> headers, final Map<String, String> params, final ApiCallback<JSONObject> callback) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            Api.notifyError(callback, new RuntimeException("invalid url =" + url));
            return;
        }
        final AccessToken token = AccessToken.getCurrentAccessToken();
        if (null == token) {
            Api.notifyError(callback, new RuntimeException("invalid token =" + url));
            return;
        }
        Utils.runOnAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Uri uri = Uri.parse((String)url);
                if (params != null) {
                    Uri.Builder builder = uri.buildUpon();
                    for (Map.Entry entry : params.entrySet()) {
                        if (TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) continue;
                        builder.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
                    }
                    uri = builder.build();
                }
                String finalUrl = uri.toString();
                BufferedReader reader = null;
                OutputStream outputStream = null;
                try {
                    URL httpurl = new URL(finalUrl);
                    HttpURLConnection urlConnection = (HttpURLConnection)httpurl.openConnection();
                    urlConnection.setRequestMethod("GET");
                    urlConnection.addRequestProperty("User-Agent", Api.getUA());
                    urlConnection.addRequestProperty("Authorization", Api.getAuthorization(finalUrl, "GET", token.kid, token.mac_key));
                    urlConnection.setConnectTimeout(10000);
                    urlConnection.setReadTimeout(10000);
                    if (headers != null) {
                        for (Map.Entry entry : headers.entrySet()) {
                            if (TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) continue;
                            urlConnection.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    int responseCode = urlConnection.getResponseCode();
                    StringBuilder builder = new StringBuilder();
                    if (responseCode >= 200 && responseCode < 400) {
                        String line;
                        reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                        while ((line = reader.readLine()) != null) {
                            builder.append(line).append("\n");
                        }
                        JSONObject result = new JSONObject(builder.toString());
                        Api.notifyResult(callback, result);
                    } else {
                        String line;
                        reader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                        while ((line = reader.readLine()) != null) {
                            builder.append(line).append("\n");
                        }
                        Api.notifyError(callback, new ServerError(builder.toString(), responseCode));
                    }
                }
                catch (Exception e) {
                    Utils.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(e);
                        }
                    });
                }
                finally {
                    if (null != reader) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (null != outputStream) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    private static String getAuthorization(String url_string, String method, String keyid, String mac_key) {
        try {
            URL url = new URL(url_string);
            String time = Api.getTime();
            String randomStr = Api.getRandomString(5);
            String host = url.getHost();
            String uri = url_string.substring(url_string.lastIndexOf(host) + host.length());
            String port = "80";
            if (url_string.startsWith("https")) {
                port = "443";
            }
            String other = "";
            String sign = Api.sign(Api.mergeSign(time, randomStr, method, uri, host, port, other), mac_key);
            return "MAC " + Api.getAuthorizationParam("id", keyid) + "," + Api.getAuthorizationParam("ts", time) + "," + Api.getAuthorizationParam("nonce", randomStr) + "," + Api.getAuthorizationParam("mac", sign);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    private static String sign(String signatureBaseString, String key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] text = signatureBaseString.getBytes("UTF-8");
            byte[] signatureBytes = mac.doFinal(text);
            signatureBytes = Base64.encode((byte[])signatureBytes, (int)2);
            String signature = new String(signatureBytes, "UTF-8");
            return signature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String mergeSign(String time, String randomCode, String httpType, String uri, String domain, String port, String other) {
        if (TextUtils.isEmpty((CharSequence)time) || TextUtils.isEmpty((CharSequence)randomCode) || TextUtils.isEmpty((CharSequence)httpType) || TextUtils.isEmpty((CharSequence)domain) || TextUtils.isEmpty((CharSequence)port)) {
            return null;
        }
        String prefix = time + "\n" + randomCode + "\n" + httpType + "\n" + uri + "\n" + domain + "\n" + port + "\n";
        prefix = TextUtils.isEmpty((CharSequence)other) ? prefix + "\n" : prefix + other + "\n";
        return prefix;
    }

    private static String getAuthorizationParam(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return key + "=\"" + value + "\"";
    }

    private static void notifyError(final ApiCallback callback, final Throwable error) {
        Utils.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                callback.onError(error);
            }
        });
    }

    private static void notifyResult(final ApiCallback callback, final JSONObject result) {
        Utils.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess(result);
            }
        });
    }

    private static void checkTime(long nowServer) {
        try {
            if (nowServer > 0L) {
                TimeVerifier.setDelta(nowServer * 1000L - System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getTime() {
        return String.format(Locale.US, "%010d", TimeVerifier.getCurrentTimeMillions() / 1000L);
    }

    @Keep
    public static interface ApiCallback<T> {
        public void onSuccess(T var1);

        public void onError(Throwable var1);
    }
}

