/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.ui;

import android.content.Intent;
import android.os.Bundle;
import com.taptap.sdk.LoginRequest;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.tracker.TapTapLoginTrackerHelper;
import com.taptap.sdk.ui.ActivityDelegate;
import com.taptap.sdk.ui.BaseHandler;
import com.taptap.sdk.ui.LoginUtils;

class ActivityHandler
extends BaseHandler {
    public static final String KEY_REQUEST = "com.taptap.sdk.request";
    public static final String REQ_KEY_CLIENT_ID = "com.taptap.sdk.request.client_id";
    public static final String REQ_KEY_STATE = "com.taptap.sdk.request.state";
    public static final String REQ_KEY_PERMISSIONS = "com.taptap.sdk.request.permissions";
    public static final String REQ_KEY_SDK_VERSION = "com.taptap.sdk.request.sdk_version";
    public static final String REQ_KEY_LOGIN_VERSION = "com.taptap.sdk.request.login_version";
    public static final String REQ_KEY_RESPONSE_TYPE = "com.taptap.sdk.request.response_type";
    public static final String REQ_KEY_REDIRECT_URI = "com.taptap.sdk.request.redirect_uri";
    public static final String REQ_KEY_CODE_CHALLENGE = "com.taptap.sdk.request.code_challenge";
    public static final String REQ_KEY_CODE_CHALLENGE_METHOD = "com.taptap.sdk.request.code_challenge_method";
    public static final String REQ_KEY_SCREEN_PORTRAIT = "com.taptap.sdk.request.screen.portrait";
    public static final String REQ_KEY_INFO = "com.taptap.sdk.request.info";
    public static final String REQ_KEY_EXTRA = "com.taptap.sdk.request.extra";
    private ActivityDelegate activityDelegate;

    public ActivityHandler(ActivityDelegate activityDelegate) {
        this.activityDelegate = activityDelegate;
    }

    @Override
    public void authorize(LoginRequest request) throws Exception {
        Intent intent = this.toIntent(request);
        intent.setAction(TapLoginInnerConfig.getRegionType().targetActionName());
        TapTapLoginTrackerHelper.authorizationOpen("taptap");
        this.activityDelegate.startActivityForResult(intent, request.getRequestCode());
    }

    public Intent toIntent(LoginRequest request) {
        Intent intent = new Intent();
        Bundle bundle = LoginUtils.createLoginBundle(request);
        intent.putExtra(KEY_REQUEST, bundle);
        return intent;
    }
}

