/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.ui;

import android.app.Activity;
import android.view.ViewGroup;
import com.taptap.sdk.ui.Block;
import com.taptap.sdk.ui.IBlockHost;
import java.util.LinkedList;
import java.util.List;

class BlockManager {
    private List<Block> mBlocks = new LinkedList<Block>();
    private Activity mActivity;

    public BlockManager(Activity activity) {
        if (!(activity instanceof IBlockHost)) {
            throw new IllegalArgumentException("Activity must be implements IBlockHost");
        }
        this.mActivity = activity;
    }

    public BlockManager add(int containerViewId, Block block) {
        if (this.mBlocks.contains(block)) {
            throw new IllegalArgumentException("this Block has been added");
        }
        this.mBlocks.add(block);
        return this.add((ViewGroup)this.mActivity.findViewById(containerViewId), block);
    }

    public BlockManager remove(Block block) {
        if (this.mBlocks.contains(block)) {
            block.onDestroy();
            this.mBlocks.remove(block);
        }
        return this;
    }

    public BlockManager replace(int containerViewId, Block block) {
        if (!this.mBlocks.isEmpty()) {
            Block old = this.mBlocks.remove(this.mBlocks.size() - 1);
            old.onDestroy();
        }
        return this.add(containerViewId, block);
    }

    private BlockManager add(ViewGroup containerView, Block block) {
        block.attachActivity(this.mActivity, containerView);
        return this;
    }

    public void onDestroy() {
        this.mBlocks.clear();
        this.mBlocks = null;
    }

    public List<Block> getBlocks() {
        return this.mBlocks;
    }

    public Block getCurrent() {
        if (!this.mBlocks.isEmpty()) {
            return this.mBlocks.get(this.mBlocks.size() - 1);
        }
        return null;
    }
}

