/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.ui;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import com.taptap.sdk.LoginRequest;
import com.taptap.sdk.LoginResponse;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.model.CloudGameInitializeFinish;
import com.taptap.sdk.model.CloudGameLoginResponse;
import com.taptap.sdk.model.CloudGameReceiptMessage;
import com.taptap.sdk.tracker.TapTapLoginTrackerHelper;
import com.taptap.sdk.ui.ActivityDelegate;
import com.taptap.sdk.ui.BaseHandler;
import com.taptap.sdk.ui.LoginUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class CloudGameHandler
extends BaseHandler {
    public static final String RES_TYPE_LOGIN = "login_taptap_finish";
    public static final String RES_RECEIPT_MESSAGE = "message_result";
    public static final String RES_INIT_MESSAGE = "initialize_finish";
    public static final String RES_MIDDLE_LAYER_INIT_FINISH = "middle_layer_init_finish";
    public static final String GSON_PARSE_ERROR_MESSAGE = "Gson parse JsonSyntaxException";
    private ActivityDelegate activityDelegate;
    private Messenger messenger;
    private static final int MESSAGE_FROM_CLIENT = 10001;
    private OnCloudGameLoginResult onCloudGameLoginResult;
    private String loginRequestMid = UUID.randomUUID().toString();
    private String initializeMid = UUID.randomUUID().toString();
    private Message loginMessage;
    private CloudGameInitializeFinish cloudGameInitializeFinish;
    private CloudGameServiceConnection cloudGameServiceConnection;
    private LoginRequest loginRequest;
    private String clientLoginVersion;
    private ArrayList<String> sdkLoginVersionArrayList = new ArrayList();
    private Messenger replyMessenger = new Messenger(new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            try {
                Bundle bundle = msg.getData();
                String message = bundle.getString("message");
                if (CloudGameHandler.GSON_PARSE_ERROR_MESSAGE.equals(message)) {
                    LoginResponse loginResponse = new LoginResponse(null, CloudGameHandler.this.loginRequest.getState(), CloudGameHandler.GSON_PARSE_ERROR_MESSAGE, null, false);
                    CloudGameHandler.this.activityDelegate.setResult(-1, loginResponse.toIntent(null));
                    CloudGameHandler.this.activityDelegate.finish();
                } else {
                    JSONObject jsonObject = new JSONObject(message);
                    String type = jsonObject.getString("type");
                    CloudGameHandler.this.toastMessage("\u4e2d\u95f4\u4ef6\u8fd4\u56de\u7684\u6d88\u606f: " + jsonObject.toString());
                    if (CloudGameHandler.RES_TYPE_LOGIN.equals(type)) {
                        CloudGameHandler.this.handleLoginResponse(jsonObject);
                    } else if (CloudGameHandler.RES_RECEIPT_MESSAGE.equals(type)) {
                        CloudGameHandler.this.handleReceiptMessage(jsonObject);
                    } else if (CloudGameHandler.RES_INIT_MESSAGE.equals(type)) {
                        CloudGameHandler.this.handleInitializeFinishMessage(jsonObject);
                    } else if (CloudGameHandler.RES_MIDDLE_LAYER_INIT_FINISH.equals(type)) {
                        CloudGameHandler.this.sendConfigInfoMessage();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                CloudGameHandler.this.failedCallback();
            }
        }
    });

    public CloudGameHandler(ActivityDelegate activityDelegate) {
        this.activityDelegate = activityDelegate;
        this.cloudGameServiceConnection = new CloudGameServiceConnection();
        this.initSDKLoginVersionList();
    }

    public void setOnCloudGameLoginResult(OnCloudGameLoginResult onCloudGameLoginResult) {
        this.onCloudGameLoginResult = onCloudGameLoginResult;
    }

    public CloudGameServiceConnection getCloudGameServiceConnection() {
        return this.cloudGameServiceConnection;
    }

    private void handleLoginResponse(JSONObject jsonObject) {
        try {
            CloudGameLoginResponse response = CloudGameLoginResponse.parseFromJSONObject(jsonObject);
            this.loginResultBack(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failedCallback();
        }
    }

    private void initSDKLoginVersionList() {
        this.sdkLoginVersionArrayList.add("1.0");
    }

    private String getLoginResponseVersion(String clientLoginVersion) {
        String loginResponseVersion = "";
        switch (clientLoginVersion) {
            case "1.0": {
                loginResponseVersion = "1";
                break;
            }
            default: {
                loginResponseVersion = "0";
            }
        }
        return loginResponseVersion;
    }

    private void loginResultBack(CloudGameLoginResponse response) {
        LoginResponse loginResponse = new LoginResponse(null, response.data.state, response.data.errorMessage, null, response.data.cancel);
        loginResponse.loginVersion = this.getLoginResponseVersion(this.clientLoginVersion);
        loginResponse.code = response.data.code;
        if (GSON_PARSE_ERROR_MESSAGE.equals(response.data.errorMessage)) {
            this.failedCallback();
        } else {
            this.activityDelegate.setResult(-1, loginResponse.toIntent(response.data.serverUri));
            this.activityDelegate.finish();
        }
    }

    private void toastMessage(String message) {
    }

    private void handleReceiptMessage(JSONObject jsonObject) {
        try {
            CloudGameReceiptMessage receiptMessage = CloudGameReceiptMessage.parseFromJSONObject(jsonObject);
            if (!receiptMessage.data.success && (this.loginRequestMid.equals(receiptMessage.data.messageId) || this.initializeMid.equals(receiptMessage.data.messageId))) {
                this.failedCallback();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failedCallback();
        }
    }

    private void handleInitializeFinishMessage(JSONObject jsonObject) {
        try {
            this.cloudGameInitializeFinish = CloudGameInitializeFinish.parseFromJSONObject(jsonObject);
            if (this.checkSupportLogin(this.cloudGameInitializeFinish)) {
                this.sendLoginMessage();
            } else {
                this.failedCallback();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failedCallback();
        }
    }

    private void failedCallback() {
        if (this.onCloudGameLoginResult != null) {
            this.onCloudGameLoginResult.onLoginFailed();
        }
    }

    private boolean checkSupportLogin(CloudGameInitializeFinish cloudGameInitializeFinish) {
        if (cloudGameInitializeFinish.data != null && cloudGameInitializeFinish.data.cgpn != null && cloudGameInitializeFinish.data.cgpn.login != null && !cloudGameInitializeFinish.data.cgpn.login.isEmpty()) {
            this.clientLoginVersion = cloudGameInitializeFinish.data.cgpn.login;
            return this.sdkLoginVersionArrayList.contains(this.clientLoginVersion);
        }
        return false;
    }

    @Override
    void authorize(LoginRequest request) throws Exception {
        this.loginRequest = request;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"login_taptap");
        jsonObject.put("message_id", (Object)this.loginRequestMid);
        Bundle loginBundle = LoginUtils.createLoginBundle(request);
        JSONObject dataJsonObject = LoginUtils.createCloudLoginJsonObject(loginBundle);
        dataJsonObject.put("client_id", (Object)TapLoginInnerConfig.getClientId());
        JSONArray jsonArray = new JSONArray();
        for (String permission2 : request.getPermissions()) {
            jsonArray.put((Object)permission2);
        }
        dataJsonObject.put("scopes", (Object)jsonArray);
        dataJsonObject.put("state", (Object)request.getState());
        dataJsonObject.put("sdk_version", (Object)request.getVersionCode());
        dataJsonObject.put("portrait", this.activityDelegate.isPortrait());
        dataJsonObject.put("sdk_info", (Object)request.getInfo());
        dataJsonObject.put("response_type", (Object)request.getResponseType());
        dataJsonObject.put("code_challenge", (Object)request.getCodeChallenge());
        dataJsonObject.put("code_challenge_method", (Object)request.getCodeChallengeMethod());
        jsonObject.put("data", (Object)dataJsonObject);
        this.loginMessage = this.createMessage(jsonObject.toString());
        TapTapLoginTrackerHelper.authorizationOpen("cloud_play");
        if (this.cloudGameInitializeFinish != null && !this.checkSupportLogin(this.cloudGameInitializeFinish)) {
            this.failedCallback();
            return;
        }
        if (this.messenger != null && this.cloudGameInitializeFinish != null) {
            this.messenger.send(this.loginMessage);
        }
        TapTapLoginTrackerHelper.authorizationBack();
    }

    private void sendConfigInfoMessage() {
        try {
            String sdkInfo = LoginRequest.generateSDKInfo(this.activityDelegate.block.getActivity(), this.loginRequest.isPreApproved());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)"initialize");
            jsonObject.put("message_id", (Object)this.initializeMid);
            JSONObject dataJsonObject = new JSONObject();
            dataJsonObject.put("package_name", (Object)this.activityDelegate.block.getActivity().getPackageName());
            dataJsonObject.put("sdk_info", (Object)sdkInfo);
            JSONObject cgpnObject = new JSONObject();
            JSONArray loginVersionJsonArray = new JSONArray();
            for (String version : this.sdkLoginVersionArrayList) {
                loginVersionJsonArray.put((Object)version);
            }
            cgpnObject.put("login", (Object)loginVersionJsonArray);
            dataJsonObject.put("CGPN", (Object)cgpnObject);
            jsonObject.put("data", (Object)dataJsonObject);
            Message message = this.createMessage(jsonObject.toString());
            this.messenger.send(message);
        }
        catch (Exception e) {
            this.failedCallback();
        }
    }

    private void sendMiddleLayerInitMessage() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)"middle_layer_init");
            jsonObject.put("package_name", (Object)this.activityDelegate.block.getActivity().getPackageName());
            Message message = this.createMessage(jsonObject.toString());
            this.messenger.send(message);
        }
        catch (Exception e) {
            this.failedCallback();
        }
    }

    private Message createMessage(String obj) {
        Message message = Message.obtain();
        message.what = 10001;
        Bundle bundle = new Bundle();
        bundle.putString("message", obj);
        message.setData(bundle);
        message.replyTo = this.replyMessenger;
        return message;
    }

    public boolean bindCloudGameService() {
        if (this.activityDelegate != null && this.activityDelegate.block != null && this.activityDelegate.block.getActivity() != null) {
            Intent intent = new Intent("com.cloud.taptap.gaming.daemon");
            intent.setPackage("com.cloud.taptap.gaming");
            return this.activityDelegate.block.getActivity().bindService(intent, (ServiceConnection)this.cloudGameServiceConnection, 1);
        }
        return false;
    }

    private void sendLoginMessage() {
        if (this.loginMessage == null) {
            return;
        }
        try {
            this.messenger.send(this.loginMessage);
        }
        catch (Exception e) {
            this.failedCallback();
        }
    }

    public static interface OnCloudGameLoginResult {
        public void onLoginFailed();
    }

    private class CloudGameServiceConnection
    implements ServiceConnection {
        private CloudGameServiceConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            CloudGameHandler.this.messenger = new Messenger(service);
            CloudGameHandler.this.sendMiddleLayerInitMessage();
        }

        public void onServiceDisconnected(ComponentName name) {
            CloudGameHandler.this.failedCallback();
        }
    }
}

