/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.ui;

import android.text.TextUtils;
import android.util.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

class CodeUtil {
    CodeUtil() {
    }

    public static String getCodeChallenge(String codeVerifier) {
        return CodeUtil.getEncodeStr(CodeUtil.getSignCode(codeVerifier));
    }

    private static String getEncodeStr(byte[] signCode) {
        if (signCode == null) {
            return null;
        }
        byte[] encoded = Base64.encode((byte[])signCode, (int)11);
        return new String(encoded);
    }

    private static byte[] getSignCode(String codeVerifier) {
        byte[] signCode = null;
        if (TextUtils.isEmpty((CharSequence)codeVerifier)) {
            return null;
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
            digest.update(codeVerifier.getBytes());
            signCode = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signCode;
    }

    public static String getCodeVerifier(int length) {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }
}

