/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.ui;

import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.taptap.sdk.LoginRequest;
import com.taptap.sdk.R;
import com.taptap.sdk.tracker.TapTapLoginTrackerHelper;
import com.taptap.sdk.ui.ActivityDelegate;
import com.taptap.sdk.ui.Block;
import com.taptap.sdk.ui.LoginClient;

class LoginBlock
extends Block {
    private LoginClient client = null;
    private boolean startAuthorizeByClient = false;
    private boolean needRequestAuthorize = true;

    LoginBlock() {
    }

    @Override
    protected View onCreateView(LayoutInflater inflater, ViewGroup container) {
        return inflater.inflate(R.layout.fragment_login, container, false);
    }

    @Override
    protected void onViewCreated(View view) {
        super.onViewCreated(view);
        if (this.needRequestAuthorize) {
            LoginRequest request = (LoginRequest)this.getArguments().getParcelable("request");
            this.client = new LoginClient(new ActivityDelegate(this));
            this.startAuthorizeByClient = this.client.sendLoginRequest(request);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != 0) {
            this.getActivity().setResult(resultCode, data);
        }
        TapTapLoginTrackerHelper.authorizationBack();
        this.getActivity().finish();
    }

    public void setNeedRequestAuthorize(boolean needRequestAuthorize) {
        this.needRequestAuthorize = needRequestAuthorize;
    }

    protected boolean isAuthorizeByClient() {
        return this.startAuthorizeByClient;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.client != null && this.client.getServiceConnection() != null) {
            this.getActivity().unbindService(this.client.getServiceConnection());
        }
    }
}

