/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.ui;

import android.content.ServiceConnection;
import android.text.TextUtils;
import com.taptap.sdk.LoginRequest;
import com.taptap.sdk.TapLoginInnerConfig;
import com.taptap.sdk.TapPhoneLoginManager;
import com.taptap.sdk.tracker.TapTapLoginTrackerHelper;
import com.taptap.sdk.ui.ActivityDelegate;
import com.taptap.sdk.ui.ActivityHandler;
import com.taptap.sdk.ui.CloudGameHandler;
import com.taptap.sdk.ui.CodeUtil;
import com.taptap.sdk.ui.PhoneVerifyHandler;
import com.taptap.sdk.ui.WebViewHandler;

class LoginClient
implements CloudGameHandler.OnCloudGameLoginResult {
    private ActivityHandler activityHandler;
    private WebViewHandler webViewHandler;
    private CloudGameHandler cloudGameHandler;
    private PhoneVerifyHandler phoneVerifyHandler;
    private LoginRequest request;

    public LoginClient(ActivityDelegate activityDelegate) {
        this.cloudGameHandler = new CloudGameHandler(activityDelegate);
        this.activityHandler = new ActivityHandler(activityDelegate);
        this.webViewHandler = new WebViewHandler(activityDelegate);
        this.phoneVerifyHandler = new PhoneVerifyHandler(activityDelegate);
        this.cloudGameHandler.setOnCloudGameLoginResult(this);
    }

    public boolean sendLoginRequest(LoginRequest request) {
        block3: {
            TapLoginInnerConfig.codeVerifier = CodeUtil.getCodeVerifier(128);
            this.initLoginRequest(request);
            this.request = request;
            try {
                if (this.cloudGameHandler == null || !this.cloudGameHandler.bindCloudGameService()) {
                    this.activityHandler.authorize(request);
                    return true;
                }
                this.cloudGameHandler.authorize(request);
            }
            catch (Exception e) {
                TapTapLoginTrackerHelper.authorizationBack();
                if (this.handlePhoneVerify(request) || this.handlePhoneVerify2(request) || this.webViewHandler == null) break block3;
                this.webViewHandler.authorize(request);
            }
        }
        return false;
    }

    @Override
    public void onLoginFailed() {
        TapTapLoginTrackerHelper.authorizationBack();
        if (this.webViewHandler != null && this.request != null) {
            this.webViewHandler.authorize(this.request);
        }
    }

    public ServiceConnection getServiceConnection() {
        if (this.cloudGameHandler != null) {
            return this.cloudGameHandler.getCloudGameServiceConnection();
        }
        return null;
    }

    private void initLoginRequest(LoginRequest request) {
        request.setLoginVersion("1");
        request.setResponseType("code");
        request.setRedirectUri("tapoauth://authorize");
        request.setCodeChallenge(CodeUtil.getCodeChallenge(TapLoginInnerConfig.codeVerifier));
        request.setCodeChallengeMethod("S256");
    }

    private boolean handlePhoneVerify(LoginRequest request) {
        if (TapPhoneLoginManager.getInstance().getClientLoginCallback() != null) {
            this.phoneVerifyHandler.authorize(request);
            final LoginRequest tempRequest = request;
            TapPhoneLoginManager.getInstance().registerPhoneLoginCallback(new TapPhoneLoginManager.PhoneLoginCallback(){

                @Override
                public void continueWebLogin(String token, String preferredLoginType) {
                    TapPhoneLoginManager.getInstance().removePhoneLoginCallback();
                    if (!TextUtils.isEmpty((CharSequence)token)) {
                        tempRequest.setPhoneVerifyToken(token);
                    }
                    if (!TextUtils.isEmpty((CharSequence)preferredLoginType)) {
                        tempRequest.setPreferredLoginType(preferredLoginType);
                    }
                    if (LoginClient.this.webViewHandler != null) {
                        LoginClient.this.webViewHandler.authorize(tempRequest);
                    }
                }

                @Override
                public void cancelLogin() {
                    if (LoginClient.this.webViewHandler.getActivity() != null) {
                        LoginClient.this.webViewHandler.getActivity().finish();
                    }
                }
            });
            TapPhoneLoginManager.getInstance().getClientLoginCallback().clientLoginFail();
            return true;
        }
        return false;
    }

    private boolean handlePhoneVerify2(LoginRequest request) {
        if (TapPhoneLoginManager.getInstance().getClientLoginCallback2() != null) {
            this.phoneVerifyHandler.authorize(request);
            final LoginRequest tempRequest = request;
            TapPhoneLoginManager.getInstance().registerPhoneLoginCallback2(new TapPhoneLoginManager.PhoneLoginCallback2(){

                @Override
                public void continueWebLogin(String token, String preferredLoginType, String ... permissions) {
                    TapPhoneLoginManager.getInstance().removePhoneLoginCallback();
                    if (!TextUtils.isEmpty((CharSequence)token)) {
                        tempRequest.setPhoneVerifyToken(token);
                    }
                    if (!TextUtils.isEmpty((CharSequence)preferredLoginType)) {
                        tempRequest.setPreferredLoginType(preferredLoginType);
                    }
                    if (permissions != null && permissions.length > 0) {
                        tempRequest.setPermissions(permissions);
                    }
                    if (LoginClient.this.webViewHandler != null) {
                        LoginClient.this.webViewHandler.authorize(tempRequest);
                    }
                }

                @Override
                public void cancelLogin() {
                    if (LoginClient.this.webViewHandler.getActivity() != null) {
                        LoginClient.this.webViewHandler.getActivity().finish();
                    }
                }
            });
            TapPhoneLoginManager.getInstance().getClientLoginCallback2().clientLoginFail(request.getPermissions());
            return true;
        }
        return false;
    }
}

