/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.ui;

import android.os.Bundle;
import com.taptap.sdk.LoginRequest;
import com.taptap.sdk.TapLoginInnerConfig;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoginUtils {
    public static Bundle createLoginBundle(LoginRequest request) {
        Bundle bundle = new Bundle();
        bundle.putString("com.taptap.sdk.request.client_id", TapLoginInnerConfig.getClientId());
        bundle.putStringArray("com.taptap.sdk.request.permissions", request.getPermissions());
        bundle.putString("com.taptap.sdk.request.state", request.getState());
        bundle.putString("com.taptap.sdk.request.sdk_version", request.getVersionCode());
        bundle.putBoolean("com.taptap.sdk.request.screen.portrait", TapLoginInnerConfig.isPortrait);
        bundle.putString("com.taptap.sdk.request.info", request.getInfo());
        bundle.putString("com.taptap.sdk.request.login_version", request.getLoginVersion());
        bundle.putString("com.taptap.sdk.request.response_type", request.getResponseType());
        bundle.putString("com.taptap.sdk.request.redirect_uri", request.getRedirectUri());
        bundle.putString("com.taptap.sdk.request.code_challenge", request.getCodeChallenge());
        bundle.putString("com.taptap.sdk.request.code_challenge_method", request.getCodeChallengeMethod());
        JSONObject extraObject = new JSONObject();
        try {
            extraObject.put("preapproved", request.isPreApproved() ? 1 : 0);
            bundle.putString("com.taptap.sdk.request.extra", extraObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bundle;
    }

    public static JSONObject createCloudLoginJsonObject(Bundle loginBundle) {
        JSONObject dataJsonObject = new JSONObject();
        for (String key : loginBundle.keySet()) {
            Object value = loginBundle.get(key);
            try {
                if (value instanceof Boolean) {
                    dataJsonObject.put(key, (Object)((Boolean)value));
                    continue;
                }
                if (value instanceof String[]) {
                    JSONArray jsonArray = new JSONArray();
                    for (String permission2 : (String[])value) {
                        jsonArray.put((Object)permission2);
                    }
                    dataJsonObject.put(key, (Object)jsonArray);
                    continue;
                }
                dataJsonObject.put(key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dataJsonObject;
    }
}

