/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.ui;

import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.taptap.sdk.LoginRequest;
import com.taptap.sdk.R;
import com.taptap.sdk.Utils;
import com.taptap.sdk.ui.Block;
import com.taptap.sdk.ui.BlockActivity;
import com.taptap.sdk.ui.BlockManager;
import com.taptap.sdk.ui.LoginBlock;
import com.taptap.sdk.ui.WebBlock;

public class TapTapActivity
extends BlockActivity {
    private static boolean isRequesting = false;
    private boolean isFinishByDuplicateCreated = false;
    private boolean isRecreateAndLoginByClient = false;
    private static final String RECREATE_AND_USE_CLIENT_KEY = "recreate_and_use_client";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        LoginRequest request;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.isRecreateAndLoginByClient = savedInstanceState.getBoolean(RECREATE_AND_USE_CLIENT_KEY, false);
        }
        Log.d((String)"TapLoginResult", (String)("TapTapLogin create isRecreate = " + this.isRecreateAndLoginByClient + " isRequesting = " + isRequesting));
        if (!Utils.isLoginSDKInitialized() || isRequesting) {
            if (isRequesting) {
                this.isFinishByDuplicateCreated = true;
            }
            this.finish();
            return;
        }
        this.setContentView(R.layout.sdk_activity_container);
        Window window = this.getWindow();
        if (window != null) {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            if (Build.VERSION.SDK_INT >= 28) {
                layoutParams.layoutInDisplayCutoutMode = 1;
                View decorView = window.getDecorView();
                decorView.setSystemUiVisibility(1280);
            }
            window.setAttributes(layoutParams);
        }
        if (null != this.getIntent() && null != (request = (LoginRequest)this.getIntent().getParcelableExtra("request"))) {
            LoginBlock block = new LoginBlock();
            block.setNeedRequestAuthorize(!this.isRecreateAndLoginByClient);
            Bundle bundle = new Bundle();
            bundle.putParcelable("request", (Parcelable)request);
            block.setArguments(bundle);
            this.getBlockManager().add(R.id.taptap_sdk_container, (Block)block);
        }
        isRequesting = true;
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Log.d((String)"TapLoginResult", (String)"TapTapLogin onSaveInstanceState ");
        boolean loginByClient = false;
        Block current = this.getBlockManager().getCurrent();
        if (null != current && current instanceof LoginBlock) {
            loginByClient = ((LoginBlock)current).isAuthorizeByClient();
        }
        outState.putBoolean(RECREATE_AND_USE_CLIENT_KEY, loginByClient);
        Log.d((String)"TapLoginResult", (String)("TapTapLogin onSaveInstanceState lastUseClient = " + loginByClient));
    }

    protected void onResume() {
        super.onResume();
        this.setLayout(this.getResources().getConfiguration());
    }

    public void setLayout(Configuration configuration) {
    }

    public void onBackPressed() {
        Block current = this.getBlockManager().getCurrent();
        if (null != current && current instanceof WebBlock) {
            this.finish();
            return;
        }
        super.onBackPressed();
    }

    @Override
    public void onConfigurationChanged(Configuration config) {
        super.onConfigurationChanged(config);
        this.setLayout(config);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.d((String)"TapLoginResult", (String)("TapTapLogin onActivityResult resultCode = " + resultCode));
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            BlockManager bm = this.getBlockManager();
            if (bm != null) {
                bm.remove(bm.getCurrent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.d((String)"TapLoginResult", (String)"TapTapLogin destroy");
        if (!this.isFinishByDuplicateCreated) {
            isRequesting = false;
        }
    }
}

